/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.CommitResultHandler;
import com.intellij.vcs.commit.AbstractCommitter;
import com.intellij.vcs.commit.CommitExceptionWithActions;
import com.intellij.vcs.commit.ShowNotificationCommitResultHandlerKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nH\u0003J\r\u0010\u000b\u001a\u00070\t\u00a2\u0006\u0002\b\fH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\tH\u0016J\b\u0010\u0015\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/vcs/commit/ShowNotificationCommitResultHandler;", "Lcom/intellij/openapi/vcs/changes/CommitResultHandler;", "committer", "Lcom/intellij/vcs/commit/AbstractCommitter;", "(Lcom/intellij/vcs/commit/AbstractCommitter;)V", "notifier", "Lcom/intellij/openapi/vcs/VcsNotifier;", "kotlin.jvm.PlatformType", "getCommitSummary", "", "Lcom/intellij/openapi/util/NlsSafe;", "getFileSummaryReport", "Lorg/jetbrains/annotations/Nls;", "onCancel", "", "onFailure", "errors", "", "Lcom/intellij/openapi/vcs/VcsException;", "onSuccess", "commitMessage", "reportResult", "intellij.platform.vcs.impl"})
public final class ShowNotificationCommitResultHandler
implements CommitResultHandler {
    private final VcsNotifier notifier;
    private final AbstractCommitter committer;

    public void onSuccess(@NotNull String commitMessage2) {
        Intrinsics.checkNotNullParameter((Object)commitMessage2, (String)"commitMessage");
        this.reportResult();
    }

    public void onCancel() {
        this.notifier.notifyMinorWarning("vcs.commit.canceled", "", VcsBundle.message((String)"vcs.commit.canceled", (Object[])new Object[0]));
    }

    public void onFailure(@NotNull List<? extends VcsException> errors) {
        Intrinsics.checkNotNullParameter(errors, (String)"errors");
        this.reportResult();
    }

    /*
     * WARNING - void declaration
     */
    private final void reportResult() {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        void $this$filterIsInstanceTo$iv$iv;
        String message2 = this.getCommitSummary();
        List<VcsException> allExceptions = this.committer.getExceptions();
        if (allExceptions.isEmpty()) {
            this.notifier.notifySuccess("vcs.commit.finished", "", message2);
            return;
        }
        List<VcsException> errors = AbstractCommitter.Companion.collectErrors(allExceptions);
        int errorsSize = errors.size();
        int warningsSize = allExceptions.size() - errorsSize;
        Iterable $this$filterIsInstance$iv = allExceptions;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof CommitExceptionWithActions)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterIsInstanceTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            CommitExceptionWithActions it = (CommitExceptionWithActions)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getActions();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List notificationActions = (List)destination$iv$iv;
        String title2 = null;
        String displayId = null;
        NotificationType notificationType = null;
        if (errorsSize > 0) {
            displayId = "vcs.commit.failed";
            String string = VcsBundle.message((String)"message.text.commit.failed.with.error", (Object[])new Object[]{errorsSize});
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"message.text.co\u2026.with.error\", errorsSize)");
            title2 = string;
            notificationType = NotificationType.ERROR;
        } else {
            displayId = "vcs.commit.finished.with.warnings";
            String string = VcsBundle.message((String)"message.text.commit.finished.with.warning", (Object[])new Object[]{warningsSize});
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"message.text.co\u2026h.warning\", warningsSize)");
            title2 = string;
            notificationType = NotificationType.WARNING;
        }
        Notification notification = VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.createNotification(title2, message2, notificationType);
        notification.setDisplayId(displayId);
        Iterable $this$forEach$iv = notificationActions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NotificationAction it = (NotificationAction)element$iv;
            boolean bl = false;
            notification.addAction((AnAction)it);
        }
        notification.addAction((AnAction)this.notifier.createShowDetailsAction());
        notification.notify(this.committer.getProject());
    }

    /*
     * WARNING - void declaration
     */
    @NlsContexts.NotificationContent
    private final String getCommitSummary() {
        List<VcsException> exceptions;
        HtmlChunk htmlChunk;
        Collection<HtmlChunk> collection;
        Collection destination$iv$iv;
        HtmlBuilder htmlBuilder;
        HtmlChunk htmlChunk2;
        HtmlBuilder htmlBuilder2 = new HtmlBuilder();
        boolean bl = false;
        boolean bl2 = false;
        HtmlBuilder $this$apply = htmlBuilder2;
        boolean bl3 = false;
        $this$apply.append(this.getFileSummaryReport());
        String commitMessage2 = this.committer.getCommitMessage();
        if (!StringUtil.isEmpty((String)commitMessage2)) {
            $this$apply.append(": ").append(commitMessage2);
        }
        Set<String> feedback = this.committer.getFeedback();
        Iterable iterable = feedback;
        boolean bl4 = false;
        if (!iterable.isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            $this$apply.br();
            iterable = feedback;
            htmlChunk2 = (HtmlChunk)HtmlChunk.br();
            htmlBuilder = $this$apply;
            boolean $i$f$map = false;
            void var12_13 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p1;
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl5 = false;
                htmlChunk = HtmlChunk.text((String)p1);
                collection.add(htmlChunk);
            }
            collection = (List)destination$iv$iv;
            htmlBuilder.appendWithSeparators(htmlChunk2, (Iterable)collection);
        }
        if (!ShowNotificationCommitResultHandlerKt.access$hasOnlyWarnings(exceptions = this.committer.getExceptions())) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            $this$apply.br();
            Iterable $i$f$map = exceptions;
            htmlChunk2 = (HtmlChunk)HtmlChunk.br();
            htmlBuilder = $this$apply;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VcsException bl5 = (VcsException)((Object)item$iv$iv);
                collection = destination$iv$iv2;
                boolean bl6 = false;
                htmlChunk = HtmlChunk.text((String)it.getMessage());
                collection.add(htmlChunk);
            }
            collection = (List)destination$iv$iv2;
            htmlBuilder.appendWithSeparators(htmlChunk2, (Iterable)collection);
        }
        String string = htmlBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"HtmlBuilder().apply {\n  \u2026) })\n    }\n  }.toString()");
        return string;
    }

    private final String getFileSummaryReport() {
        int failed = this.committer.getFailedToCommitChanges().size();
        int committed = this.committer.getChanges().size() - failed;
        if (failed > 0) {
            String string = VcsBundle.message((String)"vcs.commit.files.committed.and.files.failed.to.commit", (Object[])new Object[]{committed, failed});
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"vcs.commit.file\u2026mmit\", committed, failed)");
            return string;
        }
        String string = VcsBundle.message((String)"vcs.commit.files.committed", (Object[])new Object[]{committed});
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"vcs.commit.files.committed\", committed)");
        return string;
    }

    public ShowNotificationCommitResultHandler(@NotNull AbstractCommitter committer) {
        Intrinsics.checkNotNullParameter((Object)committer, (String)"committer");
        this.committer = committer;
        this.notifier = VcsNotifier.getInstance(this.committer.getProject());
    }
}

