/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.print;

import com.intellij.vcs.log.graph.GraphColorManager;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.NormalEdge;
import org.jetbrains.annotations.NotNull;

public class ColorGetterByLayoutIndex<CommitId> {
    @NotNull
    private final LinearGraph myLinearGraph;
    @NotNull
    private final PermanentGraphInfo<CommitId> myPermanentGraphInfo;
    @NotNull
    private final GraphColorManager<CommitId> myColorManager;

    public ColorGetterByLayoutIndex(@NotNull LinearGraph linearGraph, @NotNull PermanentGraphInfo<CommitId> permanentGraphInfo, @NotNull GraphColorManager<CommitId> colorManager) {
        if (linearGraph == null) {
            ColorGetterByLayoutIndex.$$$reportNull$$$0(0);
        }
        if (permanentGraphInfo == null) {
            ColorGetterByLayoutIndex.$$$reportNull$$$0(1);
        }
        if (colorManager == null) {
            ColorGetterByLayoutIndex.$$$reportNull$$$0(2);
        }
        this.myLinearGraph = linearGraph;
        this.myPermanentGraphInfo = permanentGraphInfo;
        this.myColorManager = colorManager;
    }

    public int getColorId(@NotNull GraphElement element2) {
        int downLayoutIndex;
        if (element2 == null) {
            ColorGetterByLayoutIndex.$$$reportNull$$$0(3);
        }
        if (element2 instanceof GraphNode) {
            int nodeId = this.myLinearGraph.getNodeId(((GraphNode)element2).getNodeIndex());
            return this.getNodeColor(nodeId, this.getLayoutIndex(nodeId));
        }
        GraphEdge edge = (GraphEdge)element2;
        NormalEdge normalEdge = LinearGraphUtils.asNormalEdge(edge);
        if (normalEdge == null) {
            int nodeId = this.myLinearGraph.getNodeId(LinearGraphUtils.getNotNullNodeIndex(edge));
            return this.getNodeColor(nodeId, this.getLayoutIndex(nodeId));
        }
        int upNodeId = this.myLinearGraph.getNodeId(normalEdge.up);
        int downNodeId = this.myLinearGraph.getNodeId(normalEdge.down);
        int upLayoutIndex = this.getLayoutIndex(upNodeId);
        if (upLayoutIndex >= (downLayoutIndex = this.getLayoutIndex(downNodeId))) {
            return this.getNodeColor(upNodeId, upLayoutIndex);
        }
        return this.getNodeColor(downNodeId, downLayoutIndex);
    }

    private int getNodeColor(int nodeId, int layoutIndex) {
        int headNodeId = this.getHeadNodeId(nodeId);
        CommitId headCommitId = this.myPermanentGraphInfo.getPermanentCommitsInfo().getCommitId(headNodeId);
        if (layoutIndex == this.myPermanentGraphInfo.getPermanentGraphLayout().getLayoutIndex(headNodeId)) {
            return this.myColorManager.getColorOfBranch(headCommitId);
        }
        return this.myColorManager.getColorOfFragment(headCommitId, layoutIndex);
    }

    private int getHeadNodeId(int nodeId) {
        if (nodeId < 0) {
            return 0;
        }
        return this.myPermanentGraphInfo.getPermanentGraphLayout().getOneOfHeadNodeIndex(nodeId);
    }

    private int getLayoutIndex(int nodeId) {
        if (nodeId < 0) {
            return nodeId;
        }
        return this.myPermanentGraphInfo.getPermanentGraphLayout().getLayoutIndex(nodeId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linearGraph";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "permanentGraphInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/graph/impl/print/ColorGetterByLayoutIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getColorId";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

