/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcsUtil;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.IgnoredFileContentProvider;
import com.intellij.openapi.vcs.changes.IgnoredFileGenerator;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public final class VcsImplUtil {
    private static final Logger LOG = Logger.getInstance(VcsImplUtil.class);

    public static void showErrorMessage(Project project, @NlsContexts.DialogMessage String message2, @NlsContexts.DialogTitle String title2) {
        Runnable task2 = () -> Messages.showErrorDialog((Project)project, (String)message2, (String)title2);
        WaitForProgressToShow.runOrInvokeLaterAboveProgress((Runnable)task2, null, (Project)project);
    }

    @NlsSafe
    @NotNull
    public static String getShortVcsRootName(@NotNull Project project, @NotNull VirtualFile root) {
        String relativePath;
        if (project == null) {
            VcsImplUtil.$$$reportNull$$$0(0);
        }
        if (root == null) {
            VcsImplUtil.$$$reportNull$$$0(1);
        }
        VirtualFile projectDir = project.getBaseDir();
        String repositoryPath = root.getPresentableUrl();
        if (projectDir != null && (relativePath = VfsUtilCore.getRelativePath((VirtualFile)root, (VirtualFile)projectDir, (char)File.separatorChar)) != null) {
            repositoryPath = relativePath;
        }
        String string = repositoryPath.isEmpty() ? root.getName() : repositoryPath;
        if (string == null) {
            VcsImplUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public static IgnoredFileContentProvider findIgnoredFileContentProvider(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            VcsImplUtil.$$$reportNull$$$0(3);
        }
        return VcsImplUtil.findIgnoredFileContentProvider(vcs.getProject(), vcs.getKeyInstanceMethod());
    }

    @Nullable
    public static IgnoredFileContentProvider findIgnoredFileContentProvider(@NotNull Project project, @NotNull VcsKey vcsKey) {
        IgnoredFileContentProvider ignoreContentProvider;
        if (project == null) {
            VcsImplUtil.$$$reportNull$$$0(4);
        }
        if (vcsKey == null) {
            VcsImplUtil.$$$reportNull$$$0(5);
        }
        if ((ignoreContentProvider = (IgnoredFileContentProvider)IgnoredFileContentProvider.IGNORE_FILE_CONTENT_PROVIDER.extensions((AreaInstance)project).filter(provider2 -> provider2.getSupportedVcs().equals((Object)vcsKey)).findFirst().orElse(null)) == null) {
            LOG.debug("Cannot get ignore content provider for vcs " + vcsKey.getName());
            return null;
        }
        return ignoreContentProvider;
    }

    public static void proposeUpdateIgnoreFile(@NotNull Project project, @NotNull AbstractVcs vcs, @NotNull VirtualFile ignoreFileRoot) {
        if (project == null) {
            VcsImplUtil.$$$reportNull$$$0(6);
        }
        if (vcs == null) {
            VcsImplUtil.$$$reportNull$$$0(7);
        }
        if (ignoreFileRoot == null) {
            VcsImplUtil.$$$reportNull$$$0(8);
        }
        VcsImplUtil.generateIgnoreFile(project, vcs, ignoreFileRoot, true);
    }

    public static void generateIgnoreFileIfNeeded(@NotNull Project project, @NotNull AbstractVcs vcs, @NotNull VirtualFile ignoreFileRoot) {
        if (project == null) {
            VcsImplUtil.$$$reportNull$$$0(9);
        }
        if (vcs == null) {
            VcsImplUtil.$$$reportNull$$$0(10);
        }
        if (ignoreFileRoot == null) {
            VcsImplUtil.$$$reportNull$$$0(11);
        }
        VcsImplUtil.generateIgnoreFile(project, vcs, ignoreFileRoot, false);
    }

    private static void generateIgnoreFile(@NotNull Project project, @NotNull AbstractVcs vcs, @NotNull VirtualFile ignoreFileRoot, boolean notify2) {
        IgnoredFileGenerator ignoredFileGenerator;
        if (project == null) {
            VcsImplUtil.$$$reportNull$$$0(12);
        }
        if (vcs == null) {
            VcsImplUtil.$$$reportNull$$$0(13);
        }
        if (ignoreFileRoot == null) {
            VcsImplUtil.$$$reportNull$$$0(14);
        }
        if ((ignoredFileGenerator = (IgnoredFileGenerator)project.getService(IgnoredFileGenerator.class)) == null) {
            LOG.debug("Cannot find ignore file ignoredFileGenerator for " + vcs.getName() + " VCS");
            return;
        }
        ignoredFileGenerator.generateFile(ignoreFileRoot, vcs, notify2);
    }

    private static boolean isFileSharedInVcs(@NotNull Project project, @NotNull ChangeListManager changeListManager, @NotNull String filePath) {
        VirtualFile file2;
        if (project == null) {
            VcsImplUtil.$$$reportNull$$$0(15);
        }
        if (changeListManager == null) {
            VcsImplUtil.$$$reportNull$$$0(16);
        }
        if (filePath == null) {
            VcsImplUtil.$$$reportNull$$$0(17);
        }
        if ((file2 = LocalFileSystem.getInstance().findFileByPath(filePath)) == null) {
            return false;
        }
        FileStatus fileStatus = changeListManager.getStatus(file2);
        return VcsUtil.isFileUnderVcs((Project)project, (String)filePath) && fileStatus != FileStatus.UNKNOWN && fileStatus != FileStatus.IGNORED;
    }

    public static boolean isProjectSharedInVcs(@NotNull Project project) {
        if (project == null) {
            VcsImplUtil.$$$reportNull$$$0(18);
        }
        return (Boolean)ReadAction.compute(() -> {
            if (project.isDisposed()) {
                return false;
            }
            @SystemIndependent String projectFilePath = project.getProjectFilePath();
            ChangeListManagerEx changeListManager = ChangeListManagerEx.getInstanceEx(project);
            return !changeListManager.isInUpdate() && projectFilePath != null && VcsImplUtil.isFileSharedInVcs(project, changeListManager, projectFilePath);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcsUtil/VcsImplUtil";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsKey";
                break;
            }
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoreFileRoot";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeListManager";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcsUtil/VcsImplUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortVcsRootName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getShortVcsRootName";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findIgnoredFileContentProvider";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "proposeUpdateIgnoreFile";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "generateIgnoreFileIfNeeded";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "generateIgnoreFile";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isFileSharedInVcs";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isProjectSharedInVcs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

