/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.workspaceModel.storage.impl.url.VirtualFileUrlImpl;
import com.intellij.workspaceModel.storage.impl.url.VirtualFileUrlManagerImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\u000e\u001a\u00020\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\n\u0010\u0011\u001a\u0004\u0018\u00010\u000bH\u0002J\n\u0010\u0012\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\u0013\u001a\u00020\u0004H\u0016J\b\u0010\u0014\u001a\u00020\bH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/workspaceModel/ide/impl/VirtualFileUrlBridge;", "Lcom/intellij/workspaceModel/storage/impl/url/VirtualFileUrlImpl;", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointer;", "id", "", "manager", "Lcom/intellij/workspaceModel/storage/impl/url/VirtualFileUrlManagerImpl;", "initializeVirtualFileLazily", "", "(ILcom/intellij/workspaceModel/storage/impl/url/VirtualFileUrlManagerImpl;Z)V", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "timestampOfCachedFiles", "", "equals", "other", "", "findVirtualFile", "getFile", "hashCode", "isValid", "toString", "", "intellij.platform.projectModel.impl"})
public final class VirtualFileUrlBridge
extends VirtualFileUrlImpl
implements VirtualFilePointer {
    private volatile VirtualFile file;
    private volatile long timestampOfCachedFiles;

    @Nullable
    public VirtualFile getFile() {
        return this.findVirtualFile();
    }

    public boolean isValid() {
        return this.findVirtualFile() != null;
    }

    @Override
    @NotNull
    public String toString() {
        return this.getUrl();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.workspaceModel.ide.impl.VirtualFileUrlBridge");
        }
        VirtualFileUrlBridge cfr_ignored_0 = (VirtualFileUrlBridge)object2;
        return this.getId() == ((VirtualFileUrlBridge)other).getId();
    }

    @Override
    public int hashCode() {
        return this.getId();
    }

    private final VirtualFile findVirtualFile() {
        VirtualFile virtualFile2;
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileManager, (String)"VirtualFileManager.getInstance()");
        VirtualFileManager fileManager = virtualFileManager;
        long timestamp = this.timestampOfCachedFiles;
        VirtualFile cachedResults = this.file;
        if (timestamp == fileManager.getModificationCount()) {
            virtualFile2 = cachedResults;
        } else {
            this.file = fileManager.findFileByUrl(this.getUrl());
            this.timestampOfCachedFiles = fileManager.getModificationCount();
            virtualFile2 = this.file;
        }
        return virtualFile2;
    }

    public VirtualFileUrlBridge(int id2, @NotNull VirtualFileUrlManagerImpl manager2, boolean initializeVirtualFileLazily) {
        Intrinsics.checkNotNullParameter((Object)manager2, (String)"manager");
        super(id2, manager2);
        this.timestampOfCachedFiles = -1L;
        if (!initializeVirtualFileLazily) {
            this.findVirtualFile();
        }
    }
}

