/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.jps.serialization;

import com.intellij.openapi.project.ExternalStorageConfigurationManager;
import com.intellij.workspaceModel.ide.JpsFileEntitySource;
import com.intellij.workspaceModel.ide.JpsProjectConfigLocation;
import com.intellij.workspaceModel.ide.impl.jps.serialization.CachingJpsFileContentReader;
import com.intellij.workspaceModel.ide.impl.jps.serialization.ErrorReporter;
import com.intellij.workspaceModel.ide.impl.jps.serialization.ExternalModuleListSerializer;
import com.intellij.workspaceModel.ide.impl.jps.serialization.FileInDirectorySourceNames;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsArtifactsDirectorySerializerFactory;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsArtifactsExternalFileSerializer;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsArtifactsFileSerializer;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsDirectoryEntitiesSerializerFactory;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsExternalStorageMapping;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsExternalStorageMappingImpl;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsFileContentReader;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsFileEntityTypeSerializer;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsLibrariesDirectorySerializerFactory;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsLibrariesExternalFileSerializer;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsLibrariesFileSerializer;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsProjectSerializers;
import com.intellij.workspaceModel.ide.impl.jps.serialization.ModuleImlFileEntitiesSerializer;
import com.intellij.workspaceModel.ide.impl.jps.serialization.ModuleListSerializerImpl;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageBuilder;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryTableId;
import com.intellij.workspaceModel.storage.impl.url.VirtualFileUrlImplKt;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlManager;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J8\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002JF\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0002JD\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J=\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b'J.\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010\r\u001a\u00020\u000eJ0\u0010(\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&2\u0006\u0010\r\u001a\u00020\u000eH\u0007\u00a8\u0006)"}, d2={"Lcom/intellij/workspaceModel/ide/impl/jps/serialization/JpsProjectEntitiesLoader;", "", "()V", "createDirectoryProjectSerializers", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/JpsProjectSerializers;", "configLocation", "Lcom/intellij/workspaceModel/ide/JpsProjectConfigLocation$DirectoryBased;", "reader", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/JpsFileContentReader;", "externalStorageMapping", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/JpsExternalStorageMapping;", "serializeArtifacts", "", "virtualFileManager", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrlManager;", "externalStorageConfigurationManager", "Lcom/intellij/openapi/project/ExternalStorageConfigurationManager;", "fileInDirectorySourceNames", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/FileInDirectorySourceNames;", "createIprProjectSerializers", "Lcom/intellij/workspaceModel/ide/JpsProjectConfigLocation$FileBased;", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/JpsExternalStorageMappingImpl;", "createProjectEntitiesSerializers", "Lcom/intellij/workspaceModel/ide/JpsProjectConfigLocation;", "externalStoragePath", "Ljava/nio/file/Path;", "createProjectSerializers", "isExternalStorageEnabled", "ideaFolderPath", "", "loadModule", "", "moduleFile", "source", "Lcom/intellij/workspaceModel/ide/JpsFileEntitySource$FileInDirectory;", "builder", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorageBuilder;", "errorReporter", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/ErrorReporter;", "loadModule$intellij_platform_workspaceModel_jps", "loadProject", "intellij.platform.workspaceModel.jps"})
public final class JpsProjectEntitiesLoader {
    @NotNull
    public static final JpsProjectEntitiesLoader INSTANCE;

    @NotNull
    public final JpsProjectSerializers createProjectSerializers(@NotNull JpsProjectConfigLocation configLocation, @NotNull JpsFileContentReader reader, @NotNull Path externalStoragePath, boolean serializeArtifacts, @NotNull VirtualFileUrlManager virtualFileManager, @Nullable ExternalStorageConfigurationManager externalStorageConfigurationManager, @NotNull FileInDirectorySourceNames fileInDirectorySourceNames) {
        Intrinsics.checkNotNullParameter((Object)configLocation, (String)"configLocation");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)externalStoragePath, (String)"externalStoragePath");
        Intrinsics.checkNotNullParameter((Object)virtualFileManager, (String)"virtualFileManager");
        Intrinsics.checkNotNullParameter((Object)fileInDirectorySourceNames, (String)"fileInDirectorySourceNames");
        return this.createProjectEntitiesSerializers(configLocation, reader, externalStoragePath, serializeArtifacts, virtualFileManager, externalStorageConfigurationManager, fileInDirectorySourceNames);
    }

    public static /* synthetic */ JpsProjectSerializers createProjectSerializers$default(JpsProjectEntitiesLoader jpsProjectEntitiesLoader, JpsProjectConfigLocation jpsProjectConfigLocation, JpsFileContentReader jpsFileContentReader, Path path2, boolean bl, VirtualFileUrlManager virtualFileUrlManager, ExternalStorageConfigurationManager externalStorageConfigurationManager, FileInDirectorySourceNames fileInDirectorySourceNames, int n, Object object) {
        if ((n & 0x20) != 0) {
            externalStorageConfigurationManager = null;
        }
        if ((n & 0x40) != 0) {
            fileInDirectorySourceNames = FileInDirectorySourceNames.Companion.empty();
        }
        return jpsProjectEntitiesLoader.createProjectSerializers(jpsProjectConfigLocation, jpsFileContentReader, path2, bl, virtualFileUrlManager, externalStorageConfigurationManager, fileInDirectorySourceNames);
    }

    @TestOnly
    @NotNull
    public final JpsProjectSerializers loadProject(@NotNull JpsProjectConfigLocation configLocation, @NotNull WorkspaceEntityStorageBuilder builder2, @NotNull Path externalStoragePath, @NotNull ErrorReporter errorReporter, @NotNull VirtualFileUrlManager virtualFileManager) {
        Intrinsics.checkNotNullParameter((Object)configLocation, (String)"configLocation");
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)externalStoragePath, (String)"externalStoragePath");
        Intrinsics.checkNotNullParameter((Object)errorReporter, (String)"errorReporter");
        Intrinsics.checkNotNullParameter((Object)virtualFileManager, (String)"virtualFileManager");
        CachingJpsFileContentReader reader = new CachingJpsFileContentReader(configLocation.getBaseDirectoryUrlString());
        JpsProjectSerializers data2 = JpsProjectEntitiesLoader.createProjectEntitiesSerializers$default(this, configLocation, reader, externalStoragePath, true, virtualFileManager, null, null, 96, null);
        data2.loadAll(reader, builder2, errorReporter, null);
        return data2;
    }

    public final void loadModule(@NotNull Path moduleFile, @NotNull JpsProjectConfigLocation configLocation, @NotNull WorkspaceEntityStorageBuilder builder2, @NotNull ErrorReporter errorReporter, @NotNull VirtualFileUrlManager virtualFileManager) {
        Intrinsics.checkNotNullParameter((Object)moduleFile, (String)"moduleFile");
        Intrinsics.checkNotNullParameter((Object)configLocation, (String)"configLocation");
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)errorReporter, (String)"errorReporter");
        Intrinsics.checkNotNullParameter((Object)virtualFileManager, (String)"virtualFileManager");
        Path path2 = moduleFile.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"moduleFile.parent");
        JpsFileEntitySource.FileInDirectory source = new JpsFileEntitySource.FileInDirectory(VirtualFileUrlImplKt.toVirtualFileUrl(path2, virtualFileManager), configLocation);
        this.loadModule$intellij_platform_workspaceModel_jps(moduleFile, source, configLocation, builder2, errorReporter, virtualFileManager);
    }

    public final void loadModule$intellij_platform_workspaceModel_jps(@NotNull Path moduleFile, @NotNull JpsFileEntitySource.FileInDirectory source, @NotNull JpsProjectConfigLocation configLocation, @NotNull WorkspaceEntityStorageBuilder builder2, @NotNull ErrorReporter errorReporter, @NotNull VirtualFileUrlManager virtualFileManager) {
        Intrinsics.checkNotNullParameter((Object)moduleFile, (String)"moduleFile");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)configLocation, (String)"configLocation");
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)errorReporter, (String)"errorReporter");
        Intrinsics.checkNotNullParameter((Object)virtualFileManager, (String)"virtualFileManager");
        CachingJpsFileContentReader reader = new CachingJpsFileContentReader(configLocation.getBaseDirectoryUrlString());
        ModuleImlFileEntitiesSerializer serializer2 = ModuleListSerializerImpl.Companion.createModuleEntitiesSerializer$intellij_platform_workspaceModel_jps$default(ModuleListSerializerImpl.Companion, VirtualFileUrlImplKt.toVirtualFileUrl(moduleFile, virtualFileManager), null, source, virtualFileManager, null, null, null, 112, null);
        serializer2.loadEntities(builder2, reader, errorReporter, virtualFileManager);
    }

    private final JpsProjectSerializers createProjectEntitiesSerializers(JpsProjectConfigLocation configLocation, JpsFileContentReader reader, Path externalStoragePath, boolean serializeArtifacts, VirtualFileUrlManager virtualFileManager, ExternalStorageConfigurationManager externalStorageConfigurationManager, FileInDirectorySourceNames fileInDirectorySourceNames) {
        JpsProjectSerializers jpsProjectSerializers;
        VirtualFileUrl externalStorageRoot = VirtualFileUrlImplKt.toVirtualFileUrl(externalStoragePath, virtualFileManager);
        JpsExternalStorageMappingImpl externalStorageMapping = new JpsExternalStorageMappingImpl(externalStorageRoot, configLocation);
        JpsProjectConfigLocation jpsProjectConfigLocation = configLocation;
        if (jpsProjectConfigLocation instanceof JpsProjectConfigLocation.FileBased) {
            jpsProjectSerializers = this.createIprProjectSerializers((JpsProjectConfigLocation.FileBased)configLocation, reader, externalStorageMapping, serializeArtifacts, virtualFileManager, fileInDirectorySourceNames);
        } else if (jpsProjectConfigLocation instanceof JpsProjectConfigLocation.DirectoryBased) {
            jpsProjectSerializers = this.createDirectoryProjectSerializers((JpsProjectConfigLocation.DirectoryBased)configLocation, reader, externalStorageMapping, serializeArtifacts, virtualFileManager, externalStorageConfigurationManager, fileInDirectorySourceNames);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return jpsProjectSerializers;
    }

    static /* synthetic */ JpsProjectSerializers createProjectEntitiesSerializers$default(JpsProjectEntitiesLoader jpsProjectEntitiesLoader, JpsProjectConfigLocation jpsProjectConfigLocation, JpsFileContentReader jpsFileContentReader, Path path2, boolean bl, VirtualFileUrlManager virtualFileUrlManager, ExternalStorageConfigurationManager externalStorageConfigurationManager, FileInDirectorySourceNames fileInDirectorySourceNames, int n, Object object) {
        if ((n & 0x20) != 0) {
            externalStorageConfigurationManager = null;
        }
        if ((n & 0x40) != 0) {
            fileInDirectorySourceNames = FileInDirectorySourceNames.Companion.empty();
        }
        return jpsProjectEntitiesLoader.createProjectEntitiesSerializers(jpsProjectConfigLocation, jpsFileContentReader, path2, bl, virtualFileUrlManager, externalStorageConfigurationManager, fileInDirectorySourceNames);
    }

    private final JpsProjectSerializers createDirectoryProjectSerializers(JpsProjectConfigLocation.DirectoryBased configLocation, JpsFileContentReader reader, JpsExternalStorageMapping externalStorageMapping, boolean serializeArtifacts, VirtualFileUrlManager virtualFileManager, ExternalStorageConfigurationManager externalStorageConfigurationManager, FileInDirectorySourceNames fileInDirectorySourceNames) {
        String ideaFolderUrl = configLocation.getIdeaFolder().getUrl();
        ArrayList directorySerializersFactories = new ArrayList();
        String librariesDirectoryUrl = ideaFolderUrl + "/libraries";
        String artifactsDirectoryUrl = ideaFolderUrl + "/artifacts";
        Collection collection = directorySerializersFactories;
        JpsDirectoryEntitiesSerializerFactory<LibraryEntity> jpsDirectoryEntitiesSerializerFactory = new JpsLibrariesDirectorySerializerFactory(librariesDirectoryUrl);
        boolean bl = false;
        collection.add(jpsDirectoryEntitiesSerializerFactory);
        if (serializeArtifacts) {
            collection = directorySerializersFactories;
            jpsDirectoryEntitiesSerializerFactory = new JpsArtifactsDirectorySerializerFactory(artifactsDirectoryUrl);
            bl = false;
            collection.add(jpsDirectoryEntitiesSerializerFactory);
        }
        VirtualFileUrl externalStorageRoot = externalStorageMapping.getExternalStorageRoot();
        String string = ideaFolderUrl;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ideaFolderUrl");
        boolean externalStorageEnabled = this.isExternalStorageEnabled(reader, string);
        VirtualFileUrl virtualFileUrl = externalStorageRoot.append("project/libraries.xml");
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileUrl, (String)"externalStorageRoot.appe\u2026(\"project/libraries.xml\")");
        JpsFileEntitySource.ExactFile librariesExternalStorageFile = new JpsFileEntitySource.ExactFile(virtualFileUrl, configLocation);
        ExternalModuleListSerializer externalModuleListSerializer = new ExternalModuleListSerializer(externalStorageRoot, virtualFileManager);
        List entityTypeSerializers = CollectionsKt.mutableListOf((Object[])new JpsFileEntityTypeSerializer[]{new JpsLibrariesExternalFileSerializer(librariesExternalStorageFile, virtualFileManager.fromUrl(librariesDirectoryUrl))});
        if (serializeArtifacts) {
            VirtualFileUrl virtualFileUrl2 = externalStorageRoot.append("project/artifacts.xml");
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileUrl2, (String)"externalStorageRoot.appe\u2026(\"project/artifacts.xml\")");
            JpsFileEntitySource.ExactFile artifactsExternalStorageFile = new JpsFileEntitySource.ExactFile(virtualFileUrl2, configLocation);
            JpsArtifactsExternalFileSerializer artifactsExternalFileSerializer = new JpsArtifactsExternalFileSerializer(artifactsExternalStorageFile, virtualFileManager.fromUrl(artifactsDirectoryUrl), virtualFileManager);
            Collection collection2 = entityTypeSerializers;
            boolean bl2 = false;
            collection2.add(artifactsExternalFileSerializer);
        }
        return JpsProjectSerializers.Companion.createSerializers(entityTypeSerializers, directorySerializersFactories, CollectionsKt.listOf((Object[])new ModuleListSerializerImpl[]{new ModuleListSerializerImpl(ideaFolderUrl + "/modules.xml", virtualFileManager, externalModuleListSerializer, externalStorageConfigurationManager), externalModuleListSerializer}), configLocation, reader, externalStorageMapping, externalStorageEnabled, virtualFileManager, fileInDirectorySourceNames);
    }

    private final boolean isExternalStorageEnabled(JpsFileContentReader reader, String ideaFolderPath) {
        Element component2;
        Element element2 = component2 = JpsFileContentReader.DefaultImpls.loadComponent$default(reader, ideaFolderPath + "/misc.xml", "ExternalStorageConfigurationManager", null, 4, null);
        return Intrinsics.areEqual((Object)(element2 != null ? element2.getAttributeValue("enabled") : null), (Object)"true");
    }

    private final JpsProjectSerializers createIprProjectSerializers(JpsProjectConfigLocation.FileBased configLocation, JpsFileContentReader reader, JpsExternalStorageMappingImpl externalStorageMapping, boolean serializeArtifacts, VirtualFileUrlManager virtualFileManager, FileInDirectorySourceNames fileInDirectorySourceNames) {
        JpsFileEntitySource.ExactFile projectFileSource = new JpsFileEntitySource.ExactFile(configLocation.getIprFile(), configLocation);
        VirtualFileUrl projectFileUrl = projectFileSource.getFile();
        ArrayList entityTypeSerializers = new ArrayList();
        Object object = entityTypeSerializers;
        JpsFileEntityTypeSerializer<LibraryEntity> jpsFileEntityTypeSerializer = new JpsLibrariesFileSerializer(projectFileSource, LibraryTableId.ProjectLibraryTableId.INSTANCE);
        boolean bl = false;
        object.add(jpsFileEntityTypeSerializer);
        if (serializeArtifacts) {
            object = entityTypeSerializers;
            jpsFileEntityTypeSerializer = new JpsArtifactsFileSerializer(projectFileUrl, projectFileSource, virtualFileManager);
            bl = false;
            object.add(jpsFileEntityTypeSerializer);
        }
        List list2 = entityTypeSerializers;
        List list3 = CollectionsKt.emptyList();
        String string = projectFileUrl.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"projectFileUrl.url");
        object = fileInDirectorySourceNames;
        boolean bl2 = false;
        JpsExternalStorageMapping jpsExternalStorageMapping = externalStorageMapping;
        VirtualFileUrlManager virtualFileUrlManager = virtualFileManager;
        return JpsProjectSerializers.Companion.createSerializers(list2, list3, CollectionsKt.listOf((Object)new ModuleListSerializerImpl(string, virtualFileManager, null, null, 12, null)), configLocation, reader, jpsExternalStorageMapping, bl2, virtualFileUrlManager, (FileInDirectorySourceNames)object);
    }

    private JpsProjectEntitiesLoader() {
    }

    static {
        JpsProjectEntitiesLoader jpsProjectEntitiesLoader;
        INSTANCE = jpsProjectEntitiesLoader = new JpsProjectEntitiesLoader();
    }
}

