/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.workspaceModel.storage.CachedValue;
import com.intellij.workspaceModel.storage.VersionedEntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageBuilder;
import com.intellij.workspaceModel.storage.impl.DummyVersionedEntityStorage;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B!\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0006\u0010\u0013\u001a\u00020\u0012R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0012\u0010\f\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u0011\u0010\u000e\u001a\u00028\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lcom/intellij/workspaceModel/storage/impl/DisposableCachedValue;", "R", "Lcom/intellij/openapi/Disposable;", "entityStorage", "Lkotlin/Function0;", "Lcom/intellij/workspaceModel/storage/VersionedEntityStorage;", "cachedValue", "Lcom/intellij/workspaceModel/storage/CachedValue;", "(Lkotlin/jvm/functions/Function0;Lcom/intellij/workspaceModel/storage/CachedValue;)V", "latestStorageModificationCount", "", "Ljava/lang/Long;", "latestValue", "Lcom/intellij/openapi/Disposable;", "value", "getValue", "()Lcom/intellij/openapi/Disposable;", "dispose", "", "dropCache", "intellij.platform.workspaceModel.storage"})
public final class DisposableCachedValue<R extends Disposable>
implements Disposable {
    private R latestValue;
    private Long latestStorageModificationCount;
    private final Function0<VersionedEntityStorage> entityStorage;
    private final CachedValue<R> cachedValue;

    @NotNull
    public final synchronized R getValue() {
        Object currentValue = null;
        VersionedEntityStorage storage2 = (VersionedEntityStorage)this.entityStorage.invoke();
        if (storage2 instanceof DummyVersionedEntityStorage) {
            long storageModificationCount;
            WorkspaceEntityStorage workspaceEntityStorage = storage2.getCurrent();
            if (workspaceEntityStorage == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.WorkspaceEntityStorageBuilder");
            }
            Long l = this.latestStorageModificationCount;
            if (l == null || (storageModificationCount = ((WorkspaceEntityStorageBuilder)workspaceEntityStorage).getModificationCount()) != l) {
                currentValue = (Disposable)storage2.cachedValue(this.cachedValue);
                this.latestStorageModificationCount = storageModificationCount;
            } else {
                R r = this.latestValue;
                Intrinsics.checkNotNull(r);
                currentValue = r;
            }
        } else {
            currentValue = (Disposable)storage2.cachedValue(this.cachedValue);
        }
        R oldValue = this.latestValue;
        if (oldValue != currentValue && oldValue != null) {
            Disposer.dispose(oldValue);
        }
        this.latestValue = currentValue;
        return (R)currentValue;
    }

    public void dispose() {
        this.dropCache();
    }

    public final synchronized void dropCache() {
        R oldValue = this.latestValue;
        if (oldValue != null) {
            ((VersionedEntityStorage)this.entityStorage.invoke()).clearCachedValue(this.cachedValue);
            Disposer.dispose(oldValue);
            this.latestStorageModificationCount = null;
            this.latestValue = null;
        }
    }

    public DisposableCachedValue(@NotNull Function0<? extends VersionedEntityStorage> entityStorage, @NotNull CachedValue<R> cachedValue) {
        Intrinsics.checkNotNullParameter(entityStorage, (String)"entityStorage");
        Intrinsics.checkNotNullParameter(cachedValue, (String)"cachedValue");
        this.entityStorage = entityStorage;
        this.cachedValue = cachedValue;
    }
}

