/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.impl;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorage;
import com.intellij.workspaceModel.storage.impl.EntityStorageSerializerImpl;
import com.intellij.workspaceModel.storage.impl.SimpleEntityTypesResolver;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityStorageBuilderImpl;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityStorageImpl;
import com.intellij.workspaceModel.storage.impl.url.VirtualFileUrlManagerImpl;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000L\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003H\u0002\u001a\b\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0018\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n2\u0006\u0010\f\u001a\u00020\u0001H\u0002\u001a\b\u0010\r\u001a\u00020\u000eH\u0000\u001a\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007\u001a*\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u000e2\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00050\u0016H\u0000\u001a\u0018\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\f\u0010\u001a\u001a\u00020\u0012*\u00020\u0012H\u0002\u001a\u0014\u0010\u001b\u001a\u00020\u0005*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0018H\u0000\u001a\u0014\u0010\u001e\u001a\u00020\u0005*\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0018H\u0000\u00a8\u0006\u001f"}, d2={"ageInDays", "", "file", "Ljava/io/File;", "cleanOldFiles", "", "parentDir", "executingOnTC", "", "formatTime", "", "kotlin.jvm.PlatformType", "timeMs", "getStoreDumpDirectory", "Ljava/nio/file/Path;", "reportErrorAndAttachStorage", "message", "storage", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;", "serializeContent", "path", "howToSerialize", "Lkotlin/Function2;", "Lcom/intellij/workspaceModel/storage/impl/EntityStorageSerializerImpl;", "Ljava/io/OutputStream;", "serializeEntityStorage", "makeSureItsStore", "serializeDiff", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageBuilderImpl;", "stream", "serializeTo", "intellij.platform.workspaceModel.storage"})
public final class ErrorReportingKt {
    @ApiStatus.Internal
    public static final void reportErrorAndAttachStorage(@NotNull String message2, @NotNull WorkspaceEntityStorage storage2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)storage2, (String)"storage");
        WorkspaceEntityStorage workspaceEntityStorage = ErrorReportingKt.makeSureItsStore(storage2);
        if (workspaceEntityStorage == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityStorageImpl");
        }
        ((WorkspaceEntityStorageImpl)workspaceEntityStorage).reportConsistencyIssue(message2, new IllegalStateException(), null, null, null, storage2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void serializeContent(@NotNull Path path2, @NotNull Function2<? super EntityStorageSerializerImpl, ? super OutputStream, Unit> howToSerialize) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter(howToSerialize, (String)"howToSerialize");
        EntityStorageSerializerImpl serializer2 = new EntityStorageSerializerImpl(SimpleEntityTypesResolver.INSTANCE, new VirtualFileUrlManagerImpl(), null, 4, null);
        File file2 = path2.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"path.toFile()");
        Object object = file2;
        boolean bl = false;
        object = new FileOutputStream((File)object);
        bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            FileOutputStream it = (FileOutputStream)object;
            boolean bl3 = false;
            howToSerialize.invoke((Object)serializer2, (Object)it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    public static final void serializeEntityStorage(@NotNull Path path2, @NotNull WorkspaceEntityStorage storage2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)storage2, (String)"storage");
        ErrorReportingKt.serializeContent(path2, (Function2<? super EntityStorageSerializerImpl, ? super OutputStream, Unit>)((Function2)new Function2<EntityStorageSerializerImpl, OutputStream, Unit>(storage2){
            final /* synthetic */ WorkspaceEntityStorage $storage;

            public final void invoke(@NotNull EntityStorageSerializerImpl serializer2, @NotNull OutputStream stream) {
                Intrinsics.checkNotNullParameter((Object)serializer2, (String)"serializer");
                Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
                serializer2.serializeCache(stream, ErrorReportingKt.access$makeSureItsStore(this.$storage));
            }
            {
                this.$storage = workspaceEntityStorage;
                super(2);
            }
        }));
    }

    private static final WorkspaceEntityStorage makeSureItsStore(WorkspaceEntityStorage $this$makeSureItsStore) {
        return $this$makeSureItsStore instanceof WorkspaceEntityStorageBuilderImpl ? (WorkspaceEntityStorage)((WorkspaceEntityStorageBuilderImpl)$this$makeSureItsStore).toStorage() : $this$makeSureItsStore;
    }

    @NotNull
    public static final Path getStoreDumpDirectory() {
        String property2 = System.getProperty("ide.new.project.model.store.dump.directory");
        if (property2 == null) {
            String pathPrefix = "storeDump-" + ErrorReportingKt.formatTime(System.currentTimeMillis());
            Path workspaceModelDumps = Paths.get(PathManager.getLogPath(), "workspaceModel");
            File file2 = workspaceModelDumps.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"workspaceModelDumps.toFile()");
            ErrorReportingKt.cleanOldFiles(file2);
            Path currentDumpDir = workspaceModelDumps.resolve(pathPrefix);
            FileUtil.createDirectory((File)currentDumpDir.toFile());
            Path path2 = currentDumpDir;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"currentDumpDir");
            return path2;
        }
        Path path3 = Paths.get(property2, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"Paths.get(property)");
        return path3;
    }

    public static final boolean executingOnTC() {
        return System.getProperty("ide.new.project.model.store.dump.directory") != null;
    }

    /*
     * WARNING - void declaration
     */
    private static final void cleanOldFiles(File parentDir) {
        Object[] objectArray = parentDir.listFiles();
        if (objectArray == null) {
            return;
        }
        Object[] children2 = objectArray;
        Arrays.sort(children2);
        int n = 0;
        int n2 = children2.length;
        while (n < n2) {
            void i2;
            block6: {
                Object child2;
                block5: {
                    child2 = children2[i2];
                    if (i2 < children2.length - 30) break block5;
                    Object object = child2;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"child");
                    if (ErrorReportingKt.ageInDays((File)object) <= (long)7) break block6;
                }
                FileUtil.delete((File)child2);
            }
            ++i2;
        }
    }

    private static final String formatTime(long timeMs) {
        return new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date(timeMs));
    }

    private static final long ageInDays(File file2) {
        return TimeUnit.DAYS.convert(System.currentTimeMillis() - file2.lastModified(), TimeUnit.MILLISECONDS);
    }

    public static final void serializeTo(@NotNull WorkspaceEntityStorage $this$serializeTo, @NotNull OutputStream stream) {
        Intrinsics.checkNotNullParameter((Object)$this$serializeTo, (String)"$this$serializeTo");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        EntityStorageSerializerImpl serializer2 = new EntityStorageSerializerImpl(SimpleEntityTypesResolver.INSTANCE, new VirtualFileUrlManagerImpl(), null, 4, null);
        serializer2.serializeCache(stream, ErrorReportingKt.makeSureItsStore($this$serializeTo));
    }

    public static final void serializeDiff(@NotNull WorkspaceEntityStorageBuilderImpl $this$serializeDiff, @NotNull OutputStream stream) {
        Intrinsics.checkNotNullParameter((Object)$this$serializeDiff, (String)"$this$serializeDiff");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        EntityStorageSerializerImpl serializer2 = new EntityStorageSerializerImpl(SimpleEntityTypesResolver.INSTANCE, new VirtualFileUrlManagerImpl(), null, 4, null);
        serializer2.serializeDiffLog$intellij_platform_workspaceModel_storage(stream, $this$serializeDiff.getChangeLog$intellij_platform_workspaceModel_storage());
    }

    public static final /* synthetic */ WorkspaceEntityStorage access$makeSureItsStore(WorkspaceEntityStorage $this$access_u24makeSureItsStore) {
        return ErrorReportingKt.makeSureItsStore($this$access_u24makeSureItsStore);
    }
}

