/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.impl;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.workspaceModel.storage.CachedValue;
import com.intellij.workspaceModel.storage.CachedValueWithParameter;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageBuilder;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J'\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\n0\u00052\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ;\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\u000f\"\u0004\b\u0001\u0010\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\n0\b2\u0006\u0010\u0010\u001a\u0002H\u000f2\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0011J\u001a\u0010\u0012\u001a\u00020\u0013\"\u0004\b\u0000\u0010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\n0\u0005J3\u0010\u0012\u001a\u00020\u0013\"\u0004\b\u0000\u0010\u000f\"\u0004\b\u0001\u0010\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\n0\b2\u0006\u0010\u0010\u001a\u0002H\u000f\u00a2\u0006\u0002\u0010\u0014R \u0010\u0003\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u0006\u001a\"\u0012\u0016\u0012\u0014\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b\u0012\u0002\b\u00030\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/workspaceModel/storage/impl/ValuesCache;", "", "()V", "cachedValues", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lcom/intellij/workspaceModel/storage/CachedValue;", "cachedValuesWithParameter", "Lkotlin/Pair;", "Lcom/intellij/workspaceModel/storage/CachedValueWithParameter;", "cachedValue", "R", "value", "storage", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;", "(Lcom/intellij/workspaceModel/storage/CachedValue;Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;)Ljava/lang/Object;", "P", "parameter", "(Lcom/intellij/workspaceModel/storage/CachedValueWithParameter;Ljava/lang/Object;Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;)Ljava/lang/Object;", "clearCachedValue", "", "(Lcom/intellij/workspaceModel/storage/CachedValueWithParameter;Ljava/lang/Object;)V", "intellij.platform.workspaceModel.storage"})
public final class ValuesCache {
    private final Cache<CachedValue<?>, Object> cachedValues;
    private final Cache<Pair<CachedValueWithParameter<?, ?>, ?>, Object> cachedValuesWithParameter;

    public final <R> R cachedValue(@NotNull CachedValue<R> value2, @NotNull WorkspaceEntityStorage storage2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)storage2, (String)"storage");
        if (storage2 instanceof WorkspaceEntityStorageBuilder) {
            String string = "storage must be immutable";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Object o = this.cachedValues.getIfPresent(value2);
        if (o != null) {
            return (R)o;
        }
        Object object = value2.getSource().invoke((Object)storage2);
        Intrinsics.checkNotNull((Object)object);
        Object newValue2 = object;
        this.cachedValues.put(value2, newValue2);
        return (R)newValue2;
    }

    public final <P, R> R cachedValue(@NotNull CachedValueWithParameter<P, R> value2, P parameter, @NotNull WorkspaceEntityStorage storage2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)storage2, (String)"storage");
        if (storage2 instanceof WorkspaceEntityStorageBuilder) {
            String string = "storage must be immutable";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Object o = this.cachedValuesWithParameter.getIfPresent((Object)TuplesKt.to(value2, parameter));
        if (o != null) {
            return (R)o;
        }
        Object object = value2.getSource().invoke((Object)storage2, parameter);
        Intrinsics.checkNotNull((Object)object);
        Object newValue2 = object;
        this.cachedValuesWithParameter.put((Object)TuplesKt.to(value2, parameter), newValue2);
        return (R)newValue2;
    }

    public final <R> void clearCachedValue(@NotNull CachedValue<R> value2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        this.cachedValues.invalidate(value2);
    }

    public final <P, R> void clearCachedValue(@NotNull CachedValueWithParameter<P, R> value2, P parameter) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        this.cachedValuesWithParameter.invalidate((Object)TuplesKt.to(value2, parameter));
    }

    public ValuesCache() {
        Cache cache2 = Caffeine.newBuilder().build();
        Intrinsics.checkNotNullExpressionValue((Object)cache2, (String)"Caffeine.newBuilder().build()");
        this.cachedValues = cache2;
        Cache cache3 = Caffeine.newBuilder().build();
        Intrinsics.checkNotNullExpressionValue((Object)cache3, (String)"Caffeine.newBuilder().build()");
        this.cachedValuesWithParameter = cache3;
    }
}

