/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions.handlers;

import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import com.intellij.xdebugger.impl.stateWidget.StateWidgetXDebugUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH$J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH$\u00a8\u0006\u000f"}, d2={"Lcom/intellij/xdebugger/impl/actions/handlers/StateWidgetDebugActionHandler;", "Lcom/intellij/xdebugger/impl/actions/DebuggerActionHandler;", "()V", "isEnabled", "", "project", "Lcom/intellij/openapi/project/Project;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "session", "Lcom/intellij/xdebugger/impl/XDebugSessionImpl;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "perform", "", "intellij.platform.debugger.impl"})
public abstract class StateWidgetDebugActionHandler
extends DebuggerActionHandler {
    @Override
    public void perform(@NotNull Project project, @NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!StateWidgetXDebugUtils.Companion.isAvailable(project)) {
            return;
        }
        XDebugSessionImpl session2 = StateWidgetXDebugUtils.Companion.getSingleSession(project);
        if (session2 != null) {
            this.perform(session2, event.getDataContext());
        }
    }

    @Override
    public boolean isEnabled(@NotNull Project project, @NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (LightEdit.owns((Project)project)) {
            return false;
        }
        if (!StateWidgetXDebugUtils.Companion.isAvailable(project)) {
            return false;
        }
        XDebugSessionImpl session2 = StateWidgetXDebugUtils.Companion.getSingleSession(project);
        return session2 != null && this.isEnabled(session2, event.getDataContext());
    }

    protected abstract boolean isEnabled(@NotNull XDebugSessionImpl var1, @Nullable DataContext var2);

    protected abstract void perform(@NotNull XDebugSessionImpl var1, @Nullable DataContext var2);
}

