/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.validations;

import com.jetbrains.jsonSchema.extension.JsonSchemaValidation;
import com.jetbrains.jsonSchema.extension.JsonValidationHost;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.IfThenElse;
import com.jetbrains.jsonSchema.impl.JsonComplianceCheckerOptions;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.MatchResult;
import java.util.List;

public class IfThenElseValidation
implements JsonSchemaValidation {
    public static final IfThenElseValidation INSTANCE = new IfThenElseValidation();

    @Override
    public void validate(JsonValueAdapter propValue, JsonSchemaObject schema2, JsonSchemaType schemaType, JsonValidationHost consumer, JsonComplianceCheckerOptions options2) {
        List<IfThenElse> ifThenElseList = schema2.getIfThenElse();
        assert (ifThenElseList != null);
        for (IfThenElse ifThenElse : ifThenElseList) {
            MatchResult result2 = consumer.resolve(ifThenElse.getIf());
            if (result2.mySchemas.isEmpty() && result2.myExcludingSchemas.isEmpty()) {
                return;
            }
            JsonValidationHost checker = consumer.checkByMatchResult(propValue, result2, options2.withForcedStrict());
            if (checker == null) continue;
            if (checker.isValid()) {
                JsonSchemaObject then = ifThenElse.getThen();
                if (then == null) continue;
                consumer.checkObjectBySchemaRecordErrors(then, propValue);
                continue;
            }
            JsonSchemaObject schemaElse = ifThenElse.getElse();
            if (schemaElse == null) continue;
            consumer.checkObjectBySchemaRecordErrors(schemaElse, propValue);
        }
    }
}

