/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ProcessingContext;
import com.intellij.util.ui.EmptyIcon;
import javax.swing.Icon;
import org.intellij.lang.regexp.RegExpLanguageHosts;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.UnicodeCharacterNames;
import org.intellij.lang.regexp.psi.RegExpProperty;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class RegExpCompletionContributor
extends CompletionContributor {
    private static final Icon emptyIcon = EmptyIcon.create((Icon)PlatformIcons.PROPERTY_ICON);

    public RegExpCompletionContributor() {
        PsiElementPattern.Capture namedCharacterPattern = (PsiElementPattern.Capture)PlatformPatterns.psiElement().withText("\\N");
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().afterLeaf((ElementPattern)namedCharacterPattern), new NamedCharacterCompletionProvider(true));
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement((IElementType)RegExpTT.LBRACE).afterLeaf((ElementPattern)namedCharacterPattern)), new NamedCharacterCompletionProvider(false));
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withText("\\I"), new CharacterClassesNameCompletionProvider());
        PsiElementPattern propertyPattern = PlatformPatterns.psiElement().withText("\\p");
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().afterLeaf((ElementPattern)propertyPattern), new PropertyCompletionProvider());
        PsiElementPattern bracketExpressionPattern = PlatformPatterns.psiElement().afterLeaf(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement((IElementType)RegExpTT.BRACKET_EXPRESSION_BEGIN), PlatformPatterns.psiElement((IElementType)RegExpTT.CARET).afterLeaf((ElementPattern)PlatformPatterns.psiElement((IElementType)RegExpTT.BRACKET_EXPRESSION_BEGIN))}));
        this.extend(CompletionType.BASIC, (ElementPattern)bracketExpressionPattern, new BracketExpressionCompletionProvider());
        namedCharacterPattern = (PsiElementPattern.Capture)PlatformPatterns.psiElement().withText("\\\\N");
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().afterLeaf((ElementPattern)namedCharacterPattern), new NamedCharacterCompletionProvider(true));
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement((IElementType)RegExpTT.LBRACE).afterLeaf((ElementPattern)namedCharacterPattern)), new NamedCharacterCompletionProvider(false));
        PsiElementPattern backSlashPattern = PlatformPatterns.psiElement().withText("\\\\I");
        this.extend(CompletionType.BASIC, (ElementPattern)backSlashPattern, new CharacterClassesNameCompletionProvider());
        PsiElementPattern propertyPattern2 = PlatformPatterns.psiElement().withText("\\\\p");
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().afterLeaf((ElementPattern)propertyPattern2), new PropertyCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().inside(RegExpProperty.class)).afterLeaf((ElementPattern)PlatformPatterns.psiElement((IElementType)RegExpTT.EQ)), new PropertyValueCompletionProvider());
        PsiElementPattern backSlashPattern2 = PlatformPatterns.psiElement().withText("\\\\");
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().afterLeaf((ElementPattern)backSlashPattern2), new CharacterClassesNameCompletionProvider());
        propertyPattern = ((PsiElementPattern.Capture)PlatformPatterns.psiElement().withText("p")).afterLeaf((ElementPattern)backSlashPattern2);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().afterLeaf((ElementPattern)propertyPattern), new PropertyCompletionProvider());
        PsiElementPattern.Capture namedCharacterPattern2 = (PsiElementPattern.Capture)PlatformPatterns.psiElement().withText("N");
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().afterLeaf((ElementPattern)namedCharacterPattern2), new NamedCharacterCompletionProvider(true));
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement((IElementType)RegExpTT.LBRACE).afterLeaf((ElementPattern)namedCharacterPattern2)), new NamedCharacterCompletionProvider(false));
    }

    private static void addLookupElement(CompletionResultSet result2, @NonNls String name, String type, Icon icon2) {
        result2.addElement(RegExpCompletionContributor.createLookupElement(name, type, icon2));
    }

    private static LookupElement createLookupElement(String name, String type, Icon icon2) {
        return LookupElementBuilder.create((String)name).withTypeText(type).withIcon(icon2);
    }

    private static class PropertyValueCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PropertyValueCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters2, @NotNull ProcessingContext context2, @NotNull CompletionResultSet result2) {
            RegExpProperty property2;
            ASTNode propertyNameNode;
            if (parameters2 == null) {
                PropertyValueCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                PropertyValueCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result2 == null) {
                PropertyValueCompletionProvider.$$$reportNull$$$0(2);
            }
            ASTNode aSTNode = propertyNameNode = (property2 = (RegExpProperty)ObjectUtils.tryCast((Object)parameters2.getPosition().getParent(), RegExpProperty.class)) != null ? property2.getCategoryNode() : null;
            if (propertyNameNode == null) {
                return;
            }
            for (String[] value2 : RegExpLanguageHosts.getInstance().getAllPropertyValues(property2, propertyNameNode.getText())) {
                RegExpCompletionContributor.addLookupElement(result2, value2[0], value2.length > 1 ? value2[1] : null, null);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "org/intellij/lang/regexp/RegExpCompletionContributor$PropertyValueCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class NamedCharacterCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private final boolean myEmbrace;

        NamedCharacterCompletionProvider(boolean embrace) {
            this.myEmbrace = embrace;
        }

        protected void addCompletions(@NotNull CompletionParameters parameters2, @NotNull ProcessingContext context2, @NotNull CompletionResultSet result2) {
            if (parameters2 == null) {
                NamedCharacterCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                NamedCharacterCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result2 == null) {
                NamedCharacterCompletionProvider.$$$reportNull$$$0(2);
            }
            UnicodeCharacterNames.iterate(name -> {
                if (result2.getPrefixMatcher().prefixMatches(name)) {
                    String type = new String(new int[]{UnicodeCharacterNames.getCodePoint(name)}, 0, 1);
                    if (this.myEmbrace) {
                        result2.addElement(RegExpCompletionContributor.createLookupElement("{" + name + "}", type, emptyIcon));
                    } else {
                        result2.addElement((LookupElement)TailTypeDecorator.withTail((LookupElement)RegExpCompletionContributor.createLookupElement(name, type, emptyIcon), (TailType)TailType.createSimpleTailType((char)'}')));
                    }
                }
                ProgressManager.checkCanceled();
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "org/intellij/lang/regexp/RegExpCompletionContributor$NamedCharacterCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CharacterClassesNameCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private CharacterClassesNameCompletionProvider() {
        }

        public void addCompletions(@NotNull CompletionParameters parameters2, @NotNull ProcessingContext context2, @NotNull CompletionResultSet result2) {
            if (parameters2 == null) {
                CharacterClassesNameCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                CharacterClassesNameCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result2 == null) {
                CharacterClassesNameCompletionProvider.$$$reportNull$$$0(2);
            }
            for (String[] completion : RegExpLanguageHosts.getInstance().getKnownCharacterClasses(parameters2.getPosition())) {
                RegExpCompletionContributor.addLookupElement(result2, completion[0], completion[1], emptyIcon);
            }
            for (String[] stringArray : RegExpLanguageHosts.getInstance().getAllKnownProperties(parameters2.getPosition())) {
                RegExpCompletionContributor.addLookupElement(result2, "p{" + stringArray[0] + "}", stringArray.length > 1 ? stringArray[1] : null, PlatformIcons.PROPERTY_ICON);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "org/intellij/lang/regexp/RegExpCompletionContributor$CharacterClassesNameCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PropertyCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PropertyCompletionProvider() {
        }

        public void addCompletions(@NotNull CompletionParameters parameters2, @NotNull ProcessingContext context2, @NotNull CompletionResultSet result2) {
            if (parameters2 == null) {
                PropertyCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                PropertyCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result2 == null) {
                PropertyCompletionProvider.$$$reportNull$$$0(2);
            }
            for (String[] stringArray : RegExpLanguageHosts.getInstance().getAllKnownProperties(parameters2.getPosition())) {
                RegExpCompletionContributor.addLookupElement(result2, "{" + stringArray[0] + "}", stringArray.length > 1 ? stringArray[1] : null, PlatformIcons.PROPERTY_ICON);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "org/intellij/lang/regexp/RegExpCompletionContributor$PropertyCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class BracketExpressionCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private BracketExpressionCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters2, @NotNull ProcessingContext context2, @NotNull CompletionResultSet result2) {
            if (parameters2 == null) {
                BracketExpressionCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                BracketExpressionCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result2 == null) {
                BracketExpressionCompletionProvider.$$$reportNull$$$0(2);
            }
            for (String[] completion : RegExpLanguageHosts.getInstance().getPosixCharacterClasses(parameters2.getPosition())) {
                result2.addElement((LookupElement)LookupElementBuilder.create((String)completion[0]).withTypeText(completion.length > 1 ? completion[1] : null).withIcon(emptyIcon).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                    public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
                        if (context2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (item == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        context2.setAddCompletionChar(false);
                        Editor editor = context2.getEditor();
                        Document document = editor.getDocument();
                        int tailOffset = context2.getTailOffset();
                        if (document.getTextLength() < tailOffset + 2 || !document.getText(new TextRange(tailOffset, tailOffset + 2)).equals(":]")) {
                            document.insertString(tailOffset, (CharSequence)":]");
                        }
                        editor.getCaretModel().moveCaretRelatively(2, 0, false, false, true);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "context";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "item";
                                break;
                            }
                        }
                        objectArray[1] = "org/intellij/lang/regexp/RegExpCompletionContributor$BracketExpressionCompletionProvider$1";
                        objectArray[2] = "handleInsert";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "org/intellij/lang/regexp/RegExpCompletionContributor$BracketExpressionCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

