/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact.lexer;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import org.kohsuke.rngom.util.Utf16;

final class EscapePreprocessor
extends FilterReader {
    private final IntList myQueuedChars;
    private final Int2IntMap myLengthMap;
    private int myOffset;

    EscapePreprocessor(Reader reader, int startOffset, Int2IntMap map2) {
        super(reader);
        this.myOffset = startOffset;
        this.myQueuedChars = new IntArrayList();
        this.myLengthMap = map2;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int i2 = this.read();
        if (i2 == -1) {
            return -1;
        }
        cbuf[off] = (char)i2;
        return 1;
    }

    @Override
    public int read() throws IOException {
        if (this.myQueuedChars.size() > 0) {
            return this.consume();
        }
        int i2 = super.read();
        if (i2 == -1) {
            return -1;
        }
        ++this.myOffset;
        switch (i2) {
            case 13: {
                assert (false) : "Unexpected newline character";
                if (this.peek() == 10) {
                    this.consume();
                    this.myLengthMap.put(this.myOffset - 1, 2);
                }
            }
            case 10: {
                return 0;
            }
            case 92: {
                int x;
                int n = 0;
                while ((x = this.peek()) == 120) {
                    ++n;
                }
                if (n > 0 && x == 123) {
                    ++n;
                } else {
                    return i2;
                }
                int value2 = 0;
                while (EscapePreprocessor.isHexChar((char)(x = this.peek()))) {
                    ++n;
                    value2 <<= 4;
                    value2 |= Character.digit(x, 16);
                }
                if (x == 125) {
                    ++n;
                }
                this.consume(n);
                this.myLengthMap.put(this.myOffset - 1, n);
                this.myOffset += n;
                if (value2 <= 65535) {
                    return value2;
                }
                this.myQueuedChars.add((int)Utf16.surrogate2((int)value2));
                return Utf16.surrogate1((int)value2);
            }
        }
        return i2;
    }

    private static boolean isHexChar(char i2) {
        if (Character.isDigit(i2)) {
            return true;
        }
        char c = Character.toLowerCase(i2);
        return c >= 'a' && c <= 'f';
    }

    private int consume() {
        if (this.myQueuedChars.size() > 0) {
            ++this.myOffset;
            return this.myQueuedChars.removeInt(0);
        }
        return -1;
    }

    private void consume(int n) {
        this.myQueuedChars.removeElements(0, n);
    }

    private int peek() throws IOException {
        int i2 = super.read();
        if (i2 == -1) {
            return -1;
        }
        this.myQueuedChars.add(i2);
        return i2;
    }
}

