/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.LazyVariablesGroup;
import org.jetbrains.debugger.LazyVariablesGroupKt;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.VariablesKt;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.ValueType;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/debugger/LazyVariablesGroup;", "Lcom/intellij/xdebugger/frame/XValueGroup;", "value", "Lorg/jetbrains/debugger/values/ObjectValue;", "startInclusive", "", "endInclusive", "context", "Lorg/jetbrains/debugger/VariableContext;", "componentType", "Lorg/jetbrains/debugger/values/ValueType;", "sparse", "", "(Lorg/jetbrains/debugger/values/ObjectValue;IILorg/jetbrains/debugger/VariableContext;Lorg/jetbrains/debugger/values/ValueType;Z)V", "computeChildren", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "intellij.platform.scriptDebugger.ui"})
public final class LazyVariablesGroup
extends XValueGroup {
    private final ObjectValue value;
    private final int startInclusive;
    private final int endInclusive;
    private final VariableContext context;
    private final ValueType componentType;
    private final boolean sparse;

    public void computeChildren(@NotNull XCompositeNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        node2.setAlreadySorted(true);
        int bucketThreshold = 100;
        if (!this.sparse && this.endInclusive - this.startInclusive > bucketThreshold) {
            node2.addChildren(XValueChildrenList.topGroups(LazyVariablesGroupKt.computeNotSparseGroups(this.value, this.context, this.startInclusive, this.endInclusive + 1, bucketThreshold)), true);
            return;
        }
        this.value.getIndexedProperties(this.startInclusive, this.endInclusive + 1, bucketThreshold, new VariableView.ObsolescentIndexedVariablesConsumer(this, node2, node2){
            final /* synthetic */ LazyVariablesGroup this$0;
            final /* synthetic */ XCompositeNode $node;

            public void consumeRanges(@Nullable int[] ranges) {
                if (ranges == null) {
                    XValueChildrenList groupList = new XValueChildrenList();
                    LazyVariablesGroupKt.addGroups(LazyVariablesGroup.access$getValue$p(this.this$0), computeChildren.consumeRanges.1.INSTANCE, groupList, LazyVariablesGroup.access$getStartInclusive$p(this.this$0), LazyVariablesGroup.access$getEndInclusive$p(this.this$0), 100, LazyVariablesGroup.access$getContext$p(this.this$0));
                    this.$node.addChildren(groupList, true);
                } else {
                    LazyVariablesGroupKt.addRanges(LazyVariablesGroup.access$getValue$p(this.this$0), ranges, this.$node, LazyVariablesGroup.access$getContext$p(this.this$0), true);
                }
            }

            public void consumeVariables(@NotNull List<? extends Variable> variables) {
                Intrinsics.checkNotNullParameter(variables, (String)"variables");
                this.$node.addChildren(VariablesKt.createVariablesList(variables, LazyVariablesGroup.access$getContext$p(this.this$0), null), true);
            }
            {
                this.this$0 = this$0;
                this.$node = $captured_local_variable$1;
                super($super_call_param$2);
            }
        }, this.componentType);
    }

    public LazyVariablesGroup(@NotNull ObjectValue value2, int startInclusive, int endInclusive, @NotNull VariableContext context2, @Nullable ValueType componentType, boolean sparse) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "[%,d \u2026 %,d]";
        Object[] objectArray = new Object[]{startInclusive, endInclusive};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        super(string2);
        this.value = value2;
        this.startInclusive = startInclusive;
        this.endInclusive = endInclusive;
        this.context = context2;
        this.componentType = componentType;
        this.sparse = sparse;
    }

    public /* synthetic */ LazyVariablesGroup(ObjectValue objectValue, int n, int n2, VariableContext variableContext, ValueType valueType, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x10) != 0) {
            valueType = null;
        }
        if ((n3 & 0x20) != 0) {
            bl = true;
        }
        this(objectValue, n, n2, variableContext, valueType, bl);
    }

    public static final /* synthetic */ ObjectValue access$getValue$p(LazyVariablesGroup $this) {
        return $this.value;
    }

    public static final /* synthetic */ int access$getStartInclusive$p(LazyVariablesGroup $this) {
        return $this.startInclusive;
    }

    public static final /* synthetic */ int access$getEndInclusive$p(LazyVariablesGroup $this) {
        return $this.endInclusive;
    }

    public static final /* synthetic */ VariableContext access$getContext$p(LazyVariablesGroup $this) {
        return $this.context;
    }
}

