/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.fileActions.importFrom.googleDocs;

import com.google.api.client.auth.oauth2.Credential;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.fileActions.importFrom.docx.MarkdownImportDocxDialog;
import org.intellij.plugins.markdown.fileActions.importFrom.googleDocs.GoogleDocsFileLoader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/intellij/plugins/markdown/fileActions/importFrom/googleDocs/GoogleDocsImportTask;", "Lcom/intellij/openapi/progress/Task$Modal;", "project", "Lcom/intellij/openapi/project/Project;", "credential", "Lcom/google/api/client/auth/oauth2/Credential;", "docsId", "", "(Lcom/intellij/openapi/project/Project;Lcom/google/api/client/auth/oauth2/Credential;Ljava/lang/String;)V", "loadedFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "onSuccess", "", "run", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.markdown"})
public final class GoogleDocsImportTask
extends Task.Modal {
    private VirtualFile loadedFile;
    private final Credential credential;
    private final String docsId;

    public void run(@NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        this.loadedFile = new GoogleDocsFileLoader().loadFile(this.credential, this.docsId);
    }

    public void onSuccess() {
        if (this.loadedFile != null) {
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            String string = project.getBasePath();
            Intrinsics.checkNotNull((Object)string);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.basePath!!");
            String suggestedFilePath = string;
            VirtualFile virtualFile = this.loadedFile;
            Intrinsics.checkNotNull((Object)virtualFile);
            Project project2 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
            new MarkdownImportDocxDialog(virtualFile, project2, suggestedFilePath).show();
        }
    }

    public GoogleDocsImportTask(@NotNull Project project, @NotNull Credential credential, @NotNull String docsId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)credential, (String)"credential");
        Intrinsics.checkNotNullParameter((Object)docsId, (String)"docsId");
        super(project, MarkdownBundle.message("markdown.google.load.file.progress.title", new Object[0]), true);
        this.credential = credential;
        this.docsId = docsId;
    }
}

