/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.floating;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.ui.HintListener;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 (2\u00020\u0001:\u0004()*+B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0006\u0010\u001e\u001a\u00020\u001bJ\u0006\u0010\u001f\u001a\u00020 J\b\u0010!\u001a\u00020\u001bH\u0002J\u0006\u0010\"\u001a\u00020\u001bJ\b\u0010#\u001a\u00020\u001bH\u0002J\u0006\u0010$\u001a\u00020\u001bJ\u001c\u0010%\u001a\u00020\u001b2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001b0'H\u0002R+\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00060\u0017R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0018\u001a\u00060\u0019R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/intellij/plugins/markdown/ui/floating/FloatingToolbar;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/editor/Editor;)V", "<set-?>", "", "buttonSize", "getButtonSize", "()I", "setButtonSize", "(I)V", "buttonSize$delegate", "Lkotlin/properties/ReadWriteProperty;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "hint", "Lcom/intellij/ui/LightweightHint;", "keyboardListener", "Lorg/intellij/plugins/markdown/ui/floating/FloatingToolbar$KeyboardListener;", "lastSelection", "", "mouseListener", "Lorg/intellij/plugins/markdown/ui/floating/FloatingToolbar$MouseListener;", "mouseMotionListener", "Lorg/intellij/plugins/markdown/ui/floating/FloatingToolbar$MouseMotionListener;", "dispose", "", "getHintPosition", "Ljava/awt/Point;", "hideIfShown", "isShown", "", "registerListeners", "showIfHidden", "unregisterListeners", "updateLocationIfShown", "updateOnProbablyChangedSelection", "onSelectionChanged", "Lkotlin/Function1;", "Companion", "KeyboardListener", "MouseListener", "MouseMotionListener", "intellij.markdown"})
public final class FloatingToolbar
implements Disposable {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final MouseListener mouseListener;
    private final KeyboardListener keyboardListener;
    private final MouseMotionListener mouseMotionListener;
    private LightweightHint hint;
    private final ReadWriteProperty buttonSize$delegate;
    private String lastSelection;
    @NotNull
    private final Editor editor;
    private static final int verticalGap = 2;
    @NotNull
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(FloatingToolbar.class, "buttonSize", "getButtonSize()I", 0))};
        Companion = new Companion(null);
    }

    private final int getButtonSize() {
        return ((Number)this.buttonSize$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
    }

    private final void setButtonSize(int n) {
        this.buttonSize$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)n);
    }

    public final boolean isShown() {
        return this.hint != null;
    }

    public final void hideIfShown() {
        block0: {
            LightweightHint lightweightHint = this.hint;
            if (lightweightHint == null) break block0;
            lightweightHint.hide();
        }
    }

    public final void showIfHidden() {
        if (this.hint != null) {
            return;
        }
        AnAction anAction = ActionManager.getInstance().getAction("Markdown.Toolbar.Floating");
        if (anAction == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        }
        ActionGroup leftGroup = (ActionGroup)anAction;
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("EditorToolbar", leftGroup, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"ActionManager.getInstanc\u2026TOOLBAR, leftGroup, true)");
        ActionToolbar toolbar = actionToolbar;
        toolbar.setTargetComponent(this.editor.getContentComponent());
        toolbar.setReservePlaceAutoPopupIcon(false);
        this.setButtonSize(toolbar.getMaxButtonHeight());
        LightweightHint newHint = new LightweightHint(toolbar.getComponent());
        newHint.setForceShowAsPopup(true);
        HintManagerImpl.getInstanceImpl().showEditorHint(newHint, this.editor, this.getHintPosition(newHint), 129, 0, true);
        newHint.addHintListener(new HintListener(this){
            final /* synthetic */ FloatingToolbar this$0;

            public final void hintHidden(@NotNull EventObject it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                FloatingToolbar.access$setHint$p(this.this$0, null);
            }
            {
                this.this$0 = floatingToolbar;
            }
        });
        this.hint = newHint;
    }

    public final void updateLocationIfShown() {
        LightweightHint lightweightHint = this.hint;
        if (lightweightHint == null) {
            return;
        }
        LightweightHint hint = lightweightHint;
        JComponent jComponent = this.editor.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"editor.contentComponent");
        JRootPane jRootPane = jComponent.getRootPane();
        Intrinsics.checkNotNullExpressionValue((Object)jRootPane, (String)"editor.contentComponent.rootPane");
        JLayeredPane layeredPane = jRootPane.getLayeredPane();
        Point hintPos = this.getHintPosition(hint);
        hint.setLocation(new RelativePoint((Component)layeredPane, hintPos));
    }

    public void dispose() {
        this.unregisterListeners();
    }

    private final void registerListeners() {
        this.editor.addEditorMouseListener((EditorMouseListener)this.mouseListener);
        this.editor.addEditorMouseMotionListener((EditorMouseMotionListener)this.mouseMotionListener);
        this.editor.getContentComponent().addKeyListener(this.keyboardListener);
    }

    private final void unregisterListeners() {
        this.editor.removeEditorMouseListener((EditorMouseListener)this.mouseListener);
        this.editor.removeEditorMouseMotionListener((EditorMouseMotionListener)this.mouseMotionListener);
        this.editor.getContentComponent().removeKeyListener(this.keyboardListener);
    }

    private final Point getHintPosition(LightweightHint hint) {
        Point hintPos = HintManagerImpl.getInstanceImpl().getHintPosition(hint, this.editor, (short)6);
        JComponent jComponent = hint.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"hint.component");
        int dy = -(jComponent.getPreferredSize().height + 2);
        int dx = this.getButtonSize() * -2;
        hintPos.translate(dx, dy);
        Point point = hintPos;
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"hintPos");
        return point;
    }

    private final void updateOnProbablyChangedSelection(Function1<? super String, Unit> onSelectionChanged) {
        String newSelection;
        SelectionModel selectionModel = this.editor.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"editor.selectionModel");
        String string = newSelection = selectionModel.getSelectedText();
        if (string == null) {
            this.hideIfShown();
        } else if (!Intrinsics.areEqual((Object)string, (Object)this.lastSelection)) {
            onSelectionChanged.invoke((Object)newSelection);
        }
        this.lastSelection = newSelection;
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    public FloatingToolbar(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.editor = editor2;
        this.mouseListener = new MouseListener();
        this.keyboardListener = new KeyboardListener();
        this.mouseMotionListener = new MouseMotionListener();
        this.buttonSize$delegate = Delegates.INSTANCE.notNull();
        this.registerListeners();
    }

    public static final /* synthetic */ LightweightHint access$getHint$p(FloatingToolbar $this) {
        return $this.hint;
    }

    public static final /* synthetic */ void access$setHint$p(FloatingToolbar $this, LightweightHint lightweightHint) {
        $this.hint = lightweightHint;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/intellij/plugins/markdown/ui/floating/FloatingToolbar$MouseListener;", "Lcom/intellij/openapi/editor/event/EditorMouseListener;", "(Lorg/intellij/plugins/markdown/ui/floating/FloatingToolbar;)V", "mouseReleased", "", "e", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "intellij.markdown"})
    private final class MouseListener
    implements EditorMouseListener {
        public void mouseReleased(@NotNull EditorMouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            FloatingToolbar.this.updateOnProbablyChangedSelection((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){
                final /* synthetic */ MouseListener this$0;

                public final void invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    if (this.this$0.FloatingToolbar.this.isShown()) {
                        this.this$0.FloatingToolbar.this.updateLocationIfShown();
                    } else {
                        this.this$0.FloatingToolbar.this.showIfHidden();
                    }
                }
                {
                    this.this$0 = mouseListener;
                    super(1);
                }
            }));
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/intellij/plugins/markdown/ui/floating/FloatingToolbar$KeyboardListener;", "Ljava/awt/event/KeyAdapter;", "(Lorg/intellij/plugins/markdown/ui/floating/FloatingToolbar;)V", "keyReleased", "", "e", "Ljava/awt/event/KeyEvent;", "intellij.markdown"})
    private final class KeyboardListener
    extends KeyAdapter {
        @Override
        public void keyReleased(@NotNull KeyEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            super.keyReleased(e);
            if (Intrinsics.areEqual((Object)e.getSource(), (Object)FloatingToolbar.this.getEditor().getContentComponent()) ^ true) {
                return;
            }
            FloatingToolbar.this.updateOnProbablyChangedSelection((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){
                final /* synthetic */ KeyboardListener this$0;

                public final void invoke(@NotNull String selection) {
                    Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
                    if (StringsKt.contains$default((CharSequence)selection, (char)'\n', (boolean)false, (int)2, null)) {
                        this.this$0.FloatingToolbar.this.hideIfShown();
                    } else if (this.this$0.FloatingToolbar.this.isShown()) {
                        this.this$0.FloatingToolbar.this.updateLocationIfShown();
                    } else {
                        this.this$0.FloatingToolbar.this.showIfHidden();
                    }
                }
                {
                    this.this$0 = keyboardListener;
                    super(1);
                }
            }));
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/intellij/plugins/markdown/ui/floating/FloatingToolbar$MouseMotionListener;", "Lcom/intellij/openapi/editor/event/EditorMouseMotionListener;", "(Lorg/intellij/plugins/markdown/ui/floating/FloatingToolbar;)V", "mouseMoved", "", "e", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "intellij.markdown"})
    private final class MouseMotionListener
    implements EditorMouseMotionListener {
        public void mouseMoved(@NotNull EditorMouseEvent e) {
            boolean hoverSelected;
            block4: {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                VisualPosition visualPosition = e.getVisualPosition();
                Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"e.visualPosition");
                VisualPosition visualPosition2 = visualPosition;
                CaretModel caretModel = FloatingToolbar.this.getEditor().getCaretModel();
                Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
                List list = caretModel.getAllCarets();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"editor.caretModel.allCarets");
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Caret it = (Caret)element$iv;
                        boolean bl2 = false;
                        Caret caret = it;
                        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"it");
                        boolean beforeSelectionEnd = caret.getSelectionEndPosition().after(visualPosition2);
                        boolean afterSelectionStart = visualPosition2.after(it.getSelectionStartPosition());
                        if (!(beforeSelectionEnd && afterSelectionStart)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = hoverSelected = false;
                }
            }
            if (hoverSelected) {
                FloatingToolbar.this.showIfHidden();
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/intellij/plugins/markdown/ui/floating/FloatingToolbar$Companion;", "", "()V", "verticalGap", "", "intellij.markdown"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

