/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake;

import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.configurations.ConfigurationTypeBase;
import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManagerEx;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.CidrCodeInsightFixture;
import com.jetbrains.cidr.CidrTestDataFixture;
import com.jetbrains.cidr.CidrTestProjectDescription;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.CPPProjectFixture;
import com.jetbrains.cidr.cpp.CPPTestCase;
import com.jetbrains.cidr.cpp.cmake.CMakeRunner;
import com.jetbrains.cidr.cpp.cmake.CMakeSettings;
import com.jetbrains.cidr.cpp.cmake.model.CMakeCacheFile;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfiguration;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGenerator;
import com.jetbrains.cidr.cpp.cmake.model.CMakeMessage;
import com.jetbrains.cidr.cpp.cmake.model.CMakeModel;
import com.jetbrains.cidr.cpp.cmake.model.CMakeModelConfigurationData;
import com.jetbrains.cidr.cpp.cmake.model.CMakeTarget;
import com.jetbrains.cidr.cpp.cmake.model.CMakeVariable;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.cpp.execution.CMakeAppRunConfiguration;
import com.jetbrains.cidr.cpp.execution.CMakeAppRunConfigurationType;
import com.jetbrains.cidr.cpp.execution.CMakeBuildConfigurationHelper;
import com.jetbrains.cidr.cpp.execution.build.CMakeBuild;
import com.jetbrains.cidr.cpp.execution.build.runners.CMakeCompileTaskRunner;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.BuildTargetData;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.ExecutableData;
import com.jetbrains.cidr.execution.ExecutionResult;
import com.jetbrains.cidr.execution.build.CidrBuildResult;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import icons.CLionIcons;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeProjectFixture
extends CPPProjectFixture<CMakeAppRunConfiguration.BuildAndRunConfigurations> {
    private static final Logger LOG = Logger.getInstance(CMakeProjectFixture.class);
    private static final int CMAKE_RELOAD_TIMEOUT_MS = 300000;
    private VirtualFile myCMakeListsFile;
    private static final Map<String, FutureResult<File>> ourCMakeProjectCacheDirs = new ConcurrentHashMap<String, FutureResult<File>>();

    public CMakeProjectFixture(@NotNull CidrTestDataFixture testDataFixture) {
        if (testDataFixture == null) {
            CMakeProjectFixture.$$$reportNull$$$0(0);
        }
        super(testDataFixture);
    }

    @Override
    public void collectAllowedRoots(@NotNull List<? super String> roots) {
        if (roots == null) {
            CMakeProjectFixture.$$$reportNull$$$0(1);
        }
        super.collectAllowedRoots(roots);
        roots.add(PathManagerEx.getAppSystemDir().toString());
    }

    @NotNull
    public static CMakeGenerator.Parameters prepareCMakeProjectCache(@NotNull CMakeGenerator.Parameters parameters) {
        File cacheScript;
        if (parameters == null) {
            CMakeProjectFixture.$$$reportNull$$$0(2);
        }
        if (CMakeGenerator.shouldUseAPI((CMakeGenerator.Parameters)parameters)) {
            CMakeGenerator.Parameters parameters2 = parameters;
            if (parameters2 == null) {
                CMakeProjectFixture.$$$reportNull$$$0(3);
            }
            return parameters2;
        }
        ArrayList<String> options = new ArrayList<String>(parameters.additionalOptions);
        if (!options.contains("-C") && (cacheScript = CMakeProjectFixture.createAndCopyCMakeProjectCache(parameters.generationDir, parameters.additionalOptions)) != null) {
            options.add("-C");
            options.add(CPPTestCase.getTestCPPEnvironment().toEnvPath(cacheScript.getPath()));
        }
        return new CMakeGenerator.Parameters(parameters.profileId, parameters.profileName, parameters.buildType, parameters.generationDir, options, parameters.passSystemEnvironment, parameters.additionalEnvironment, parameters.listener, parameters.environment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static File createAndCopyCMakeProjectCache(@NotNull File destination, List<String> cmakeOptions) {
        FutureResult cachedDirResult;
        Consumer printLog;
        block19: {
            if (destination == null) {
                CMakeProjectFixture.$$$reportNull$$$0(4);
            }
            String cacheFileName = "cache_script.txt";
            Function getCompilerOption = var -> {
                String result = (String)ContainerUtil.find((Iterable)cmakeOptions, it -> it.startsWith((String)var) || it.startsWith("-D" + var));
                if (result != null) {
                    result = StringUtil.trimStart((String)result, (String)"-D").trim();
                }
                return result;
            };
            String cCompiler = (String)getCompilerOption.fun((Object)"CMAKE_C_COMPILER");
            String cxxCompiler = (String)getCompilerOption.fun((Object)"CMAKE_CXX_COMPILER");
            String cFlags = (String)getCompilerOption.fun((Object)"CMAKE_C_FLAGS");
            String cxxFlags = (String)getCompilerOption.fun((Object)"CMAKE_CXX_FLAGS");
            String compilersKey = cCompiler + ":" + cxxCompiler;
            printLog = action -> {
                if (cCompiler == null && cxxCompiler == null) {
                    LOG.debug(action + " CMake project cache for default compilers");
                } else {
                    LOG.debug(action + " CMake project cache for compilers:\n\t" + StringUtil.notNullize((String)cCompiler, (String)"CMAKE_C_COMPILER=<default>") + "\n\t" + StringUtil.notNullize((String)cxxCompiler, (String)"CMAKE_CXX_COMPILER=<default>"));
                }
            };
            FutureResult futureResult = cachedDirResult = ourCMakeProjectCacheDirs.computeIfAbsent(compilersKey, __ -> new FutureResult());
            synchronized (futureResult) {
                if (!cachedDirResult.isDone()) {
                    printLog.consume((Object)"Preparing");
                    File tempDir = null;
                    File cachedDir = null;
                    try {
                        CMakeRunner.CMakeOutput output;
                        File sysTempDir = new File(System.getProperty("java.io.tmpdir")).getCanonicalFile();
                        tempDir = FileUtil.createTempDirectory((File)sysTempDir, (String)"cmake_project_cache", (String)"temp", (boolean)true);
                        CMakeProjectFixture.assertTrue((boolean)new File(tempDir, "CMakeLists.txt").createNewFile());
                        ArrayList<CallSite> cacheGenerationOption = new ArrayList<CallSite>();
                        if (cCompiler != null) {
                            cacheGenerationOption.add((CallSite)((Object)("-D" + cCompiler)));
                        }
                        if (cxxCompiler != null) {
                            cacheGenerationOption.add((CallSite)((Object)("-D" + cxxCompiler)));
                        }
                        if (cFlags != null) {
                            cacheGenerationOption.add((CallSite)((Object)("-D" + cFlags)));
                        }
                        if (cxxFlags != null) {
                            cacheGenerationOption.add((CallSite)((Object)("-D" + cxxFlags)));
                        }
                        boolean errorInTests = CMakeRunner.getEmulateCMakeExecutionErrorInTests();
                        try {
                            CMakeRunner.setEmulateCMakeExecutionErrorInTests((boolean)false);
                            output = CMakeGenerator.runCMakeGenerator((CPPEnvironment)CPPTestCase.getTestCPPEnvironment(), (File)tempDir, (File)tempDir, cacheGenerationOption);
                        }
                        finally {
                            CMakeRunner.setEmulateCMakeExecutionErrorInTests((boolean)errorInTests);
                        }
                        CMakeProjectFixture.assertEquals((String)("Non-zero exit code:\n" + output.getOutput().toString()), (long)0L, (long)output.getExitCode());
                        cachedDir = FileUtil.createTempDirectory((File)sysTempDir, (String)"cmake_project_cache", null, (boolean)true);
                        File[] files = new File(tempDir, "CMakeFiles").listFiles(it -> it.isDirectory() && it.getName().matches("\\d+\\.\\d+.*"));
                        CMakeProjectFixture.assertTrue((String)("CMake checks dir not found in " + tempDir), (files != null && files.length > 0 ? 1 : 0) != 0);
                        File checksDir = files[0];
                        FileUtil.copyDir((File)checksDir, (File)new File(cachedDir, "CMakeFiles/" + checksDir.getName()), each -> each.getName().endsWith(".cmake"));
                        CMakeCacheFile cacheFile = new CMakeCacheFile(new File(tempDir, "CMakeCache.txt"), "UTF-8");
                        StringBuilder cacheScriptText = new StringBuilder();
                        for (CMakeVariable eachVar : cacheFile.getVariables()) {
                            if (eachVar.getType() == CMakeVariable.Type.UNINITIALIZED || eachVar.getType() == CMakeVariable.Type.STATIC || eachVar.getName().equals("CMAKE_HOME_DIRECTORY") || eachVar.getName().endsWith("-ADVANCED")) continue;
                            cacheScriptText.append("set(" + eachVar.getName() + " \"" + StringUtil.notNullize((String)eachVar.getValue()) + "\" CACHE " + eachVar.getType() + " \"" + StringUtil.notNullize((String)eachVar.getDescription()) + "\")\n");
                            CMakeVariable advMarker = cacheFile.getVariable(eachVar.getName() + "-ADVANCED");
                            if (advMarker == null || !advMarker.getValue().equals("1")) continue;
                            cacheScriptText.append("mark_as_advanced(" + eachVar.getName() + ")\n");
                        }
                        FileUtil.writeToFile((File)new File(cachedDir, "cache_script.txt"), (String)cacheScriptText.toString());
                        cachedDirResult.set((Object)cachedDir);
                        if (tempDir == null) break block19;
                    }
                    catch (Throwable e) {
                        try {
                            cachedDirResult.set(null);
                            if (cachedDir == null) throw new RuntimeException("Cannot generate a CMake cache project. ", e);
                            FileUtil.delete(cachedDir);
                            throw new RuntimeException("Cannot generate a CMake cache project. ", e);
                        }
                        catch (Throwable throwable) {
                            if (tempDir == null) throw throwable;
                            FileUtil.delete(tempDir);
                            throw throwable;
                        }
                    }
                    FileUtil.delete((File)tempDir);
                }
            }
        }
        try {
            File cachedDir = (File)cachedDirResult.get(1L, TimeUnit.MILLISECONDS);
            if (cachedDir == null) return null;
            printLog.consume((Object)"Using");
            FileUtil.copyDir((File)new File(cachedDir, "CMakeFiles"), (File)new File(destination, "CMakeFiles"));
            File cacheScriptFile = new File(cachedDir, "cache_script.txt");
            UsefulTestCase.assertExists(cacheScriptFile);
            return cacheScriptFile;
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot copy the CMake cache project. ", e);
        }
    }

    public void initProject(@NotNull String relativeProjectPath, List<String> configsToGenerate) throws Exception {
        if (relativeProjectPath == null) {
            CMakeProjectFixture.$$$reportNull$$$0(5);
        }
        this.initProject(relativeProjectPath, this.getSettingsConfigurator(configsToGenerate));
    }

    @NotNull
    public Consumer<CMakeSettings> getSettingsConfigurator(List<String> configsToGenerate) {
        Consumer consumer = settings -> WriteAction.runAndWait(() -> settings.setProfiles(ContainerUtil.map((Collection)configsToGenerate, each -> new CMakeSettings.Profile(each))));
        if (consumer == null) {
            CMakeProjectFixture.$$$reportNull$$$0(6);
        }
        return consumer;
    }

    public void initProject(@NotNull String relativeProjectPath, CMakeSettings.Profile profile) throws Exception {
        if (relativeProjectPath == null) {
            CMakeProjectFixture.$$$reportNull$$$0(7);
        }
        this.initProject(relativeProjectPath, (Consumer<CMakeSettings>)((Consumer)settings -> settings.setProfiles(Collections.singletonList(profile))));
    }

    public void initProject(@NotNull String relativeProjectPath, @NotNull String compiler) throws Exception {
        if (relativeProjectPath == null) {
            CMakeProjectFixture.$$$reportNull$$$0(8);
        }
        if (compiler == null) {
            CMakeProjectFixture.$$$reportNull$$$0(9);
        }
        this.initProject(relativeProjectPath, (Consumer<CMakeSettings>)((Consumer)settings -> this.updateCMakeSettingsConfig((CMakeSettings)settings, compiler)));
    }

    public void initOrUpdateProjectWithCompiler(@NotNull String relativeProjectPath, @NotNull String compiler) throws Exception {
        if (relativeProjectPath == null) {
            CMakeProjectFixture.$$$reportNull$$$0(10);
        }
        if (compiler == null) {
            CMakeProjectFixture.$$$reportNull$$$0(11);
        }
        this.initOrUpdateProjectWithCompilerAndProfiles(relativeProjectPath, compiler, null);
    }

    public void initOrUpdateProjectWithCompilerAndProfiles(@NotNull String relativeProjectPath, @NotNull String compiler, @Nullable List<String> profiles) throws Exception {
        if (relativeProjectPath == null) {
            CMakeProjectFixture.$$$reportNull$$$0(12);
        }
        if (compiler == null) {
            CMakeProjectFixture.$$$reportNull$$$0(13);
        }
        Consumer configurator = settings -> WriteAction.runAndWait(() -> {
            if (profiles != null) {
                this.getSettingsConfigurator(profiles).consume(settings);
            }
            this.updateCMakeSettingsConfig((CMakeSettings)settings, compiler);
        });
        if (this.isProjectInitialized()) {
            configurator.consume((Object)this.getCMakeSettings());
            this.waitForReloads();
        } else {
            this.initProject(relativeProjectPath, (Consumer<CMakeSettings>)configurator);
        }
    }

    public void initProject(@NotNull String relativeProjectPath, List<String> configsToGenerate, FileSymbolTablesCache.SymbolsProperties.SymbolsKind buildSymbolTables) throws Exception {
        if (relativeProjectPath == null) {
            CMakeProjectFixture.$$$reportNull$$$0(14);
        }
        CMakeWorkspace.setSettingsConfiguratorInTests(this.getSettingsConfigurator(configsToGenerate));
        super.initProject(new CidrTestProjectDescription(relativeProjectPath), buildSymbolTables);
    }

    public void initProject(@NotNull String relativeProjectPath, @Nullable Consumer<CMakeSettings> configurator) throws Exception {
        if (relativeProjectPath == null) {
            CMakeProjectFixture.$$$reportNull$$$0(15);
        }
        CMakeWorkspace.setSettingsConfiguratorInTests(configurator);
        super.initProject(relativeProjectPath);
    }

    @Override
    protected boolean projectChangedSomehow(@NotNull Project project2) {
        CMakeSettings.State expectedSettingsState;
        Consumer configurator;
        if (project2 == null) {
            CMakeProjectFixture.$$$reportNull$$$0(16);
        }
        if ((configurator = CMakeWorkspace.getSettingsConfiguratorInTests()) != null) {
            CMakeSettings settings = new CMakeSettings(project2);
            configurator.consume((Object)settings);
            expectedSettingsState = settings.getCMakeState();
        } else {
            expectedSettingsState = new CMakeSettings(project2).getCMakeState();
        }
        CMakeSettings.State currentSettingsState = CMakeSettings.getInstance((Project)project2).getCMakeState();
        if (!expectedSettingsState.equalsLocation(currentSettingsState)) {
            return true;
        }
        return super.projectChangedSomehow(project2);
    }

    @Override
    public void setUp(@NotNull String testClassFQN, @NotNull String testName) throws Exception {
        if (testClassFQN == null) {
            CMakeProjectFixture.$$$reportNull$$$0(17);
        }
        if (testName == null) {
            CMakeProjectFixture.$$$reportNull$$$0(18);
        }
        super.setUp(testClassFQN, testName);
        this.useCMakeProjectsCache(true);
    }

    public void useCMakeProjectsCache(boolean use) {
        if (use) {
            CMakeWorkspace.setGenerationParametersConfigurator(parameters -> CMakeProjectFixture.prepareCMakeProjectCache(parameters));
        } else {
            CMakeWorkspace.setGenerationParametersConfigurator(null);
        }
    }

    @Override
    public void tearDown() throws Exception {
        try {
            CMakeWorkspace.clearTestSettings();
        }
        finally {
            super.tearDown();
        }
    }

    @Override
    @NotNull
    protected Project doOpenProject(@NotNull VirtualFile projectDir) {
        if (projectDir == null) {
            CMakeProjectFixture.$$$reportNull$$$0(19);
        }
        Project project2 = ProjectUtil.openOrImport((Path)projectDir.toNioPath());
        CMakeProjectFixture.assertNotNull((String)("Project was not opened for " + projectDir), (Object)project2);
        this.myCMakeListsFile = projectDir.findFileByRelativePath("CMakeLists.txt");
        Project project3 = project2;
        if (project3 == null) {
            CMakeProjectFixture.$$$reportNull$$$0(20);
        }
        return project3;
    }

    public void openProjectWithoutReloadingCMake() throws Exception {
        CMakeWorkspace.setSkipReloadOnProjectOpenInTests((Boolean)true);
        try {
            this.openProject();
        }
        finally {
            CMakeWorkspace.setSkipReloadOnProjectOpenInTests(null);
        }
    }

    @Override
    public void afterProjectOpened() throws Exception {
        super.afterProjectOpened();
        this.getCMakeWorkspace().setReloadInBackgroundInTests(true, (Disposable)this.getProject());
    }

    @Override
    protected void checkCPPProjectOpenedCorrectly() {
        this.assertErrors(new String[0]);
    }

    @Override
    protected void addProjectCleanUpRunnables(List<ThrowableRunnable<Throwable>> list) {
        list.add((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> this.getCMakeWorkspace().shutdownWatcher()));
        super.addProjectCleanUpRunnables(list);
        list.add((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
            Project project2 = this.getProjectUnchecked();
            if (project2 != null) {
                File dir = CMakeWorkspace.getProjectCacheDir((Project)project2).toFile();
                if (!FileUtil.delete((File)dir)) {
                    CPPLog.LOG.warn("Cannot delete CMake cache directory: " + dir);
                }
                LocalFileSystem.getInstance().refreshIoFiles(Collections.singletonList(dir));
            }
        }));
    }

    @NotNull
    public CMakeWorkspace getCidrWorkspace() {
        CMakeWorkspace cMakeWorkspace = this.getCMakeWorkspace();
        if (cMakeWorkspace == null) {
            CMakeProjectFixture.$$$reportNull$$$0(21);
        }
        return cMakeWorkspace;
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull OCWorkspace.ModifiableModel getWorkspaceModifiableModel(boolean clear) {
        OCWorkspace.ModifiableModel modifiableModel = this.getWorkspace().getModifiableModel("CMake", clear);
        if (modifiableModel == null) {
            CMakeProjectFixture.$$$reportNull$$$0(22);
        }
        return modifiableModel;
    }

    @NotNull
    public CMakeWorkspace getCMakeWorkspace() {
        CMakeWorkspace cMakeWorkspace = CMakeWorkspace.getInstance((Project)this.getProject());
        if (cMakeWorkspace == null) {
            CMakeProjectFixture.$$$reportNull$$$0(23);
        }
        return cMakeWorkspace;
    }

    public CMakeSettings getCMakeSettings() {
        return this.getCMakeWorkspace().getSettings();
    }

    public void updateCMakeSettingsConfig(Function<CMakeSettings.Profile, CMakeSettings.Profile> converter) {
        this.updateCMakeSettingsConfig(this.getCMakeSettings(), converter);
    }

    public void updateCMakeSettingsConfig(CMakeSettings settings, Function<CMakeSettings.Profile, CMakeSettings.Profile> converter) {
        WriteAction.runAndWait(() -> settings.setProfiles(ContainerUtil.map((Collection)settings.getProfiles(), (Function)converter)));
    }

    public void updateCMakeSettingsConfig(CMakeSettings settings, @NotNull String compilerPath) {
        if (compilerPath == null) {
            CMakeProjectFixture.$$$reportNull$$$0(24);
        }
        this.updateCMakeSettingsConfig(settings, compilerPath, compilerPath);
    }

    public void updateCMakeSettingsConfig(CMakeSettings settings, @Nullable String cCompilerPath2, @Nullable String cppCompilerPath) {
        String canonicalC = FileUtil.toCanonicalPath((String)cCompilerPath2);
        String canonicalCpp = FileUtil.toCanonicalPath((String)cppCompilerPath);
        String cFlags = null;
        String cxxFlags = null;
        if (canonicalCpp != null && (canonicalCpp.endsWith("clang-cl.exe") || canonicalCpp.endsWith("clang-cl"))) {
            @NotNull List options = CPPTestCase.getTestCPPEnvironment().getToolchain().getToolSetOptions();
            String bitnessFlag = "-m64";
            if (options.isEmpty() || options.get(0) == null || ((CPPToolSet.Option)options.get(0)).getValue().endsWith("x86")) {
                bitnessFlag = "-m32";
            }
            cFlags = "-DCMAKE_C_FLAGS=" + bitnessFlag;
            cxxFlags = "-DCMAKE_CXX_FLAGS=" + bitnessFlag;
        }
        String finalCFlags = cFlags;
        String finalCxxFlags = cxxFlags;
        this.updateCMakeSettingsConfig(settings, (Function<CMakeSettings.Profile, CMakeSettings.Profile>)((Function)c -> c.withGenerationOptions((String)(canonicalCpp == null ? "" : "-DCMAKE_CXX_COMPILER=\"" + CPPTestCase.getTestCPPEnvironment().toEnvPath(canonicalCpp) + "\"") + " " + (String)(canonicalC == null ? "" : "-DCMAKE_C_COMPILER=\"" + CPPTestCase.getTestCPPEnvironment().toEnvPath(canonicalC) + "\"") + " " + (finalCFlags == null ? "" : finalCFlags) + " " + (finalCxxFlags == null ? "" : finalCxxFlags))));
    }

    public CMakeModel getModel() {
        return this.getCMakeWorkspace().getModel();
    }

    public void reload() {
        this.getCMakeWorkspace().scheduleReload(true);
        try {
            this.waitForReloads();
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    public void waitForReloads() throws TimeoutException {
        this.getCMakeWorkspace().waitForReloadsToFinish(300000);
    }

    @NotNull
    public VirtualFile getCMakeListsFile() {
        VirtualFile virtualFile = this.myCMakeListsFile;
        if (virtualFile == null) {
            CMakeProjectFixture.$$$reportNull$$$0(25);
        }
        return virtualFile;
    }

    public static String @NotNull [] getMissingFilesInTargetCMakeErrors(String missingFileName) {
        if (CPPTestCase.getTestCMakeParsedVersion().isOrGreaterThan(Integer.valueOf(3), Integer.valueOf(11))) {
            String[] stringArray = new String[]{missingFileName, "No SOURCES given to target"};
            if (stringArray == null) {
                CMakeProjectFixture.$$$reportNull$$$0(26);
            }
            return stringArray;
        }
        String[] stringArray = new String[]{missingFileName, "CMake can not determine linker language for target", "Cannot determine link language for target"};
        if (stringArray == null) {
            CMakeProjectFixture.$$$reportNull$$$0(27);
        }
        return stringArray;
    }

    public void assertErrors(String ... matches) {
        this.doAssertHasMessages(null, Arrays.asList(matches), false, (Condition<CMakeMessage>)((Condition)it -> it.getLevel().isError()));
    }

    public void assertErrorsInConfiguration(String config, String ... matches) {
        this.doAssertHasMessages(config, Arrays.asList(matches), false, (Condition<CMakeMessage>)((Condition)it -> it.getLevel().isError()));
    }

    public void assertMessages(String ... matches) {
        this.doAssertHasMessages(null, Arrays.asList(matches), false, (Condition<CMakeMessage>)Conditions.alwaysTrue());
    }

    public void assertMessagesRegexp(String ... matches) {
        this.doAssertHasMessages(null, Arrays.asList(matches), true, (Condition<CMakeMessage>)Conditions.alwaysTrue());
    }

    public void assertMessagesRegexpInConfiguration(String config, String ... matches) {
        this.doAssertHasMessages(config, Arrays.asList(matches), true, (Condition<CMakeMessage>)Conditions.alwaysTrue());
    }

    public void assertWarnings(String ... matches) {
        this.doAssertHasMessages(null, Arrays.asList(matches), false, (Condition<CMakeMessage>)((Condition)it -> it.getLevel().isWarning()));
    }

    private <V> void doAssertHasMessages(String configNameOrNull, List<String> allMatchers, boolean regexp, Condition<CMakeMessage> filter) {
        if (!this.getCMakeWorkspace().isInitialized()) {
            return;
        }
        LinkedHashMap tabsWithErrors = new LinkedHashMap();
        this.doWithCMakeConsole(() -> CMakeProjectFixture.collectErrors(this.getCMakeWorkspace().getConsole().getMessages(() -> PlatformTestUtil.dispatchAllEventsInIdeEventQueue()), tabsWithErrors, filter));
        CMakeProjectFixture.assertFalse((String)"No output tabs", (boolean)tabsWithErrors.keySet().isEmpty());
        for (String string : configNameOrNull == null ? tabsWithErrors.keySet() : Collections.singleton(configNameOrNull)) {
            List errors = (List)tabsWithErrors.get(string);
            String formattedErrors = UsefulTestCase.toString(errors);
            CMakeProjectFixture.assertEquals((String)formattedErrors, (long)allMatchers.size(), (long)errors.size());
            String formattedMatchers = UsefulTestCase.toString(allMatchers);
            for (int i = 0; i < allMatchers.size(); ++i) {
                String eachMatcher = allMatchers.get(i);
                String eachError = (String)errors.get(i);
                if (regexp) {
                    CMakeProjectFixture.assertTrue((String)("Expected messages in tab " + string + ": \n" + formattedMatchers + "\n\nActual:\n" + formattedErrors), (boolean)Pattern.compile(eachMatcher, 32).matcher(eachError).find());
                    continue;
                }
                CMakeProjectFixture.assertTrue((String)("Expected messages in tab " + string + ": \n" + formattedMatchers + "\n\nActual:\n" + formattedErrors), (boolean)eachError.contains(eachMatcher));
            }
        }
    }

    private static void collectErrors(List<Pair<String, List<CMakeMessage>>> messages, LinkedHashMap<String, List<String>> tabsWithErrorsResult, Condition<CMakeMessage> filter) {
        for (Pair<String, List<CMakeMessage>> eachTab : messages) {
            ArrayList<String> filteredMessages = new ArrayList<String>();
            for (CMakeMessage eachMessage : (List)eachTab.second) {
                if (!filter.value((Object)eachMessage)) continue;
                filteredMessages.add(StringUtil.join((String[])new String[]{eachMessage.getText(), "\n"}));
            }
            tabsWithErrorsResult.put((String)eachTab.first, filteredMessages);
        }
    }

    public void doWithCMakeConsole(Runnable r) {
        UIUtil.invokeAndWaitIfNeeded(() -> {
            PlatformTestUtil.dispatchAllEventsInIdeEventQueue();
            r.run();
        });
    }

    @Nullable
    public CMakeTarget findModelTarget(@NotNull String name) {
        if (name == null) {
            CMakeProjectFixture.$$$reportNull$$$0(28);
        }
        for (CMakeTarget each : this.getModelTargets()) {
            if (!each.getName().equals(name)) continue;
            return each;
        }
        return null;
    }

    @NotNull
    public List<CMakeTarget> getModelTargets() {
        List list = this.getCMakeWorkspace().getModelTargets();
        if (list == null) {
            CMakeProjectFixture.$$$reportNull$$$0(29);
        }
        return list;
    }

    public void assertModelTargets(String ... expectedNames) {
        this.assertModelTargets(Arrays.asList(expectedNames));
    }

    public void assertModelTargets(List<String> expectedNames) {
        UsefulTestCase.assertSameElements(ContainerUtil.map(this.getModelTargets(), target -> target.getName()), expectedNames);
    }

    @NotNull
    public File getModelGenerationDir(@NotNull String configName) {
        if (configName == null) {
            CMakeProjectFixture.$$$reportNull$$$0(30);
        }
        File file2 = this.getModelConfigurationData(configName).getGenerationDir();
        if (file2 == null) {
            CMakeProjectFixture.$$$reportNull$$$0(31);
        }
        return file2;
    }

    @NotNull
    public CMakeModelConfigurationData getModelConfigurationData(@NotNull String configName) {
        if (configName == null) {
            CMakeProjectFixture.$$$reportNull$$$0(32);
        }
        CMakeModelConfigurationData cMakeModelConfigurationData = this.getCMakeWorkspace().getModelConfigurationData().stream().filter(it -> it.getConfigName().equals(configName)).findFirst().get();
        if (cMakeModelConfigurationData == null) {
            CMakeProjectFixture.$$$reportNull$$$0(33);
        }
        return cMakeModelConfigurationData;
    }

    @Nullable
    public File findProductFile(String targetName) {
        return this.findProductFile(targetName, "Debug");
    }

    @NotNull
    public File getProductFile(String targetName, String configurationName) {
        File productFile = this.findProductFile(targetName, configurationName);
        CMakeProjectFixture.assertNotNull((String)("Null product file for name: " + targetName), (Object)productFile);
        File file2 = productFile;
        if (file2 == null) {
            CMakeProjectFixture.$$$reportNull$$$0(34);
        }
        return file2;
    }

    @NotNull
    public File getProductFile(String targetName) {
        File file2 = this.getProductFile(targetName, "Debug");
        if (file2 == null) {
            CMakeProjectFixture.$$$reportNull$$$0(35);
        }
        return file2;
    }

    @Nullable
    public File findProductFile(String targetName, String configurationName) {
        CMakeConfiguration configuration2 = this.getBuildConfiguration((String)targetName, (String)configurationName).buildConfiguration;
        CMakeProjectFixture.assertNotNull((Object)configuration2);
        return configuration2.getProductFile();
    }

    @NotNull
    public CMakeAppRunConfiguration.BuildAndRunConfigurations getBuildConfiguration(String targetName, String configurationName) {
        CMakeBuildConfigurationHelper myBuildConfigurationHelper = new CMakeBuildConfigurationHelper(this.getProject());
        CMakeTarget target = (CMakeTarget)myBuildConfigurationHelper.findFirstSuitableTarget(targetName);
        CMakeConfiguration configuration2 = (CMakeConfiguration)myBuildConfigurationHelper.findConfiguration((CidrBuildTarget)target, configurationName);
        CMakeProjectFixture.assertNotNull((Object)configuration2);
        return new CMakeAppRunConfiguration.BuildAndRunConfigurations(configuration2);
    }

    public String buildConfiguration(String targetName) throws Exception {
        return this.buildConfiguration(targetName, "Debug");
    }

    public String buildConfiguration(String targetName, String configurationName) throws Exception {
        return this.buildConfiguration(this.getBuildConfiguration(targetName, configurationName));
    }

    public String buildConfiguration(CMakeAppRunConfiguration.BuildAndRunConfigurations configurations) throws Exception {
        return this.buildConfiguration(configurations, false);
    }

    public String buildConfiguration(CMakeAppRunConfiguration.BuildAndRunConfigurations configurations, boolean allowBuildToFail) throws Exception {
        List buildableElements = CMakeBuild.getBuildableElements((CMakeAppRunConfiguration.BuildAndRunConfigurations)configurations);
        Pair<Boolean, String> result = this.buildConfiguration(buildableElements.toArray(new CidrBuildConfiguration[0]));
        if (!allowBuildToFail) {
            CMakeProjectFixture.assertTrue((String)((String)result.second), (boolean)((Boolean)result.first));
        }
        return (String)result.second;
    }

    public void cleanConfiguration(String targetName) throws Exception {
        this.cleanConfiguration(this.getBuildConfiguration(targetName, "Debug"));
    }

    public void cleanConfiguration(String targetName, String configurationName) throws Exception {
        this.cleanConfiguration(this.getBuildConfiguration(targetName, configurationName));
    }

    public void cleanConfiguration(CMakeAppRunConfiguration.BuildAndRunConfigurations configurations) throws Exception {
        Pair<Boolean, String> result = this.cleanConfiguration((CidrBuildConfiguration)configurations.buildConfiguration);
        CMakeProjectFixture.assertTrue((String)((String)result.second), (boolean)((Boolean)result.first));
    }

    public Pair<Boolean, String> installConfiguration(String targetName, String configurationName) throws Exception {
        CMakeAppRunConfiguration.BuildAndRunConfigurations configurations = this.getBuildConfiguration(targetName, configurationName);
        return this.installConfiguration((CidrBuildConfiguration)configurations.buildConfiguration);
    }

    public void compileFile(String targetName, String configurationName, String makeTargetName, boolean allowToFail) throws Exception {
        CMakeAppRunConfiguration.BuildAndRunConfigurations configurations = this.getBuildConfiguration(targetName, configurationName);
        this.doExecuteConfig(allowToFail, null, (Function<ProcessListener, ExecutionResult<CidrBuildResult>>)((Function)listener -> CMakeBuild.compileFile((Project)this.getProject(), (CMakeAppRunConfiguration.BuildAndRunConfigurations)configurations, (String)makeTargetName, null, null, (ProcessListener)listener)));
    }

    public void compileFile(String targetName, String configurationName, VirtualFile file2, boolean allowToFail) throws Exception {
        CMakeAppRunConfiguration.BuildAndRunConfigurations configurations = this.getBuildConfiguration(targetName, configurationName);
        this.doExecuteConfig(allowToFail, null, (Function<ProcessListener, ExecutionResult<CidrBuildResult>>)((Function)listener -> CMakeCompileTaskRunner.compileFile((Project)this.getProject(), (VirtualFile)file2, (VirtualFile)file2, (CMakeAppRunConfiguration.BuildAndRunConfigurations)configurations, (String)("compile " + file2.getName()), null, (ProcessListener)listener)));
    }

    @Override
    protected ExecutionResult<CidrBuildResult> doBuildOrCleanConfig(@NotNull CMakeAppRunConfiguration.BuildAndRunConfigurations config, boolean build2, @Nullable ProcessListener listener) {
        if (config == null) {
            CMakeProjectFixture.$$$reportNull$$$0(36);
        }
        return build2 ? CMakeBuild.build((Project)this.getProject(), (CMakeAppRunConfiguration.BuildAndRunConfigurations)config, (ProcessListener)listener) : CMakeBuild.clean((Project)this.getProject(), (CMakeAppRunConfiguration.BuildAndRunConfigurations)config, (ProcessListener)listener);
    }

    @Override
    public CMakeAppRunConfiguration.BuildAndRunConfigurations getBuildConfiguration(@NotNull CidrRunConfiguration runConfiguration, @Nullable ExecutionTarget target) {
        if (runConfiguration == null) {
            CMakeProjectFixture.$$$reportNull$$$0(37);
        }
        CMakeProjectFixture.assertTrue((boolean)(runConfiguration instanceof CMakeAppRunConfiguration));
        String profileName = CMakeProjectFixture.getTestProfileNameFor(runConfiguration);
        return ((CMakeAppRunConfiguration)runConfiguration).getBuildAndRunConfigurations(profileName);
    }

    @NotNull
    public static String getTestProfileNameFor(@NotNull CidrRunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            CMakeProjectFixture.$$$reportNull$$$0(38);
        }
        String profileName = runConfiguration.getTargetAndConfigurationData().configurationName;
        CMakeProjectFixture.assertNotNull((String)"Profile name was not specified when run configuration was created for the test", (Object)profileName);
        String string = profileName;
        if (string == null) {
            CMakeProjectFixture.$$$reportNull$$$0(39);
        }
        return string;
    }

    public CMakeAppRunConfiguration.BuildAndRunConfigurations createBuildConfiguration(@Nullable String target, @Nullable String configurationName) throws Exception {
        return (CMakeAppRunConfiguration.BuildAndRunConfigurations)this.getBuildConfiguration((CidrRunConfiguration)this.createRunConfiguration(target, configurationName));
    }

    public CMakeAppRunConfiguration createRunConfiguration(@Nullable String target, @Nullable String configurationName) throws Exception {
        BuildTargetAndConfigurationData data = new BuildTargetAndConfigurationData(this.getProjectName(), target, configurationName);
        CMakeAppRunConfiguration configuration2 = (CMakeAppRunConfiguration)this.createRunConfiguration((ConfigurationTypeBase)CMakeAppRunConfigurationType.getInstance(), data, null).getConfiguration();
        if (data.target != null) {
            configuration2.setExecutableData(new ExecutableData(data.target));
        }
        return configuration2;
    }

    public static void convertFileToDefaultCharset(File file2) throws IOException {
        String text = FileUtil.loadFile((File)file2, (Charset)StandardCharsets.UTF_8);
        FileUtil.writeToFile((File)file2, (byte[])text.getBytes(Charset.defaultCharset()));
    }

    @Override
    protected String getConfigBuildId(@NotNull CMakeAppRunConfiguration.BuildAndRunConfigurations config) {
        if (config == null) {
            CMakeProjectFixture.$$$reportNull$$$0(40);
        }
        Function configurationId = config1 -> config1.getName() + "|" + config1.getProductFile() + "|" + config1.getTarget().getName() + "|" + config1.getTarget().getProjectName();
        StringBuilder id = new StringBuilder();
        id.append((String)configurationId.fun((Object)config.buildConfiguration));
        if (config.runConfiguration != null) {
            id.append((String)configurationId.fun((Object)config.runConfiguration));
        }
        if (config.runExecutable != null) {
            id.append("|").append(config.runExecutable);
        }
        return id.toString();
    }

    @Override
    @NotNull
    public String getProjectName() {
        String string = this.getModel().getProjectName();
        if (string == null) {
            CMakeProjectFixture.$$$reportNull$$$0(41);
        }
        return string;
    }

    public void setExecutableTarget(CMakeAppRunConfiguration runConfiguration, String targetName, String configurationName) {
        CMakeConfiguration execConf = this.getBuildConfiguration((String)targetName, (String)configurationName).buildConfiguration;
        CMakeProjectFixture.assertNotNull((Object)execConf);
        runConfiguration.setExecutableData(new ExecutableData(new BuildTargetData((CidrBuildTarget)execConf.getTarget())));
    }

    static {
        CidrCodeInsightFixture.addIconsClass(CLionIcons.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 39: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 39: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testDataFixture";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: 
            case 6: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/CMakeProjectFixture";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeProjectPath";
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compiler";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testClassFQN";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testName";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDir";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerPath";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configName";
                break;
            }
            case 36: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/CMakeProjectFixture";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareCMakeProjectCache";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsConfigurator";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "doOpenProject";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getCidrWorkspace";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkspaceModifiableModel";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getCMakeWorkspace";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getCMakeListsFile";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getMissingFilesInTargetCMakeErrors";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelTargets";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelGenerationDir";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelConfigurationData";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getProductFile";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestProfileNameFor";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "collectAllowedRoots";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "prepareCMakeProjectCache";
                break;
            }
            case 3: 
            case 6: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 39: 
            case 41: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createAndCopyCMakeProjectCache";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "initProject";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "initOrUpdateProjectWithCompiler";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "initOrUpdateProjectWithCompilerAndProfiles";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "projectChangedSomehow";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setUp";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "doOpenProject";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "updateCMakeSettingsConfig";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findModelTarget";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getModelGenerationDir";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getModelConfigurationData";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "doBuildOrCleanConfig";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getBuildConfiguration";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getTestProfileNameFor";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getConfigBuildId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 39: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

