/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.Function;
import com.jetbrains.cidr.CidrCodeInsightFixture;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import java.util.Collection;
import junit.framework.TestCase;

public final class FileSymbolTableCacheTestUtils {
    private FileSymbolTableCacheTestUtils() {
    }

    public static void cleanUpCacheAndDeserializeTables(Project project2, Collection<VirtualFile> filesToLoad) {
        FileSymbolTablesCache cache = FileSymbolTablesCache.getInstance((Project)project2);
        cache.clearAllTables();
        cache.deserializeTables(project2.getLocationHash(), filesToLoad, (ProgressIndicator)new DumbProgressIndicator(), 1.0);
    }

    public static void assertOutOfBlockModificationTracker(PsiFile file2, CidrCodeInsightFixture fixture) {
        Project project2 = file2.getProject();
        FileSymbolTablesCache cache = FileSymbolTablesCache.getInstance((Project)project2);
        ModificationTracker tracker = cache.getOutOfBlockModificationTracker();
        PsiModificationTracker psiTracker = PsiManager.getInstance((Project)project2).getModificationTracker();
        long count = tracker.getModificationCount();
        long psiCount = psiTracker.getModificationCount();
        file2.getManager().dropPsiCaches();
        TestCase.assertTrue((psiCount != psiTracker.getModificationCount() ? 1 : 0) != 0);
        TestCase.assertEquals((long)count, (long)tracker.getModificationCount());
        count = tracker.getModificationCount();
        psiCount = psiTracker.getModificationCount();
        fixture.edit(file2, (Function<Document, Void>)((Function)document -> {
            document.insertString(fixture.getCaretOffset(), (CharSequence)"x;");
            return null;
        }));
        TestCase.assertTrue((psiCount != psiTracker.getModificationCount() ? 1 : 0) != 0);
        TestCase.assertEquals((long)count, (long)tracker.getModificationCount());
        count = tracker.getModificationCount();
        psiCount = psiTracker.getModificationCount();
        fixture.edit(file2, (Function<Document, Void>)((Function)document -> {
            document.insertString(0, (CharSequence)"x;\n");
            return null;
        }));
        TestCase.assertTrue((psiCount != psiTracker.getModificationCount() ? 1 : 0) != 0);
        TestCase.assertTrue((count != tracker.getModificationCount() ? 1 : 0) != 0);
        count = tracker.getModificationCount();
        psiCount = psiTracker.getModificationCount();
        FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{file2.getVirtualFile()});
        TestCase.assertTrue((psiCount != psiTracker.getModificationCount() ? 1 : 0) != 0);
        TestCase.assertTrue((count != tracker.getModificationCount() ? 1 : 0) != 0);
        Object js = fixture.configureByText("", "foo.xml");
        count = tracker.getModificationCount();
        psiCount = psiTracker.getModificationCount();
        fixture.edit((PsiFile)js, (Function<Document, Void>)((Function)document -> {
            document.insertString(0, (CharSequence)"x;\n");
            return null;
        }));
        TestCase.assertTrue((psiCount != psiTracker.getModificationCount() ? 1 : 0) != 0);
        TestCase.assertEquals((long)count, (long)tracker.getModificationCount());
    }
}

