/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.stylus.formatter;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.editor.CssFormattingModelBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.stylus.psi.StylusElementTypes;
import org.jetbrains.plugins.stylus.psi.StylusTokenTypes;

public class StylusSelectorBlock
extends CssFormattingModelBuilder.CssSelectorBlock {
    private static final TokenSet TOKENS_WITH_FLEXIBLE_SPACING = TokenSet.create((IElementType[])new IElementType[]{StylusElementTypes.REFERENCE_EXPRESSION});

    public StylusSelectorBlock(ASTNode _node, Indent indent, CssFormattingModelBuilder.CssFormattingExtension extension) {
        super(_node, indent, extension);
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        Block previousBlock;
        if (newChildIndex > 0 && (previousBlock = (Block)this.mySubBlocks.get(newChildIndex - 1)) instanceof CssFormattingModelBuilder.CssFormatterBlock) {
            ASTNode nextNode = ((CssFormattingModelBuilder.CssFormatterBlock)previousBlock).getNode().getTreeNext();
            boolean processWithIndent = true;
            for (int i = 0; i < 3; ++i) {
                if (nextNode == null) {
                    processWithIndent = false;
                    break;
                }
                if (!nextNode.getText().equals("\n")) {
                    processWithIndent = false;
                }
                nextNode = nextNode.getTreeNext();
            }
            if (processWithIndent) {
                return new ChildAttributes(Indent.getNormalIndent(), null);
            }
        }
        ChildAttributes childAttributes = super.getChildAttributes(newChildIndex);
        if (childAttributes == null) {
            StylusSelectorBlock.$$$reportNull$$$0(0);
        }
        return childAttributes;
    }

    @Nullable
    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        if (child2 == null) {
            StylusSelectorBlock.$$$reportNull$$$0(1);
        }
        if (child1 instanceof CssFormattingModelBuilder.CssFormatterBlock && child2 instanceof CssFormattingModelBuilder.CssFormatterBlock) {
            CssFormattingModelBuilder.CssFormatterBlock block1 = (CssFormattingModelBuilder.CssFormatterBlock)child1;
            CssFormattingModelBuilder.CssFormatterBlock block2 = (CssFormattingModelBuilder.CssFormatterBlock)child2;
            if (block1.myType == CssElementTypes.CSS_SIMPLE_SELECTOR && block2.myType == CssElementTypes.CSS_SIMPLE_SELECTOR && block2.getNode().getFirstChildNode().getElementType() == StylusTokenTypes.AMPERSAND) {
                return Spacing.createSpacing((int)0, (int)1, (int)0, (boolean)true, (int)0);
            }
        }
        if (StylusSelectorBlock.isBlockWithFlexibleSpacing(child1) || StylusSelectorBlock.isBlockWithFlexibleSpacing(child2)) {
            return Spacing.createSpacing((int)0, (int)1, (int)0, (boolean)false, (int)0);
        }
        return super.getSpacing(child1, child2);
    }

    private static boolean isBlockWithFlexibleSpacing(Block block) {
        if (block instanceof ASTBlock) {
            return TOKENS_WITH_FLEXIBLE_SPACING.contains(((ASTBlock)block).getNode().getElementType());
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/stylus/formatter/StylusSelectorBlock";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildAttributes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/stylus/formatter/StylusSelectorBlock";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

