/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.Node;
import org.jetbrains.idea.svn.RootUrlPair;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.Url;

public class RootUrlInfo
implements RootUrlPair {
    @NotNull
    private final WorkingCopyFormat myFormat;
    @NotNull
    private final Node myNode;
    @NotNull
    private final VirtualFile myRoot;
    @Nullable
    private volatile NestedCopyType myType;

    public RootUrlInfo(@NotNull Node node, @NotNull WorkingCopyFormat format, @NotNull VirtualFile root) {
        if (node == null) {
            RootUrlInfo.$$$reportNull$$$0(0);
        }
        if (format == null) {
            RootUrlInfo.$$$reportNull$$$0(1);
        }
        if (root == null) {
            RootUrlInfo.$$$reportNull$$$0(2);
        }
        this(node, format, root, null);
    }

    public RootUrlInfo(@NotNull Node node, @NotNull WorkingCopyFormat format, @NotNull VirtualFile root, @Nullable NestedCopyType type) {
        if (node == null) {
            RootUrlInfo.$$$reportNull$$$0(3);
        }
        if (format == null) {
            RootUrlInfo.$$$reportNull$$$0(4);
        }
        if (root == null) {
            RootUrlInfo.$$$reportNull$$$0(5);
        }
        this.myNode = node;
        this.myFormat = format;
        this.myRoot = root;
        this.myType = type;
    }

    @NotNull
    public Node getNode() {
        Node node = this.myNode;
        if (node == null) {
            RootUrlInfo.$$$reportNull$$$0(6);
        }
        return node;
    }

    @NotNull
    public Url getRepositoryUrl() {
        Url url = this.myNode.getRepositoryRootUrl();
        if (url == null) {
            RootUrlInfo.$$$reportNull$$$0(7);
        }
        return url;
    }

    @NotNull
    public WorkingCopyFormat getFormat() {
        WorkingCopyFormat workingCopyFormat = this.myFormat;
        if (workingCopyFormat == null) {
            RootUrlInfo.$$$reportNull$$$0(8);
        }
        return workingCopyFormat;
    }

    @NotNull
    public File getIoFile() {
        File file = this.myNode.getIoFile();
        if (file == null) {
            RootUrlInfo.$$$reportNull$$$0(9);
        }
        return file;
    }

    @NlsSafe
    @NotNull
    public String getPath() {
        String string = this.getIoFile().getAbsolutePath();
        if (string == null) {
            RootUrlInfo.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public VirtualFile getRoot() {
        VirtualFile virtualFile = this.myRoot;
        if (virtualFile == null) {
            RootUrlInfo.$$$reportNull$$$0(11);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myNode.getFile();
        if (virtualFile == null) {
            RootUrlInfo.$$$reportNull$$$0(12);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public Url getUrl() {
        Url url = this.myNode.getUrl();
        if (url == null) {
            RootUrlInfo.$$$reportNull$$$0(13);
        }
        return url;
    }

    @Nullable
    public NestedCopyType getType() {
        return this.myType;
    }

    public void setType(@Nullable NestedCopyType type) {
        this.myType = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RootUrlInfo info2 = (RootUrlInfo)o;
        if (this.myFormat != info2.myFormat) {
            return false;
        }
        if (!this.myNode.equals(info2.myNode)) {
            return false;
        }
        if (!this.myRoot.equals(info2.myRoot)) {
            return false;
        }
        return this.myType == info2.myType;
    }

    public int hashCode() {
        int result = this.myFormat.hashCode();
        result = 31 * result + this.myNode.hashCode();
        result = 31 * result + this.myRoot.hashCode();
        result = 31 * result + (this.myType != null ? this.myType.hashCode() : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/RootUrlInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/RootUrlInfo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNode";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryUrl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormat";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getIoFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

