/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrPathManager;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchainsUtil;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.toolchains.CidrExecutableTool;
import com.jetbrains.cidr.toolchains.CidrToolsUtil;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class CMakeExecutableTool
extends CidrExecutableTool {
    public static final Version MIN_VERSION = new Version(2, 8, 11);
    public static final Version MAX_VERSION = new Version(3, 20, -1);
    @NotNull
    private final CPPEnvironment myEnvironment;
    @Nullable
    private static Supplier<String> ourHashCalculatorInTests = null;

    public CMakeExecutableTool(@NotNull File executable, @NotNull CPPEnvironment env) {
        if (executable == null) {
            CMakeExecutableTool.$$$reportNull$$$0(0);
        }
        if (env == null) {
            CMakeExecutableTool.$$$reportNull$$$0(1);
        }
        super(executable);
        this.myEnvironment = env;
    }

    public CPPEnvironment getEnv() {
        return this.myEnvironment;
    }

    @NotNull
    public static File getBundledCMakeToolBinary(boolean cygwin, @NotNull ToolKind execTool) {
        if (execTool == null) {
            CMakeExecutableTool.$$$reportNull$$$0(2);
        }
        String platformBinPath = "cmake/" + (cygwin ? "cygwin/bin" : CidrPathManager.getPlatformRelativePath((String)"bin"));
        File file = CidrPathManager.getBinPath(CMakeExecutableTool.class, (String)"clion/bin", (String)(platformBinPath + "/" + execTool.getOSExecutableName()), (String)platformBinPath).toFile();
        if (file == null) {
            CMakeExecutableTool.$$$reportNull$$$0(3);
        }
        return file;
    }

    public static boolean hasBundledTool(boolean cygwin, @NotNull ToolKind execTool) {
        if (execTool == null) {
            CMakeExecutableTool.$$$reportNull$$$0(4);
        }
        return CMakeExecutableTool.getBundledCMakeToolBinary(cygwin, execTool).exists();
    }

    @Override
    @NotNull
    public File getExecutable() {
        File file = this.myExecutable;
        if (file == null) {
            CMakeExecutableTool.$$$reportNull$$$0(5);
        }
        return file;
    }

    @Override
    @Nullable
    public String readVersion() {
        ProgressIndicator indicator = CidrToolsUtil.getProgressIndicator();
        ProcessOutput output = this.executeWithOutput(new GeneralCommandLine().withParameters(new String[]{"-version"}), (ProgressIndicator)(indicator == null ? new EmptyProgressIndicator() : indicator), 10000);
        String result = null;
        if (output != null) {
            result = StringUtil.nullize((String)((String)ContainerUtil.getFirstItem((List)StringsKt.lines((CharSequence)output.getStdout()))), (boolean)true);
        }
        if (CPPLog.LOG.isDebugEnabled()) {
            CPPLog.logReadVersion("CMake tool", this.myExecutable, result);
        }
        return result == null ? null : StringUtil.trimStart((String)result, (String)"cmake version ");
    }

    public ProcessOutput executeWithOutput(@NotNull GeneralCommandLine commandLine, @NotNull ProgressIndicator indicator, int timeout) {
        if (commandLine == null) {
            CMakeExecutableTool.$$$reportNull$$$0(6);
        }
        if (indicator == null) {
            CMakeExecutableTool.$$$reportNull$$$0(7);
        }
        commandLine.setExePath(this.myExecutable.getPath());
        try {
            this.myEnvironment.getToolSet().prepareEnvironment(commandLine, CidrToolEnvironment.PrepareFor.BUILD, Collections.emptyList());
            ProcessOutput output = this.myEnvironment.getHostMachine().runProcess(commandLine, indicator, timeout);
            CidrToolsUtil.checkSuccess((GeneralCommandLine)commandLine, (ProcessOutput)output, (Logger)CPPLog.LOG);
            if (CPPLog.LOG.isDebugEnabled()) {
                CPPLog.LOG.debug(CidrToolsUtil.logInfo((GeneralCommandLine)commandLine, (ProcessOutput)output));
            }
            return output;
        }
        catch (Throwable e) {
            CPPLog.LOG.warn("Execution problem:", e);
            return null;
        }
    }

    @Override
    @Nullable
    public ToolVersion readToolVersion() {
        String version = this.readVersion();
        return version == null ? null : CMakeExecutableTool.parseToolVersion(version);
    }

    @Nullable
    @NlsSafe
    public static String checkVersion(@NotNull String version) {
        if (version == null) {
            CMakeExecutableTool.$$$reportNull$$$0(8);
        }
        return CPPToolchainsUtil.checkVersion(MIN_VERSION, MAX_VERSION, CMakeExecutableTool.parseToolVersion(version));
    }

    @NotNull
    private static ToolVersion parseToolVersion(@NotNull String version) {
        if (version == null) {
            CMakeExecutableTool.$$$reportNull$$$0(9);
        }
        ToolVersion toolVersion = ToolVersion.parse((String)version, (Pattern[])new Pattern[]{CPPToolchainsUtil.VERSION_PATTERN});
        if (toolVersion == null) {
            CMakeExecutableTool.$$$reportNull$$$0(10);
        }
        return toolVersion;
    }

    @TestOnly
    public static void setHashCalculatorInTests(@Nullable Supplier<String> hashCalculatorInTests) {
        ourHashCalculatorInTests = hashCalculatorInTests;
    }

    @NotNull
    public String calcCMakeHash() {
        if (ourHashCalculatorInTests != null) {
            String string = ourHashCalculatorInTests.get();
            if (string == null) {
                CMakeExecutableTool.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = "CMake: " + this.readVersion() + "@" + this.getExecutable() + "\n";
        if (string == null) {
            CMakeExecutableTool.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public static File getBundledCMakeBinary(boolean cygwin) {
        return CMakeExecutableTool.getBundledCMakeToolBinary(cygwin, ToolKind.CMAKE);
    }

    public static boolean hasBundledCMake(boolean cygwin) {
        return CMakeExecutableTool.hasBundledTool(cygwin, ToolKind.CMAKE);
    }

    @NotNull
    public static CMakeExecutableTool getBundledCMake(@NotNull CPPEnvironment env) {
        if (env == null) {
            CMakeExecutableTool.$$$reportNull$$$0(13);
        }
        return new CMakeExecutableTool(CMakeExecutableTool.getBundledCMakeToolBinary(env.isCygwin(), ToolKind.CMAKE), env);
    }

    @Nullable
    @NlsSafe
    public static String readCMakeVersion(@Nullable CPPToolchains.Toolchain toolchain) {
        return CMakeExecutableTool.doWithToolchainCMake(toolchain, CMakeExecutableTool::readVersion);
    }

    @Nullable
    public static ToolVersion readCMakeToolVersion(@Nullable CPPToolchains.Toolchain toolchain) {
        return CMakeExecutableTool.doWithToolchainCMake(toolchain, CMakeExecutableTool::readToolVersion);
    }

    @Nullable
    private static <T> T doWithToolchainCMake(@Nullable CPPToolchains.Toolchain toolchain, Function<CMakeExecutableTool, T> fun) {
        CMakeExecutableTool cmake = toolchain == null ? null : new CPPEnvironment(toolchain).getCMake();
        return cmake == null ? null : (T)fun.apply(cmake);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executable";
                break;
            }
            case 1: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "execTool";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/CMakeExecutableTool";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/CMakeExecutableTool";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundledCMakeToolBinary";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutable";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "parseToolVersion";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "calcCMakeHash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBundledCMakeToolBinary";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasBundledTool";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "executeWithOutput";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkVersion";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseToolVersion";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getBundledCMake";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum ToolKind {
        CMAKE("cmake", "CMakeCurrentExecutableName"),
        CTEST("ctest", "CTestCurrentExecutableName");

        private final String myExecutableName;
        private final String myMacroName;

        private ToolKind(String executableName, String macroName) {
            if (executableName == null) {
                ToolKind.$$$reportNull$$$0(0);
            }
            this.myExecutableName = executableName;
            this.myMacroName = macroName;
        }

        @NotNull
        public String getOSExecutableName() {
            String string = this.myExecutableName + (SystemInfo.isWindows ? ".exe" : "");
            if (string == null) {
                ToolKind.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getExecutableName(@NotNull CPPToolSet toolset) {
            if (toolset == null) {
                ToolKind.$$$reportNull$$$0(2);
            }
            if (toolset.isMinGW() || toolset.isMSVC()) {
                String string = this.myExecutableName + ".exe";
                if (string == null) {
                    ToolKind.$$$reportNull$$$0(3);
                }
                return string;
            }
            String string = this.myExecutableName;
            if (string == null) {
                ToolKind.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public String getMacro() {
            String string = "$" + this.myMacroName + "$";
            if (string == null) {
                ToolKind.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        public String getMacroName() {
            String string = this.myMacroName;
            if (string == null) {
                ToolKind.$$$reportNull$$$0(6);
            }
            return string;
        }

        @NotNull
        public String getExecutableName() {
            String string = this.myExecutableName;
            if (string == null) {
                ToolKind.$$$reportNull$$$0(7);
            }
            return string;
        }

        @Nullable
        public static ToolKind findMacro(@NotNull String maybeMacro) {
            if (maybeMacro == null) {
                ToolKind.$$$reportNull$$$0(8);
            }
            for (ToolKind e : ToolKind.values()) {
                if (!e.getMacro().equals(maybeMacro)) continue;
                return e;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executableName";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/CMakeExecutableTool$ToolKind";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolset";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "maybeMacro";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/CMakeExecutableTool$ToolKind";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOSExecutableName";
                    break;
                }
                case 3: 
                case 4: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExecutableName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMacro";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMacroName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getExecutableName";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "findMacro";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

