/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SortedList;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.cpp.ToolchainsBundle;
import com.jetbrains.cidr.cpp.toolchains.CPPDebugger;
import com.jetbrains.cidr.lang.toolchains.CidrFileSeparators;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.system.RemoteUtil;
import com.jetbrains.cidr.toolchains.OSType;
import icons.CidrToolchainsIcons;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CPPToolSet {
    @NotNull
    protected final Kind myKind;

    public CPPToolSet(@NotNull Kind kind) {
        if (kind == null) {
            CPPToolSet.$$$reportNull$$$0(0);
        }
        this.myKind = kind;
    }

    @NotNull
    public Kind getKind() {
        Kind kind = this.myKind;
        if (kind == null) {
            CPPToolSet.$$$reportNull$$$0(1);
        }
        return kind;
    }

    @NotNull
    @Nls
    public String getName() {
        String string = this.myKind.getDisplayName();
        if (string == null) {
            CPPToolSet.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public abstract String readVersion();

    @Nullable
    public abstract ToolVersion readToolVersion();

    @NlsSafe
    public abstract String checkVersion(@NotNull String var1);

    public boolean isMSVC() {
        return this.myKind == Kind.MSVC;
    }

    public boolean isCygwin() {
        return this.myKind == Kind.CYGWIN;
    }

    public boolean isMinGW() {
        return this.myKind == Kind.MINGW;
    }

    public boolean isWSL() {
        return this.myKind == Kind.WSL;
    }

    public boolean isRemote() {
        return this.myKind == Kind.REMOTE;
    }

    @NotNull
    public abstract CidrFileSeparators getSupportedFileSeparators();

    @Nullable
    public abstract File getGDBPath();

    public abstract boolean supportsDebugger(@NotNull CPPDebugger.Kind var1);

    @Nullable
    public String isDebugSupportDisabled() {
        return null;
    }

    public void prepareEnvironment(@NotNull GeneralCommandLine cl, @NotNull CidrToolEnvironment.PrepareFor prepareFor, @NotNull List<Option> options) throws ExecutionException {
        if (cl == null) {
            CPPToolSet.$$$reportNull$$$0(3);
        }
        if (prepareFor == null) {
            CPPToolSet.$$$reportNull$$$0(4);
        }
        if (options == null) {
            CPPToolSet.$$$reportNull$$$0(5);
        }
    }

    protected static void prependPathVariable(@NotNull GeneralCommandLine cl, String ... paths) {
        if (cl == null) {
            CPPToolSet.$$$reportNull$$$0(6);
        }
        if (paths == null) {
            CPPToolSet.$$$reportNull$$$0(7);
        }
        StringBuilder result = new StringBuilder();
        for (String each : paths) {
            if (result.length() != 0) {
                result.append(";");
            }
            result.append(FileUtil.toSystemDependentName((String)each));
        }
        Map system = CollectionFactory.createCaseInsensitiveStringMap((Map)cl.getEffectiveEnvironment());
        if (system.containsKey("PATH")) {
            if (result.length() != 0) {
                result.append(";");
            }
            result.append((String)system.get("PATH"));
        }
        cl.getEnvironment().put("PATH", result.toString());
    }

    public String toString() {
        return this.getName();
    }

    @NotNull
    protected static List<Trinity<String, File, Boolean>> createSortedVersionsList() {
        return new SortedList((o1, o2) -> {
            int result = Boolean.compare((Boolean)o2.third, (Boolean)o1.third);
            if (result != 0) {
                return result;
            }
            result = StringUtil.compareVersionNumbers((String)((String)o2.first), (String)((String)o1.first));
            if (result != 0) {
                return result;
            }
            return FileUtil.compareFiles((File)((File)o1.second), (File)((File)o2.second));
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/CPPToolSet";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prepareFor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/CPPToolSet";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "prepareEnvironment";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "prependPathVariable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface InstallationProcessor {
        public boolean process(@NotNull File var1, boolean var2);
    }

    public static interface Option {
        @NotNull
        public String getValue();

        public void write(@NotNull Element var1);

        @NotNull
        public String getUniqueID();
    }

    public static enum Kind {
        MINGW("http://mingw-w64.org/doku.php/download/mingw-builds", CidrToolchainsIcons.MinGW){

            @Override
            @NotNull
            public String getDisplayName() {
                String string = ToolchainsBundle.message("mingw", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/cpp/toolchains/CPPToolSet$Kind$1", "getDisplayName"));
            }
        }
        ,
        CYGWIN("https://cygwin.com/install.html", CidrToolchainsIcons.Cygwin){

            @Override
            @NotNull
            public String getDisplayName() {
                String string = ToolchainsBundle.message("cygwin", new Object[0]);
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/cpp/toolchains/CPPToolSet$Kind$2", "getDisplayName"));
            }
        }
        ,
        MSVC("https://www.visualstudio.com/downloads/", CidrToolchainsIcons.MSVC){

            @Override
            @NotNull
            public String getDisplayName() {
                String string = ToolchainsBundle.message("msvc", new Object[0]);
                if (string == null) {
                    3.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/cpp/toolchains/CPPToolSet$Kind$3", "getDisplayName"));
            }
        }
        ,
        WSL("https://www.microsoft.com/store/productId/9NBLGGH4MSV6", AllIcons.RunConfigurations.Wsl){

            @Override
            @NotNull
            public String getDisplayName() {
                String string = ToolchainsBundle.message("wsl", new Object[0]);
                if (string == null) {
                    4.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/cpp/toolchains/CPPToolSet$Kind$4", "getDisplayName"));
            }
        }
        ,
        SYSTEM_UNIX_TOOLSET(null, AllIcons.Nodes.Console){

            @Override
            @NotNull
            public String getDisplayName() {
                String string = ToolchainsBundle.message("system", new Object[0]);
                if (string == null) {
                    5.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            boolean requiresHomePath() {
                return false;
            }

            @Override
            public boolean isSupportedOn(@NotNull OSType os) {
                if (os == null) {
                    5.$$$reportNull$$$0(1);
                }
                return os != OSType.WIN;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/CPPToolSet$Kind$5";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "os";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDisplayName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/CPPToolSet$Kind$5";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "isSupportedOn";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
        ,
        REMOTE(null, CidrToolchainsIcons.RemoteToolSet){

            @Override
            @NotNull
            public String getDisplayName() {
                String string = ToolchainsBundle.message("remote.host", new Object[0]);
                if (string == null) {
                    6.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            boolean requiresHomePath() {
                return false;
            }

            @Override
            public boolean isSupportedOn(@NotNull OSType os) {
                if (os == null) {
                    6.$$$reportNull$$$0(1);
                }
                return RemoteUtil.isFullRemoteModeAvailable();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/CPPToolSet$Kind$6";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "os";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDisplayName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/CPPToolSet$Kind$6";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "isSupportedOn";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };

        @Nullable
        private final String myDownloadPage;
        @NotNull
        private final Icon myIcon;

        private Kind(String downloadPage, Icon icon) {
            if (icon == null) {
                Kind.$$$reportNull$$$0(0);
            }
            this.myDownloadPage = downloadPage;
            this.myIcon = icon;
        }

        @NotNull
        @Nls
        public abstract String getDisplayName();

        @Nullable
        public String getDownloadPage() {
            return this.myDownloadPage;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = this.myIcon;
            if (icon == null) {
                Kind.$$$reportNull$$$0(1);
            }
            return icon;
        }

        public boolean isSupportedOn(@NotNull OSType os) {
            if (os == null) {
                Kind.$$$reportNull$$$0(2);
            }
            if (this == WSL && !SystemInfo.isWin10OrNewer) {
                return false;
            }
            return os == OSType.WIN;
        }

        @NotNull
        public static List<Kind> getSupportedOn(@NotNull OSType os) {
            if (os == null) {
                Kind.$$$reportNull$$$0(3);
            }
            List list = ContainerUtil.filter((Object[])Kind.values(), it -> it.isSupportedOn(os));
            if (list == null) {
                Kind.$$$reportNull$$$0(4);
            }
            return list;
        }

        @NotNull
        public static Kind getDefaultSupportedOn(@NotNull OSType os) {
            if (os == null) {
                Kind.$$$reportNull$$$0(5);
            }
            Kind kind = (Kind)((Object)ContainerUtil.getFirstItem(Kind.getSupportedOn(os), (Object)((Object)SYSTEM_UNIX_TOOLSET)));
            if (kind == null) {
                Kind.$$$reportNull$$$0(6);
            }
            return kind;
        }

        boolean requiresHomePath() {
            return true;
        }

        public boolean isRemote() {
            return this == REMOTE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 4: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 4: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 1: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/CPPToolSet$Kind";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "os";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/CPPToolSet$Kind";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSupportedOn";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultSupportedOn";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 4: 
                case 6: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isSupportedOn";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getSupportedOn";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getDefaultSupportedOn";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 4: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

