/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.text.ReverseCharSequence;
import com.jetbrains.cidr.execution.DimmableFilter;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrPathConsoleFilter
implements Filter,
DumbAware,
DimmableFilter {
    public static final int MAX_TIME_PER_LINE = 250;
    private static final String LINE_NUMBER = "\\d{1,5}";
    private static final String PATH_SEPARATOR = SystemInfo.isWindows ? "[/\\\\]" : "/";
    private static final Pattern ABSOLUTE_WIN_PATH_PREFIX = Pattern.compile("^(/|([A-Za-z]:(" + PATH_SEPARATOR + "))).*");
    private static final Pattern PARENT_DIRS_PREFIX = Pattern.compile("^([.](" + PATH_SEPARATOR + ")+)?([.]{2}(" + PATH_SEPARATOR + ")+)+");
    public static final String LINE_PATTERN_TEXT = "(?:\\((\\d{1,5})\\))|:(\\d{1,5})";
    private static final Pattern LINE_NUMBER_PATTERN = Pattern.compile("[^:](?:(?:\\((\\d{1,5})\\))|:(\\d{1,5})(?::(\\d{1,5}))?(?::?\\b|_))");
    private static final String STARTING_CHARS = "-+\\p{LC}\\d~._|@";
    private static final String FILE_CHARS = "-+\\p{LC}\\d~._|@{}\\(\\)\\[\\]";
    private static final String WS = "\t ";
    private static final String FILE_CHARS_CLASS = "[-+\\p{LC}\\d~._|@{}\\(\\)\\[\\]]";
    private static final String FILE_CHARS_WS_CLASS = "[-+\\p{LC}\\d~._|@{}\\(\\)\\[\\]\t ]";
    private static final String STARTING_CHARS_CLASS = "[-+\\p{LC}\\d~._|@]";
    private static final String WS_CLASS = "[\t ]";
    private static final String REVERSE_ABSOLUTE_PATH_PREFIX = SystemInfo.isWindows ? "(:[A-Za-z])?" : "";
    private static final String SINGLE_WORD_PATH_COMPONENT = "[-+\\p{LC}\\d~._|@{}\\(\\)\\[\\]]*[-+\\p{LC}\\d~._|@]";
    private static final String MULTI_WORD_PATH_COMPONENT = "(?:[-+\\p{LC}\\d~._|@{}\\(\\)\\[\\]][-+\\p{LC}\\d~._|@{}\\(\\)\\[\\]\t ]*|)[-+\\p{LC}\\d~._|@][\t ]*" + PATH_SEPARATOR + "+";
    private static final String PATH_COMPONENT = MULTI_WORD_PATH_COMPONENT + "|[-+\\p{LC}\\d~._|@{}\\(\\)\\[\\]]*[-+\\p{LC}\\d~._|@]";
    private static final String REVERSE_RELATIVE_PATH = "^(?:" + PATH_COMPONENT + ")+";
    private static final Pattern REVERSE_FILE_PATH_PATTERN = Pattern.compile(REVERSE_RELATIVE_PATH + REVERSE_ABSOLUTE_PATH_PREFIX);
    private static final int FILE_GROUP = 0;
    private static final int MSVC_LINE_GROUP = 1;
    private static final int REGULAR_LINE_GROUP = 2;
    private static final int COLUMN_GROUP = 3;
    @NotNull
    protected final Project myProject;
    @Nullable
    private final CidrToolEnvironment myEnvironment;
    @Nullable
    private final Path myBaseDir;
    private boolean myDimHighlighting;

    public CidrPathConsoleFilter(@NotNull Project project, @Nullable CidrToolEnvironment environment, @Nullable Path baseDir) {
        if (project == null) {
            CidrPathConsoleFilter.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myEnvironment = environment;
        this.myBaseDir = baseDir;
    }

    @Override
    public void dimHighlighting() {
        this.myDimHighlighting = true;
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        if (line == null) {
            CidrPathConsoleFilter.$$$reportNull$$$0(1);
        }
        if (!StringUtil.containsAnyChar((String)line, (String)":(")) {
            return null;
        }
        CharSequence expiringLine = CidrPathConsoleFilter.timeLimitedSequence(line);
        Matcher cm = LINE_NUMBER_PATTERN.matcher(expiringLine);
        Matcher fm = null;
        List results = null;
        int lineNumberSearchPosition = 0;
        int pathSearchPosition = 0;
        int lineStart = entireLength - line.length();
        try {
            while (cm.find(lineNumberSearchPosition)) {
                Matcher pm;
                int lineNumber;
                int lineNumberGroup = cm.group(1) != null ? 1 : 2;
                lineNumberSearchPosition = cm.start(lineNumberGroup);
                int lineNumberEndPosition = cm.end(lineNumberGroup);
                if (lineNumberGroup == 1) {
                    ++lineNumberEndPosition;
                }
                try {
                    lineNumber = Math.max(0, Integer.valueOf(cm.group(lineNumberGroup)) - 1);
                }
                catch (NumberFormatException ignore) {
                    continue;
                }
                int columnNumber = 0;
                if (cm.group(3) != null) {
                    try {
                        columnNumber = Math.max(0, Integer.valueOf(cm.group(3)) - 1);
                        lineNumberSearchPosition = cm.start(3);
                        lineNumberEndPosition = cm.end(3);
                    }
                    catch (NumberFormatException ignore) {
                        continue;
                    }
                }
                if (fm == null) {
                    fm = REVERSE_FILE_PATH_PATTERN.matcher((CharSequence)new ReverseCharSequence(expiringLine));
                }
                fm.region(line.length() - cm.start() - 1, line.length() - pathSearchPosition);
                if (!fm.find()) continue;
                int pathStart = line.length() - fm.end(0);
                String filename = line.substring(pathStart, line.length() - fm.start());
                HyperlinkInfo link = this.processMatch(filename, lineNumber, columnNumber);
                if (link == null && filename.startsWith(".") && (pm = PARENT_DIRS_PREFIX.matcher(filename)).find()) {
                    link = this.processMatch(filename.substring(pm.end()), lineNumber, columnNumber);
                }
                if (link == null) continue;
                if (results == null) {
                    results = new SmartList();
                }
                results.add(new Filter.ResultItem(lineStart + pathStart, lineStart + lineNumberEndPosition, link, this.myDimHighlighting));
                pathSearchPosition = lineNumberSearchPosition;
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
        return results == null || results.size() == 0 ? null : new Filter.Result(results);
    }

    private static CharSequence timeLimitedSequence(String line) {
        final long expirationTime = System.currentTimeMillis() + 250L;
        return new StringUtil.BombedCharSequence(line){

            protected void checkCanceled() {
                if (System.currentTimeMillis() > expirationTime) {
                    throw new ProcessCanceledException();
                }
            }
        };
    }

    @Nullable
    protected HyperlinkInfo processMatch(@NotNull String matchedPath, int line, int column) {
        if (matchedPath == null) {
            CidrPathConsoleFilter.$$$reportNull$$$0(2);
        }
        boolean isAbsolute = SystemInfo.isWindows ? ABSOLUTE_WIN_PATH_PREFIX.matcher(matchedPath).matches() : matchedPath.startsWith("/");
        boolean isHomePath = !isAbsolute && !SystemInfo.isWindows && matchedPath.startsWith("~");
        boolean hasSeparator = !isHomePath && (matchedPath.contains(File.separator) || SystemInfo.isWindows && matchedPath.contains("/"));
        VirtualFile file = null;
        if (this.myEnvironment != null && this.myBaseDir != null && (isAbsolute || hasSeparator)) {
            String localPath = this.myEnvironment.toLocalPath(this.myBaseDir.toFile(), matchedPath);
            file = this.processLocalPath(localPath, true, false, hasSeparator);
        }
        if (file == null) {
            file = this.processLocalPath(matchedPath, isAbsolute, isHomePath, hasSeparator);
        }
        return file == null ? null : this.createHyperlinkInfo(file, line, column);
    }

    @Nullable
    protected VirtualFile processLocalPath(@NotNull String localPath, boolean isAbsolute, boolean isHomePath, boolean hasSeparator) {
        VirtualFile file;
        if (localPath == null) {
            CidrPathConsoleFilter.$$$reportNull$$$0(3);
        }
        if (isAbsolute) {
            file = CidrPathConsoleFilter.fileByIOFile(new File(localPath));
        } else if (isHomePath) {
            String userHome = System.getProperty("user.home");
            file = CidrPathConsoleFilter.fileByIOFile(new File(userHome, localPath.substring(1)));
        } else {
            if (this.myBaseDir == null) {
                file = null;
            } else {
                String absolutePath;
                try {
                    absolutePath = this.myBaseDir.resolve(localPath).toString();
                }
                catch (InvalidPathException e) {
                    return null;
                }
                file = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)absolutePath));
            }
            if (file == null && !hasSeparator) {
                file = this.findFirstFileByName(localPath);
            }
        }
        return file;
    }

    @NotNull
    protected HyperlinkInfo createHyperlinkInfo(@NotNull VirtualFile file, int line, int column) {
        if (file == null) {
            CidrPathConsoleFilter.$$$reportNull$$$0(4);
        }
        return new OpenFileHyperlinkInfo(this.myProject, file, line, column);
    }

    @Nullable
    private static VirtualFile fileByIOFile(@NotNull File ioFile) {
        if (ioFile == null) {
            CidrPathConsoleFilter.$$$reportNull$$$0(5);
        }
        return LocalFileSystem.getInstance().findFileByPath(ioFile.getAbsolutePath());
    }

    @Nullable
    private VirtualFile findFirstFileByName(@NotNull String name) {
        if (name == null) {
            CidrPathConsoleFilter.$$$reportNull$$$0(6);
        }
        try {
            Ref result = new Ref();
            FileBasedIndex.getInstance().processValues(FilenameIndex.NAME, (Object)name, null, (file, value) -> {
                result.set((Object)file);
                return false;
            }, GlobalSearchScope.projectScope((Project)this.myProject), null);
            return (VirtualFile)result.get();
        }
        catch (IndexNotReadyException ignore) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchedPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ioFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/execution/CidrPathConsoleFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "applyFilter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processMatch";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processLocalPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createHyperlinkInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "fileByIOFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findFirstFileByName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

