/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.cidr.execution.BuildTargetData;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutableData {
    @Nullable
    public final BuildTargetData target;
    @Nullable
    public final String path;

    public ExecutableData(@NotNull BuildTargetData target) {
        if (target == null) {
            ExecutableData.$$$reportNull$$$0(0);
        }
        this.target = target;
        this.path = null;
    }

    public ExecutableData(@NotNull String path) {
        if (path == null) {
            ExecutableData.$$$reportNull$$$0(1);
        }
        this.target = null;
        this.path = FileUtil.toSystemIndependentName((String)path);
    }

    public String toString() {
        return this.path != null ? "Path: " + this.path : "Target: " + this.target;
    }

    @Nullable
    public static ExecutableData loadExternal(@NotNull Element element) {
        if (element == null) {
            ExecutableData.$$$reportNull$$$0(2);
        }
        String runProjectName = element.getAttributeValue("RUN_TARGET_PROJECT_NAME");
        String runTargetName = element.getAttributeValue("RUN_TARGET_NAME");
        String runPath = element.getAttributeValue("RUN_PATH");
        if (runPath != null) {
            return new ExecutableData(runPath);
        }
        if (runProjectName != null && runTargetName != null) {
            return new ExecutableData(new BuildTargetData(runProjectName, runTargetName));
        }
        return null;
    }

    public void writeExternal(@NotNull Element element) {
        if (element == null) {
            ExecutableData.$$$reportNull$$$0(3);
        }
        if (this.target != null) {
            element.setAttribute("RUN_TARGET_PROJECT_NAME", this.target.projectName);
            element.setAttribute("RUN_TARGET_NAME", this.target.targetName);
        } else if (this.path != null) {
            element.setAttribute("RUN_PATH", this.path);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutableData data = (ExecutableData)o;
        if (!Objects.equals(this.path, data.path)) {
            return false;
        }
        return Objects.equals(this.target, data.target);
    }

    public int hashCode() {
        int result = this.target != null ? this.target.hashCode() : 0;
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/execution/ExecutableData";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "loadExternal";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "writeExternal";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

