/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public final class OCTestExecution {
    private static final ThreadLocal<Boolean> ourCanWaitInThisThread = new ThreadLocal();

    public static <T> T executeWithCachedValuesFast(@NotNull Supplier<T> producer) {
        if (producer == null) {
            OCTestExecution.$$$reportNull$$$0(0);
        }
        return OCTestExecution.execute(producer, false);
    }

    public static <T> T executeWithRealValuesSlow(@NotNull Supplier<T> producer) {
        if (producer == null) {
            OCTestExecution.$$$reportNull$$$0(1);
        }
        return OCTestExecution.execute(producer, true);
    }

    private static <T> T execute(@NotNull Supplier<T> producer, boolean canWait) {
        if (producer == null) {
            OCTestExecution.$$$reportNull$$$0(2);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && ourCanWaitInThisThread.get() != null && ourCanWaitInThisThread.get() == canWait) {
            return producer.get();
        }
        assert (ourCanWaitInThisThread.get() == null);
        ourCanWaitInThisThread.set(canWait);
        try {
            T t = producer.get();
            return t;
        }
        finally {
            ourCanWaitInThisThread.remove();
        }
    }

    public static boolean canWaitInThisThread() {
        Boolean canWait = ourCanWaitInThisThread.get();
        if (canWait != null) {
            return canWait;
        }
        Application application = ApplicationManager.getApplication();
        return !application.isDispatchThread() || application.isUnitTestMode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "producer";
        objectArray2[1] = "com/jetbrains/cidr/execution/testing/OCTestExecution";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "executeWithCachedValuesFast";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "executeWithRealValuesSlow";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

