/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.react;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.e4x.impl.JSXmlAttributeValueImpl;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bH$J#\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\t\u001a\u00020\bH\u0096\u0002J\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\t\u001a\u0004\u0018\u00010\bH$J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\bH\u0002J\"\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\bH\u0002\u00a8\u0006\u0018"}, d2={"Lorg/intellij/idea/lang/javascript/intention/react/JSXChangeAttributeValueIntention;", "Lcom/intellij/lang/javascript/intentions/JavaScriptIntention;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "()V", "findAttributeValueInStatement", "Lcom/intellij/lang/ASTNode;", "statementNode", "getAttributeValueElement", "Lcom/intellij/psi/PsiElement;", "element", "getNewAttributeValue", "", "oldAttribute", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isAcceptableAttributeValueElement", "", "isAttributeValuePlace", "isAvailable", "updateAttributeValue", "intellij.javascript.intentions"})
public abstract class JSXChangeAttributeValueIntention
extends JavaScriptIntention
implements HighPriorityAction {
    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = this.getAttributeValueElement(element);
        if (psiElement == null) {
            return;
        }
        PsiElement attributeValue = psiElement;
        this.updateAttributeValue(attributeValue);
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return super.isAvailable(project, editor, element) && this.isAttributeValuePlace(element);
    }

    protected abstract boolean isAcceptableAttributeValueElement(@Nullable PsiElement var1);

    @NotNull
    protected abstract String getNewAttributeValue(@NotNull PsiElement var1);

    private final boolean isAttributeValuePlace(PsiElement element) {
        return this.isAcceptableAttributeValueElement(this.getAttributeValueElement(element));
    }

    private final PsiElement getAttributeValueElement(PsiElement element) {
        if (!(element.getContainingFile() instanceof JSFile) || !DialectDetector.isJSX((PsiElement)element)) {
            return null;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)element, JSXmlAttributeValueImpl.class);
    }

    private final void updateAttributeValue(PsiElement oldAttribute) {
        ASTNode oldAttributeNode;
        String value = this.getNewAttributeValue(oldAttribute);
        ASTNode aSTNode = JSChangeUtil.createStatementFromTextWithContext((String)("<div attr=" + value + " />"), (PsiElement)oldAttribute);
        if (aSTNode == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"JSChangeUtil.createState\u2026, oldAttribute) ?: return");
        ASTNode statementNode = aSTNode;
        ASTNode aSTNode2 = this.findAttributeValueInStatement(statementNode);
        if (aSTNode2 == null) {
            return;
        }
        ASTNode newAttributeValue = aSTNode2;
        ASTNode aSTNode3 = oldAttributeNode = oldAttribute.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode3, (String)"oldAttributeNode");
        aSTNode3.getTreeParent().replaceChild(oldAttributeNode, newAttributeValue);
    }

    private final ASTNode findAttributeValueInStatement(ASTNode statementNode) {
        ASTNode firstChildNode = statementNode.getFirstChildNode();
        ASTNode aSTNode = firstChildNode.findChildByType((IElementType)JSStubElementTypes.XML_ATTRIBUTE);
        if (aSTNode == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"firstChildNode.findChild\u2026ATTRIBUTE) ?: return null");
        ASTNode attribute = aSTNode;
        return attribute.findChildByType(XmlElementType.XML_ATTRIBUTE_VALUE);
    }
}

