/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.makefile;

import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.util.Consumer;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.lang.makefile.MakefileFileChooserDescriptor;
import com.jetbrains.lang.makefile.MakefileLangBundle;
import com.jetbrains.lang.makefile.MakefileRunConfiguration;
import com.jetbrains.lang.makefile.MakefileRunConfigurationEditor;
import com.jetbrains.lang.makefile.UtilsKt;
import com.jetbrains.lang.makefile.psi.MakefileTarget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0002H\u0014J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002J\b\u0010\u001e\u001a\u00020\rH\u0014J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0002H\u0014J\u000e\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/jetbrains/lang/makefile/MakefileRunConfigurationEditor;", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/jetbrains/lang/makefile/MakefileRunConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "argumentsField", "Lcom/intellij/ui/components/fields/ExpandableTextField;", "environmentVarsComponent", "Lcom/intellij/execution/configuration/EnvironmentVariablesComponent;", "filenameField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "panel", "Ljavax/swing/JPanel;", "getPanel", "()Ljavax/swing/JPanel;", "panel$delegate", "Lkotlin/Lazy;", "targetCompletionProvider", "Lcom/intellij/ui/TextFieldWithAutoCompletion$StringsCompletionProvider;", "targetField", "Lcom/intellij/ui/TextFieldWithAutoCompletion;", "", "workingDirectoryField", "applyEditorTo", "", "configuration", "createComponentWithMacroBrowse", "Ljavax/swing/JComponent;", "textAccessor", "createEditor", "resetEditorFrom", "updateTargetCompletion", "filename", "intellij.makefile"})
public final class MakefileRunConfigurationEditor
extends SettingsEditor<MakefileRunConfiguration> {
    private final TextFieldWithBrowseButton filenameField;
    private final TextFieldWithAutoCompletion.StringsCompletionProvider targetCompletionProvider;
    private final TextFieldWithAutoCompletion<String> targetField;
    private final ExpandableTextField argumentsField;
    private final TextFieldWithBrowseButton workingDirectoryField;
    private final EnvironmentVariablesComponent environmentVarsComponent;
    private final Lazy panel$delegate;
    private final Project project;

    private final JPanel getPanel() {
        Lazy lazy = this.panel$delegate;
        MakefileRunConfigurationEditor makefileRunConfigurationEditor = this;
        Object var3_3 = null;
        boolean bl = false;
        return (JPanel)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void updateTargetCompletion(@NotNull String filename) {
        PsiFile psiFile;
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(filename);
        if (file != null && (psiFile = PsiManager.getInstance((Project)this.project).findFile(file)) != null) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable<MakefileTarget> iterable = UtilsKt.findTargets(psiFile);
            TextFieldWithAutoCompletion.StringsCompletionProvider stringsCompletionProvider = this.targetCompletionProvider;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                MakefileTarget makefileTarget = (MakefileTarget)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                void v0 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"it");
                String string = v0.getName();
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            stringsCompletionProvider.setItems((Collection)collection);
            return;
        }
        this.targetCompletionProvider.setItems((Collection)CollectionsKt.emptyList());
    }

    @NotNull
    protected JPanel createEditor() {
        return this.getPanel();
    }

    protected void applyEditorTo(@NotNull MakefileRunConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        String string = this.filenameField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"filenameField.text");
        configuration.setFilename(string);
        String string2 = this.targetField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"targetField.text");
        configuration.setTarget(string2);
        String string3 = this.workingDirectoryField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"workingDirectoryField.text");
        configuration.setWorkingDirectory(string3);
        EnvironmentVariablesData environmentVariablesData = this.environmentVarsComponent.getEnvData();
        Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData, (String)"environmentVarsComponent.envData");
        configuration.setEnvironmentVariables(environmentVariablesData);
        String string4 = this.argumentsField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"argumentsField.text");
        configuration.setArguments(string4);
    }

    protected void resetEditorFrom(@NotNull MakefileRunConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        this.filenameField.setText(configuration.getFilename());
        this.targetField.setText(configuration.getTarget());
        this.workingDirectoryField.setText(configuration.getWorkingDirectory());
        this.environmentVarsComponent.setEnvData(configuration.getEnvironmentVariables());
        this.argumentsField.setText(configuration.getArguments());
        this.updateTargetCompletion(configuration.getFilename());
    }

    private final JComponent createComponentWithMacroBrowse(TextFieldWithBrowseButton textAccessor) {
        FixedSizeButton button = new FixedSizeButton((JComponent)textAccessor);
        button.setIcon(AllIcons.Actions.ListFiles);
        button.addActionListener(new ActionListener(textAccessor, button){
            final /* synthetic */ TextFieldWithBrowseButton $textAccessor;
            final /* synthetic */ FixedSizeButton $button;

            public final void actionPerformed(ActionEvent it) {
                JBPopupFactory jBPopupFactory = JBPopupFactory.getInstance();
                PathMacros pathMacros = PathMacros.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)pathMacros, (String)"PathMacros.getInstance()");
                Set set = pathMacros.getUserMacroNames();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"PathMacros.getInstance().userMacroNames");
                jBPopupFactory.createPopupChooserBuilder(CollectionsKt.toList((Iterable)set)).setItemChosenCallback(new Consumer(this){
                    final /* synthetic */ createComponentWithMacroBrowse.1 this$0;

                    public final void consume(@NotNull String item) {
                        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                        this.this$0.$textAccessor.setText('$' + item + '$');
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }).setMovable(false).setResizable(false).createPopup().showUnderneathOf((Component)this.$button);
            }
            {
                this.$textAccessor = textFieldWithBrowseButton;
                this.$button = fixedSizeButton;
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        boolean bl = false;
        boolean bl2 = false;
        JPanel $this$apply = jPanel;
        boolean bl3 = false;
        $this$apply.add((Component)textAccessor, "Center");
        $this$apply.add((Component)button, "East");
        return jPanel;
    }

    public MakefileRunConfigurationEditor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.filenameField = new TextFieldWithBrowseButton();
        this.targetCompletionProvider = new TextFieldWithAutoCompletion.StringsCompletionProvider((Collection)CollectionsKt.emptyList(), UtilsKt.getMakefileTargetIcon());
        this.targetField = new TextFieldWithAutoCompletion(this.project, (TextFieldWithAutoCompletionListProvider)this.targetCompletionProvider, true, "");
        this.argumentsField = new ExpandableTextField();
        this.workingDirectoryField = new TextFieldWithBrowseButton();
        this.environmentVarsComponent = new EnvironmentVariablesComponent();
        this.panel$delegate = LazyKt.lazy((Function0)((Function0)new Function0<JPanel>(this){
            final /* synthetic */ MakefileRunConfigurationEditor this$0;

            public final JPanel invoke() {
                FormBuilder formBuilder = FormBuilder.createFormBuilder().setAlignLabelOnRight(false).setHorizontalGap(10).setVerticalGap(4).addLabeledComponent(MakefileLangBundle.message("run.configuration.editor.filename.label", new Object[0]), (JComponent)MakefileRunConfigurationEditor.access$getFilenameField$p(this.this$0)).addLabeledComponent(MakefileLangBundle.message("run.configuration.editor.target.label", new Object[0]), (JComponent)MakefileRunConfigurationEditor.access$getTargetField$p(this.this$0)).addComponent((JComponent)LabeledComponent.create((JComponent)((JComponent)MakefileRunConfigurationEditor.access$getArgumentsField$p(this.this$0)), (String)MakefileLangBundle.message("run.configuration.editor.arguments.label", new Object[0]))).addLabeledComponent(MakefileLangBundle.message("run.configuration.editor.working.directory.label", new Object[0]), MakefileRunConfigurationEditor.access$createComponentWithMacroBrowse(this.this$0, MakefileRunConfigurationEditor.access$getWorkingDirectoryField$p(this.this$0))).addComponent((JComponent)MakefileRunConfigurationEditor.access$getEnvironmentVarsComponent$p(this.this$0));
                Intrinsics.checkNotNullExpressionValue((Object)formBuilder, (String)"FormBuilder.createFormBu\u2026environmentVarsComponent)");
                return formBuilder.getPanel();
            }
            {
                this.this$0 = makefileRunConfigurationEditor;
                super(0);
            }
        }));
        this.filenameField.addBrowseFolderListener(MakefileLangBundle.message("file.chooser.title", new Object[0]), MakefileLangBundle.message("file.chooser.description", new Object[0]), this.project, (FileChooserDescriptor)new MakefileFileChooserDescriptor());
        JTextField jTextField = this.filenameField.getTextField();
        Intrinsics.checkNotNullExpressionValue((Object)jTextField, (String)"filenameField.textField");
        jTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                String string = filenameField.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"filenameField.text");
                this.updateTargetCompletion(string);
            }
        });
        this.workingDirectoryField.addBrowseFolderListener(MakefileLangBundle.message("working.directory.file.chooser", new Object[0]), MakefileLangBundle.message("working.directory.file.chooser.description", new Object[0]), this.project, FileChooserDescriptorFactory.createSingleFolderDescriptor());
    }

    public static final /* synthetic */ TextFieldWithAutoCompletion access$getTargetField$p(MakefileRunConfigurationEditor $this) {
        return $this.targetField;
    }

    public static final /* synthetic */ ExpandableTextField access$getArgumentsField$p(MakefileRunConfigurationEditor $this) {
        return $this.argumentsField;
    }

    public static final /* synthetic */ JComponent access$createComponentWithMacroBrowse(MakefileRunConfigurationEditor $this, TextFieldWithBrowseButton textAccessor) {
        return $this.createComponentWithMacroBrowse(textAccessor);
    }

    public static final /* synthetic */ TextFieldWithBrowseButton access$getWorkingDirectoryField$p(MakefileRunConfigurationEditor $this) {
        return $this.workingDirectoryField;
    }

    public static final /* synthetic */ EnvironmentVariablesComponent access$getEnvironmentVarsComponent$p(MakefileRunConfigurationEditor $this) {
        return $this.environmentVarsComponent;
    }
}

