/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.MsBaseJdbcHelper;
import java.sql.Connection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MsJdbcHelper
extends MsBaseJdbcHelper {
    public MsJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super("MSSQL", version, connection);
    }

    public MsJdbcHelper() {
        this(null, null);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return MsJdbcHelper.extractVersion(version);
    }

    @NotNull
    protected static MsJdbcHelper create(@Nullable Connection delegate, @Nullable String productVer) {
        JdbcNativeUtil.logInfo("getDatabaseProductVersion: " + productVer);
        return new MsJdbcHelper(MsJdbcHelper.extractVersion(productVer), delegate);
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }
}

