/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.invalid;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.descriptor.CssContextType;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.inspections.CssBaseInspection;
import org.jetbrains.annotations.NotNull;

public class CssInvalidAtRuleInspection
extends CssBaseInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CssInvalidAtRuleInspection.$$$reportNull$$$0(0);
        }
        return new CssElementVisitor(){

            public void visitAtRule(CssAtRule atRule) {
                if (atRule.getType() == CssContextType.UNKNOWN) {
                    CssElementDescriptorProvider provider = CssDescriptorsUtil.findDescriptorProvider((PsiElement)atRule);
                    if (provider != null && provider.skipUnknownAtRuleCheck(atRule)) {
                        return;
                    }
                    PsiElement firstChild = atRule.getFirstChild();
                    if (firstChild != null) {
                        holder.registerProblem(firstChild, CssBundle.message((String)"css.inspections.unknown.at.rule", (Object[])new Object[0]), new LocalQuickFix[0]);
                    }
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/inspections/invalid/CssInvalidAtRuleInspection", "buildVisitor"));
    }
}

