/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.amazonaws.services.securitytoken;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.gradle.internal.impldep.com.amazonaws.ClientConfiguration;
import org.gradle.internal.impldep.com.amazonaws.annotation.ThreadSafe;
import org.gradle.internal.impldep.com.amazonaws.auth.AWSCredentials;
import org.gradle.internal.impldep.com.amazonaws.auth.AWSCredentialsProvider;
import org.gradle.internal.impldep.com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import org.gradle.internal.impldep.com.amazonaws.client.AwsAsyncClientParams;
import org.gradle.internal.impldep.com.amazonaws.handlers.AsyncHandler;
import org.gradle.internal.impldep.com.amazonaws.services.securitytoken.AWSSecurityTokenServiceAsync;
import org.gradle.internal.impldep.com.amazonaws.services.securitytoken.AWSSecurityTokenServiceAsyncClientBuilder;
import org.gradle.internal.impldep.com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient;
import org.gradle.internal.impldep.com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import org.gradle.internal.impldep.com.amazonaws.services.securitytoken.model.AssumeRoleResult;
import org.gradle.internal.impldep.com.amazonaws.services.securitytoken.model.AssumeRoleWithSAMLRequest;
import org.gradle.internal.impldep.com.amazonaws.services.securitytoken.model.AssumeRoleWithSAMLResult;
import org.gradle.internal.impldep.com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityRequest;
import org.gradle.internal.impldep.com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityResult;
import org.gradle.internal.impldep.com.amazonaws.services.securitytoken.model.DecodeAuthorizationMessageRequest;
import org.gradle.internal.impldep.com.amazonaws.services.securitytoken.model.DecodeAuthorizationMessageResult;
import org.gradle.internal.impldep.com.amazonaws.services.securitytoken.model.GetAccessKeyInfoRequest;
import org.gradle.internal.impldep.com.amazonaws.services.securitytoken.model.GetAccessKeyInfoResult;
import org.gradle.internal.impldep.com.amazonaws.services.securitytoken.model.GetCallerIdentityRequest;
import org.gradle.internal.impldep.com.amazonaws.services.securitytoken.model.GetCallerIdentityResult;
import org.gradle.internal.impldep.com.amazonaws.services.securitytoken.model.GetFederationTokenRequest;
import org.gradle.internal.impldep.com.amazonaws.services.securitytoken.model.GetFederationTokenResult;
import org.gradle.internal.impldep.com.amazonaws.services.securitytoken.model.GetSessionTokenRequest;
import org.gradle.internal.impldep.com.amazonaws.services.securitytoken.model.GetSessionTokenResult;

@ThreadSafe
public class AWSSecurityTokenServiceAsyncClient
extends AWSSecurityTokenServiceClient
implements AWSSecurityTokenServiceAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AWSSecurityTokenServiceAsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AWSSecurityTokenServiceAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSSecurityTokenServiceAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSSecurityTokenServiceAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSSecurityTokenServiceAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AWSSecurityTokenServiceAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSSecurityTokenServiceAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSSecurityTokenServiceAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSSecurityTokenServiceAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AWSSecurityTokenServiceAsyncClientBuilder asyncBuilder() {
        return AWSSecurityTokenServiceAsyncClientBuilder.standard();
    }

    AWSSecurityTokenServiceAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSSecurityTokenServiceAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super(asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AssumeRoleResult> assumeRoleAsync(AssumeRoleRequest request) {
        return this.assumeRoleAsync(request, null);
    }

    @Override
    public Future<AssumeRoleResult> assumeRoleAsync(AssumeRoleRequest request, final AsyncHandler<AssumeRoleRequest, AssumeRoleResult> asyncHandler) {
        final AssumeRoleRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssumeRoleResult>(){

            @Override
            public AssumeRoleResult call() throws Exception {
                AssumeRoleResult result = null;
                try {
                    result = AWSSecurityTokenServiceAsyncClient.this.executeAssumeRole(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AssumeRoleWithSAMLResult> assumeRoleWithSAMLAsync(AssumeRoleWithSAMLRequest request) {
        return this.assumeRoleWithSAMLAsync(request, null);
    }

    @Override
    public Future<AssumeRoleWithSAMLResult> assumeRoleWithSAMLAsync(AssumeRoleWithSAMLRequest request, final AsyncHandler<AssumeRoleWithSAMLRequest, AssumeRoleWithSAMLResult> asyncHandler) {
        final AssumeRoleWithSAMLRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssumeRoleWithSAMLResult>(){

            @Override
            public AssumeRoleWithSAMLResult call() throws Exception {
                AssumeRoleWithSAMLResult result = null;
                try {
                    result = AWSSecurityTokenServiceAsyncClient.this.executeAssumeRoleWithSAML(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AssumeRoleWithWebIdentityResult> assumeRoleWithWebIdentityAsync(AssumeRoleWithWebIdentityRequest request) {
        return this.assumeRoleWithWebIdentityAsync(request, null);
    }

    @Override
    public Future<AssumeRoleWithWebIdentityResult> assumeRoleWithWebIdentityAsync(AssumeRoleWithWebIdentityRequest request, final AsyncHandler<AssumeRoleWithWebIdentityRequest, AssumeRoleWithWebIdentityResult> asyncHandler) {
        final AssumeRoleWithWebIdentityRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssumeRoleWithWebIdentityResult>(){

            @Override
            public AssumeRoleWithWebIdentityResult call() throws Exception {
                AssumeRoleWithWebIdentityResult result = null;
                try {
                    result = AWSSecurityTokenServiceAsyncClient.this.executeAssumeRoleWithWebIdentity(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DecodeAuthorizationMessageResult> decodeAuthorizationMessageAsync(DecodeAuthorizationMessageRequest request) {
        return this.decodeAuthorizationMessageAsync(request, null);
    }

    @Override
    public Future<DecodeAuthorizationMessageResult> decodeAuthorizationMessageAsync(DecodeAuthorizationMessageRequest request, final AsyncHandler<DecodeAuthorizationMessageRequest, DecodeAuthorizationMessageResult> asyncHandler) {
        final DecodeAuthorizationMessageRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DecodeAuthorizationMessageResult>(){

            @Override
            public DecodeAuthorizationMessageResult call() throws Exception {
                DecodeAuthorizationMessageResult result = null;
                try {
                    result = AWSSecurityTokenServiceAsyncClient.this.executeDecodeAuthorizationMessage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAccessKeyInfoResult> getAccessKeyInfoAsync(GetAccessKeyInfoRequest request) {
        return this.getAccessKeyInfoAsync(request, null);
    }

    @Override
    public Future<GetAccessKeyInfoResult> getAccessKeyInfoAsync(GetAccessKeyInfoRequest request, final AsyncHandler<GetAccessKeyInfoRequest, GetAccessKeyInfoResult> asyncHandler) {
        final GetAccessKeyInfoRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAccessKeyInfoResult>(){

            @Override
            public GetAccessKeyInfoResult call() throws Exception {
                GetAccessKeyInfoResult result = null;
                try {
                    result = AWSSecurityTokenServiceAsyncClient.this.executeGetAccessKeyInfo(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCallerIdentityResult> getCallerIdentityAsync(GetCallerIdentityRequest request) {
        return this.getCallerIdentityAsync(request, null);
    }

    @Override
    public Future<GetCallerIdentityResult> getCallerIdentityAsync(GetCallerIdentityRequest request, final AsyncHandler<GetCallerIdentityRequest, GetCallerIdentityResult> asyncHandler) {
        final GetCallerIdentityRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetCallerIdentityResult>(){

            @Override
            public GetCallerIdentityResult call() throws Exception {
                GetCallerIdentityResult result = null;
                try {
                    result = AWSSecurityTokenServiceAsyncClient.this.executeGetCallerIdentity(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetFederationTokenResult> getFederationTokenAsync(GetFederationTokenRequest request) {
        return this.getFederationTokenAsync(request, null);
    }

    @Override
    public Future<GetFederationTokenResult> getFederationTokenAsync(GetFederationTokenRequest request, final AsyncHandler<GetFederationTokenRequest, GetFederationTokenResult> asyncHandler) {
        final GetFederationTokenRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetFederationTokenResult>(){

            @Override
            public GetFederationTokenResult call() throws Exception {
                GetFederationTokenResult result = null;
                try {
                    result = AWSSecurityTokenServiceAsyncClient.this.executeGetFederationToken(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSessionTokenResult> getSessionTokenAsync(GetSessionTokenRequest request) {
        return this.getSessionTokenAsync(request, null);
    }

    @Override
    public Future<GetSessionTokenResult> getSessionTokenAsync(GetSessionTokenRequest request, final AsyncHandler<GetSessionTokenRequest, GetSessionTokenResult> asyncHandler) {
        final GetSessionTokenRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSessionTokenResult>(){

            @Override
            public GetSessionTokenResult call() throws Exception {
                GetSessionTokenResult result = null;
                try {
                    result = AWSSecurityTokenServiceAsyncClient.this.executeGetSessionToken(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSessionTokenResult> getSessionTokenAsync() {
        return this.getSessionTokenAsync(new GetSessionTokenRequest());
    }

    @Override
    public Future<GetSessionTokenResult> getSessionTokenAsync(AsyncHandler<GetSessionTokenRequest, GetSessionTokenResult> asyncHandler) {
        return this.getSessionTokenAsync(new GetSessionTokenRequest(), asyncHandler);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

