/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.bouncycastle.gpg.keybox;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.internal.impldep.org.bouncycastle.gpg.keybox.Blob;
import org.gradle.internal.impldep.org.bouncycastle.gpg.keybox.BlobType;
import org.gradle.internal.impldep.org.bouncycastle.gpg.keybox.BlobVerifier;
import org.gradle.internal.impldep.org.bouncycastle.gpg.keybox.FirstBlob;
import org.gradle.internal.impldep.org.bouncycastle.gpg.keybox.KeyBlob;
import org.gradle.internal.impldep.org.bouncycastle.gpg.keybox.KeyBoxByteBuffer;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyBox {
    private final FirstBlob firstBlob;
    private final List<KeyBlob> keyBlobs;

    public KeyBox(InputStream inputStream, KeyFingerPrintCalculator keyFingerPrintCalculator, BlobVerifier blobVerifier) throws IOException {
        this(KeyBoxByteBuffer.wrap(inputStream), keyFingerPrintCalculator, blobVerifier);
    }

    public KeyBox(byte[] byArray, KeyFingerPrintCalculator keyFingerPrintCalculator, BlobVerifier blobVerifier) throws IOException {
        this(KeyBoxByteBuffer.wrap(byArray), keyFingerPrintCalculator, blobVerifier);
    }

    private KeyBox(KeyBoxByteBuffer keyBoxByteBuffer, KeyFingerPrintCalculator keyFingerPrintCalculator, BlobVerifier blobVerifier) throws IOException {
        Blob blob = Blob.getInstance(keyBoxByteBuffer, keyFingerPrintCalculator, blobVerifier);
        if (blob == null) {
            throw new IOException("No first blob, is the source zero length?");
        }
        if (!(blob instanceof FirstBlob)) {
            throw new IOException("First blob is not KeyBox 'First Blob'.");
        }
        FirstBlob firstBlob = (FirstBlob)blob;
        ArrayList<KeyBlob> arrayList = new ArrayList<KeyBlob>();
        Blob blob2 = Blob.getInstance(keyBoxByteBuffer, keyFingerPrintCalculator, blobVerifier);
        while (blob2 != null) {
            if (blob2.getType() == BlobType.FIRST_BLOB) {
                throw new IOException("Unexpected second 'FirstBlob', there should only be one FirstBlob at the start of the file.");
            }
            arrayList.add((KeyBlob)blob2);
            blob2 = Blob.getInstance(keyBoxByteBuffer, keyFingerPrintCalculator, blobVerifier);
        }
        this.firstBlob = firstBlob;
        this.keyBlobs = Collections.unmodifiableList(arrayList);
    }

    public FirstBlob getFirstBlob() {
        return this.firstBlob;
    }

    public List<KeyBlob> getKeyBlobs() {
        return this.keyBlobs;
    }
}

