/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.google.common.base.Predicate;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Progressive;
import com.intellij.openapi.progress.StandardProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteFile;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.RemoteFileObject;
import com.intellij.ssh.SshTransportException;
import com.intellij.ssh.channels.SftpChannel;
import com.intellij.util.io.Compressor;
import com.jetbrains.plugins.remotesdk.RemoteUpload;
import com.jetbrains.plugins.remotesdk.RemoteUploadKt;
import com.jetbrains.plugins.remotesdk.transport.SshUtil;
import com.jetbrains.plugins.webDeployment.config.ExcludedPath;
import java.awt.Component;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.BiPredicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e\u0012\u0006\u0010\u000f\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0010J\u001e\u0010(\u001a\u00020\u000b2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\t0*2\u0006\u0010+\u001a\u00020\tH\u0002J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020\t0*H\u0014J&\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\f\u00101\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u00102\u001a\u00020\tH\u0002J\u001c\u00103\u001a\b\u0012\u0004\u0012\u000205042\f\u00106\u001a\b\u0012\u0004\u0012\u00020\t0\u000eH\u0014J\b\u00107\u001a\u00020\u000bH\u0014J.\u00108\u001a\u00020\u000b2\u0006\u00109\u001a\u00020:2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u00102\u001a\u00020\t2\u0006\u0010<\u001a\u00020\u000bH\u0002J\u0010\u0010=\u001a\u00020.2\u0006\u0010>\u001a\u00020?H\u0014J\n\u0010@\u001a\u0006\u0012\u0002\b\u00030AJ&\u0010B\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u00109\u001a\u00020:2\u0006\u0010C\u001a\u00020\tH\u0002J0\u0010D\u001a\u00020.2\u0006\u00109\u001a\u00020:2\u0016\u0010E\u001a\u0012\u0012\u0004\u0012\u00020G0Fj\b\u0012\u0004\u0012\u00020G`H2\u0006\u00102\u001a\u00020\tH\u0002J&\u0010I\u001a\u00020.2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u00109\u001a\u00020:2\u0006\u0010C\u001a\u00020\tH\u0002R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR(\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u0006J"}, d2={"Lcom/jetbrains/plugins/remotesdk/RemoteUpload;", "", "credentials", "Lcom/intellij/remote/RemoteCredentials;", "project", "Lcom/intellij/openapi/project/Project;", "component", "Ljava/awt/Component;", "title", "", "cancellable", "", "isModal", "pathsToUpload", "", "remotePath", "(Lcom/intellij/remote/RemoteCredentials;Lcom/intellij/openapi/project/Project;Ljava/awt/Component;Ljava/lang/String;ZZLjava/util/Collection;Ljava/lang/String;)V", "getComponent", "()Ljava/awt/Component;", "getCredentials", "()Lcom/intellij/remote/RemoteCredentials;", "process", "Lcom/intellij/openapi/progress/Task;", "progressIndicator", "Lcom/intellij/openapi/progress/StandardProgressIndicator;", "getProject", "()Lcom/intellij/openapi/project/Project;", "relativePathsMap", "", "getRelativePathsMap", "()Ljava/util/Map;", "setRelativePathsMap", "(Ljava/util/Map;)V", "getTitle", "()Ljava/lang/String;", "uploadOnSnapshot", "getUploadOnSnapshot", "()Z", "setUploadOnSnapshot", "(Z)V", "applyFilter", "filter", "Lcom/google/common/base/Predicate;", "entryName", "createFileFilter", "doUploadFilesToRemote", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "localHelpersRoots", "remoteHelpersRoot", "getExcludedHelpersPaths", "", "Lcom/jetbrains/plugins/webDeployment/config/ExcludedPath;", "helpersPaths", "helpersArchiveCopyEnabled", "helpersUpdateNeeded", "connection", "Lcom/intellij/ssh/channels/SftpChannel;", "helpersRoots", "updateOnSnapshot", "onUploadError", "e", "Lcom/intellij/ssh/SshTransportException;", "upload", "Ljava/util/concurrent/Future;", "uploadCompressedTar", "remoteDirectory", "uploadFiles", "files", "Ljava/util/ArrayList;", "Ljava/io/File;", "Lkotlin/collections/ArrayList;", "uploadPerFile", "intellij.remoteRun"})
public class RemoteUpload {
    @Nullable
    private Map<String, String> relativePathsMap;
    private boolean uploadOnSnapshot;
    private final Task process;
    private final StandardProgressIndicator progressIndicator;
    @NotNull
    private final RemoteCredentials credentials;
    @Nullable
    private final Project project;
    @Nullable
    private final Component component;
    @NotNull
    private final String title;
    private final Collection<String> pathsToUpload;
    private final String remotePath;

    @Nullable
    public final Map<String, String> getRelativePathsMap() {
        return this.relativePathsMap;
    }

    public final void setRelativePathsMap(@Nullable Map<String, String> map) {
        this.relativePathsMap = map;
    }

    public final boolean getUploadOnSnapshot() {
        return this.uploadOnSnapshot;
    }

    public final void setUploadOnSnapshot(boolean bl) {
        this.uploadOnSnapshot = bl;
    }

    @NotNull
    public final Future<?> upload() {
        if (this.process instanceof Task.Backgroundable) {
            ProgressManager progressManager = ProgressManager.getInstance();
            if (progressManager == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.progress.impl.ProgressManagerImpl");
            }
            Future future = ((ProgressManagerImpl)progressManager).runProcessWithProgressAsynchronously((Task.Backgroundable)this.process, (ProgressIndicator)this.progressIndicator, null);
            Intrinsics.checkNotNullExpressionValue((Object)future, (String)"(ProgressManager.getInst\u2026 progressIndicator, null)");
            return future;
        }
        CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(new Runnable(this){
            final /* synthetic */ RemoteUpload this$0;

            public final void run() {
                RemoteUpload.access$getProcess$p(this.this$0).run((ProgressIndicator)new EmptyProgressIndicator());
            }
            {
                this.this$0 = remoteUpload;
            }
        });
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.runAsy\u2026gressIndicator())\n      }");
        return completableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean helpersUpdateNeeded(SftpChannel connection, Collection<String> helpersRoots, String remoteHelpersRoot, boolean updateOnSnapshot) {
        boolean bl;
        PerformanceWatcher.Snapshot snapshot;
        block18: {
            PerformanceWatcher.Snapshot snapshot2 = PerformanceWatcher.takeSnapshot();
            Intrinsics.checkNotNullExpressionValue((Object)snapshot2, (String)"PerformanceWatcher.takeSnapshot()");
            snapshot = snapshot2;
            Iterable $this$any$iv = helpersRoots;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String path = (String)element$iv;
                    boolean bl2 = false;
                    try {
                        RemoteFileObject versionFile;
                        String relativePath;
                        RemoteFileObject helpersDir = connection.file(remoteHelpersRoot);
                        if (!helpersDir.exists()) {
                            return true;
                        }
                        Map<String, String> map = this.relativePathsMap;
                        String string = relativePath = map != null ? map.get(path) : null;
                        if (relativePath != null) {
                            RemoteFileObject singleFile = helpersDir.child(relativePath);
                            if (!singleFile.exists()) {
                                return true;
                            }
                            if (!singleFile.isDir()) {
                                return false;
                            }
                        }
                        if ((versionFile = helpersDir.child("build.txt")).exists()) {
                            Closeable closeable = versionFile.inputStream();
                            boolean bl3 = false;
                            boolean bl4 = false;
                            Throwable throwable = null;
                            try {
                                InputStream it = (InputStream)closeable;
                                boolean bl5 = false;
                                char[] cArray = FileUtil.loadText((Reader)new InputStreamReader(it), (int)((int)versionFile.size()));
                                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"FileUtil.loadText(InputS\u2026rsionFile.size().toInt())");
                                char[] cArray2 = cArray;
                                boolean bl6 = false;
                                String content = new String(cArray2);
                                String localContent = RemoteUploadKt.access$getLocalVersion();
                                RemoteUploadKt.access$getLOG$p().info("Remote helpers version is " + content + ", local helpers version is " + localContent);
                                CharSequence charSequence = content;
                                boolean bl7 = false;
                                if (charSequence.length() > 0) {
                                    boolean bl8 = Intrinsics.areEqual((Object)localContent, (Object)content) ^ true || StringsKt.endsWith$default((String)localContent, (String)".SNAPSHOT", (boolean)false, (int)2, null) && updateOnSnapshot;
                                    return bl8;
                                }
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                            }
                        }
                        return true;
                    }
                    catch (Exception e) {
                        RemoteUploadKt.access$getLOG$p().info("Failed to retrieve helpers version file", (Throwable)e);
                        if (!true) continue;
                        bl = true;
                        break block18;
                    }
                }
                bl = false;
            }
        }
        boolean result = bl;
        snapshot.logResponsivenessSinceCreation("Helpers version check");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doUploadFilesToRemote(ProgressIndicator indicator, Collection<String> localHelpersRoots, String remoteHelpersRoot) {
        block9: {
            RemoteUploadKt.access$getLOG$p().info("Uploading helpers to " + this.remotePath);
            try {
                indicator.setFraction(0.0);
                SftpChannel connection = ConnectionBuilder.openSftpChannel$default((ConnectionBuilder)RemoteCredentialsUtil.connectionBuilder$default((RemoteCredentials)this.credentials, null, null, (boolean)false, (int)7, null), (int)0, (int)1, null);
                try {
                    if (!this.helpersUpdateNeeded(connection, localHelpersRoots, remoteHelpersRoot, this.uploadOnSnapshot)) break block9;
                    PerformanceWatcher.Snapshot snapshot = PerformanceWatcher.takeSnapshot();
                    Intrinsics.checkNotNullExpressionValue((Object)snapshot, (String)"PerformanceWatcher.takeSnapshot()");
                    PerformanceWatcher.Snapshot snapshot2 = snapshot;
                    try {
                        if (!this.helpersArchiveCopyEnabled() || !this.uploadCompressedTar(localHelpersRoots, connection, remoteHelpersRoot)) {
                            this.uploadPerFile(localHelpersRoots, connection, remoteHelpersRoot);
                        }
                        RemoteUploadKt.access$getLOG$p().info("Helpers upload successfully completed");
                    }
                    finally {
                        snapshot2.logResponsivenessSinceCreation("Helpers uploaded");
                    }
                }
                finally {
                    connection.disconnect();
                }
            }
            catch (SshTransportException e) {
                this.onUploadError(e);
            }
        }
    }

    private final void uploadPerFile(Collection<String> pathsToUpload, SftpChannel connection, String remoteDirectory) {
        for (String root : pathsToUpload) {
            File file = new File(root);
            Map<String, String> map = this.relativePathsMap;
            if (map == null || (map = map.get(root)) == null) {
                map = "";
            }
            connection.uploadFileOrDir(file, remoteDirectory, (String)((Object)map));
        }
    }

    @NotNull
    protected Predicate<String> createFileFilter() {
        return createFileFilter.1.INSTANCE;
    }

    protected void onUploadError(@NotNull SshTransportException e) {
        Intrinsics.checkNotNullParameter((Object)((Object)e), (String)"e");
        RemoteUploadKt.access$getLOG$p().warn((Throwable)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean uploadCompressedTar(Collection<String> pathsToUpload, SftpChannel connection, String remoteDirectory) {
        try {
            File file = FileUtil.createTempFile((String)"helpers.", (String)".tar.gz");
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"FileUtil.createTempFile(\"helpers.\", \".tar.gz\")");
            File tarFile = file;
            try {
                Predicate<String> f = this.createFileFilter();
                Closeable closeable = (Closeable)new Compressor.Tar(tarFile, Compressor.Tar.Compression.GZIP);
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    Compressor.Tar it = (Compressor.Tar)closeable;
                    boolean bl3 = false;
                    String string = RemoteUploadKt.access$getLocalVersion();
                    Charset charset = Charsets.UTF_8;
                    boolean bl4 = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    byte[] byArray = string2.getBytes(charset);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                    it.addFile("build.txt", byArray);
                    it.filter(new BiPredicate(this, f, pathsToUpload){
                        final /* synthetic */ RemoteUpload this$0;
                        final /* synthetic */ Predicate $f$inlined;
                        final /* synthetic */ Collection $pathsToUpload$inlined;
                        {
                            this.this$0 = remoteUpload;
                            this.$f$inlined = predicate;
                            this.$pathsToUpload$inlined = collection;
                        }

                        public final boolean test(String entryName, File $noName_1) {
                            String string = entryName;
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entryName");
                            return RemoteUpload.access$applyFilter(this.this$0, this.$f$inlined, string);
                        }
                    });
                    for (String root : pathsToUpload) {
                        it.addDirectory(new File(root));
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                this.uploadFiles(connection, CollectionsKt.arrayListOf((Object[])new File[]{tarFile}), remoteDirectory);
                SshUtil.untar(this.credentials, new RemoteFile(remoteDirectory, tarFile.getName()).getPath(), remoteDirectory);
            }
            finally {
                tarFile.delete();
            }
            return true;
        }
        catch (Exception e) {
            RemoteUploadKt.access$getLOG$p().error("Couldn't upload helpers", (Throwable)e);
            return false;
        }
    }

    private final boolean applyFilter(Predicate<String> filter, String entryName) {
        String string;
        int p = -1;
        do {
            if ((p = StringsKt.indexOf$default((CharSequence)entryName, (char)'/', (int)(p + 1), (boolean)false, (int)4, null)) < 0) {
                return filter.apply((Object)entryName);
            }
            String string2 = entryName;
            int n = 0;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            string = string3.substring(n, p);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } while (filter.apply((Object)string));
        return false;
    }

    private final void uploadFiles(SftpChannel connection, ArrayList<File> files, String remoteHelpersRoot) {
        Iterator<File> iterator = files.iterator();
        while (iterator.hasNext()) {
            File file;
            File file2 = file = iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
            connection.uploadFileOrDir(file2, remoteHelpersRoot, string);
        }
    }

    protected boolean helpersArchiveCopyEnabled() {
        return false;
    }

    @NotNull
    protected List<ExcludedPath> getExcludedHelpersPaths(@NotNull Collection<String> helpersPaths) {
        Intrinsics.checkNotNullParameter(helpersPaths, (String)"helpersPaths");
        return CollectionsKt.emptyList();
    }

    @NotNull
    public final RemoteCredentials getCredentials() {
        return this.credentials;
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final Component getComponent() {
        return this.component;
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    public RemoteUpload(@NotNull RemoteCredentials credentials, @Nullable Project project, @Nullable Component component, @NlsContexts.ProgressTitle @NotNull String title, boolean cancellable, boolean isModal, @NotNull Collection<String> pathsToUpload, @NotNull String remotePath) {
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(pathsToUpload, (String)"pathsToUpload");
        Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
        this.credentials = credentials;
        this.project = project;
        this.component = component;
        this.title = title;
        this.pathsToUpload = pathsToUpload;
        this.remotePath = remotePath;
        this.process = RemoteUploadKt.createTask(this.project, this.title, cancellable, isModal, new Progressive(this){
            final /* synthetic */ RemoteUpload this$0;

            public final void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                RemoteUpload.access$doUploadFilesToRemote(this.this$0, indicator, RemoteUpload.access$getPathsToUpload$p(this.this$0), RemoteUpload.access$getRemotePath$p(this.this$0));
            }
            {
                this.this$0 = remoteUpload;
            }
        });
        this.progressIndicator = this.process instanceof Task.Backgroundable ? (StandardProgressIndicator)new BackgroundableProcessIndicator((Task.Backgroundable)this.process) : (StandardProgressIndicator)new EmptyProgressIndicator();
    }

    public static final /* synthetic */ Task access$getProcess$p(RemoteUpload $this) {
        return $this.process;
    }

    public static final /* synthetic */ boolean access$applyFilter(RemoteUpload $this, Predicate filter, String entryName) {
        return $this.applyFilter((Predicate<String>)filter, entryName);
    }

    public static final /* synthetic */ void access$doUploadFilesToRemote(RemoteUpload $this, ProgressIndicator indicator, Collection localHelpersRoots, String remoteHelpersRoot) {
        $this.doUploadFilesToRemote(indicator, localHelpersRoots, remoteHelpersRoot);
    }

    public static final /* synthetic */ Collection access$getPathsToUpload$p(RemoteUpload $this) {
        return $this.pathsToUpload;
    }

    public static final /* synthetic */ String access$getRemotePath$p(RemoteUpload $this) {
        return $this.remotePath;
    }
}

