/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.ui;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.DynamicBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.VagrantBasedCredentialsHolder;
import com.intellij.remote.VagrantSupport;
import com.intellij.remote.ui.RemoteSdkEditorForm;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.StatusPanel;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.remotesdk.RemoteSdkBundle;
import com.jetbrains.plugins.remotesdk.VagrantCredentialsType;
import com.jetbrains.plugins.remotesdk.ui.CreateRemoteSdkUIUtil;
import com.jetbrains.plugins.remotesdk.ui.WebDeploymentCredentialsEditor;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VagrantCredentialsEditor
implements PanelWithAnchor {
    private JPanel myPanel;
    private TextFieldWithBrowseButton myVagrantInstanceTextField;
    private JBLabel myVagrantInstanceLabel;
    private JBLabel myVagrantHostLabel;
    private JLabel myVagrantHostUrl;
    private JBLabel myMachineNameLabel;
    private ComboBox<String> myMachineNameCombo;
    @NotNull
    private final VagrantSupport myVagrantSupport;
    @Nullable
    private final RemoteSdkEditorForm myParentForm;
    private VagrantBasedCredentialsHolder myVagrantCredentials;
    private RemoteCredentials myRemoteCredentials;
    @Nullable
    private JComponent myAnchor;
    @Nullable
    private final Project myProject;
    @NotNull
    private final StatusPanel myStatusPanel;

    public VagrantCredentialsEditor(@NotNull VagrantSupport vagrantSupport, @Nullable Project project, @NotNull StatusPanel statusPanel) {
        if (vagrantSupport == null) {
            VagrantCredentialsEditor.$$$reportNull$$$0(0);
        }
        if (statusPanel == null) {
            VagrantCredentialsEditor.$$$reportNull$$$0(1);
        }
        this(vagrantSupport, null, project, statusPanel);
    }

    public VagrantCredentialsEditor(@NotNull VagrantSupport vagrantSupport, @NotNull RemoteSdkEditorForm parentForm, @Nullable Project project) {
        if (vagrantSupport == null) {
            VagrantCredentialsEditor.$$$reportNull$$$0(2);
        }
        if (parentForm == null) {
            VagrantCredentialsEditor.$$$reportNull$$$0(3);
        }
        this(vagrantSupport, parentForm, project, parentForm.getStatusPanel());
    }

    private VagrantCredentialsEditor(@NotNull VagrantSupport vagrantSupport, @Nullable RemoteSdkEditorForm parentForm, @Nullable Project project, @NotNull StatusPanel statusPanel) {
        String vagrantFolder;
        if (vagrantSupport == null) {
            VagrantCredentialsEditor.$$$reportNull$$$0(4);
        }
        if (statusPanel == null) {
            VagrantCredentialsEditor.$$$reportNull$$$0(5);
        }
        this.myVagrantSupport = vagrantSupport;
        this.myParentForm = parentForm;
        this.myProject = project;
        this.myStatusPanel = statusPanel;
        this.$$$setupUI$$$();
        FileChooserDescriptor folderDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        this.myVagrantInstanceTextField.addBrowseFolderListener(new TextBrowseFolderListener(folderDescriptor){

            protected void onFileChosen(@NotNull VirtualFile chosenFile) {
                if (chosenFile == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.onFileChosen(chosenFile);
                VagrantCredentialsEditor.this.setVagrantMachineSelectionVisible(false);
                VagrantCredentialsEditor.this.vagrantSelected(chosenFile.getPath(), null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenFile", "com/jetbrains/plugins/remotesdk/ui/VagrantCredentialsEditor$1", "onFileChosen"));
            }
        });
        this.myVagrantInstanceTextField.setEditable(false);
        this.setVagrantMachineSelectionVisible(false);
        if (project != null && (vagrantFolder = this.myVagrantSupport.findVagrantFolder(project)) != null) {
            this.myVagrantInstanceTextField.setText(FileUtil.toSystemDependentName((String)vagrantFolder));
        }
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    public void onSelected() {
        if (!StringUtil.isEmpty((String)this.myVagrantInstanceTextField.getText())) {
            this.vagrantSelected(this.myVagrantInstanceTextField.getText(), this.getVagrantMachineName());
        }
    }

    @Nullable
    public String getVagrantMachineName() {
        if (!this.isVagrantMultipleMachines()) {
            return null;
        }
        return this.myMachineNameCombo.getSelectedItem() != null ? this.myMachineNameCombo.getSelectedItem().toString() : null;
    }

    public void vagrantSelected(@NotNull String vagrantFolder, @Nullable String machineName) {
        if (vagrantFolder == null) {
            VagrantCredentialsEditor.$$$reportNull$$$0(6);
        }
        StatusPanel.Action loadConfigAction = this.myStatusPanel.progress(RemoteSdkBundle.message("loading.vagrant.config", new Object[0]));
        if (StringUtil.isNotEmpty((String)machineName)) {
            if (!this.isVagrantMultipleMachines()) {
                this.initVagrantMachineSelection(vagrantFolder, machineName);
            }
        } else {
            List machineNames;
            if (!this.isVagrantMultipleMachines() && (machineNames = this.myVagrantSupport.getMachineNames(vagrantFolder)).size() > 1) {
                this.setMultipleMachinesMode(vagrantFolder, machineName, machineNames);
            }
            if (this.isVagrantMultipleMachines()) {
                loadConfigAction.failed(RemoteSdkBundle.message("dialog.message.multiple.machine.configuration.detected.please.select.machine.name", new Object[0]));
                return;
            }
        }
        this.updateStatus(vagrantFolder, machineName, loadConfigAction, 0);
    }

    public boolean isVagrantMultipleMachines() {
        return this.myMachineNameLabel.isVisible();
    }

    public boolean initVagrantMachineSelection(@NotNull String vagrantFolder, @Nullable String machineName) {
        List machineNames;
        if (vagrantFolder == null) {
            VagrantCredentialsEditor.$$$reportNull$$$0(7);
        }
        if ((machineNames = this.myVagrantSupport.getMachineNames(vagrantFolder)).size() > 1) {
            this.setMultipleMachinesMode(vagrantFolder, machineName, machineNames);
            return true;
        }
        return false;
    }

    public void setMultipleMachinesMode(final @NotNull String vagrantFolder, @Nullable @NlsSafe String machineName, List<String> machineNames) {
        if (vagrantFolder == null) {
            VagrantCredentialsEditor.$$$reportNull$$$0(8);
        }
        for (ItemListener l : Arrays.asList(this.myMachineNameCombo.getItemListeners())) {
            this.myMachineNameCombo.removeItemListener(l);
        }
        this.myMachineNameCombo.setModel((ComboBoxModel)new CollectionComboBoxModel((List)Lists.newArrayList((Iterable)Iterables.concat(Collections.singletonList(null), machineNames))));
        this.myMachineNameCombo.setSelectedItem((Object)machineName);
        this.myMachineNameCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                VagrantCredentialsEditor.this.vagrantSelected(vagrantFolder, VagrantCredentialsEditor.this.getVagrantMachineName());
            }
        });
        UIUtil.invokeLaterIfNeeded(() -> this.setVagrantMachineSelectionVisible(true));
    }

    private void setVagrantMachineSelectionVisible(boolean visible) {
        this.myMachineNameCombo.setVisible(visible);
        this.myMachineNameLabel.setVisible(visible);
    }

    private void updateStatus(final @NotNull String vagrantFolder, final @Nullable String machineName, final StatusPanel.Action loadConfigAction, final int recursion) {
        if (vagrantFolder == null) {
            VagrantCredentialsEditor.$$$reportNull$$$0(9);
        }
        if (recursion > 5) {
            loadConfigAction.failed(RemoteSdkBundle.message("dialog.message.couldn.t.connect.to.vagrant", new Object[0]));
            return;
        }
        Futures.addCallback((ListenableFuture)this.myVagrantSupport.computeVagrantSettings(this.myProject, vagrantFolder, machineName), (FutureCallback)new FutureCallback<RemoteCredentials>(){

            public void onSuccess(@Nullable RemoteCredentials credentials) {
                UIUtil.invokeLaterIfNeeded(() -> {
                    loadConfigAction.done();
                    VagrantCredentialsEditor.this.useVagrantSettings(credentials, vagrantFolder, machineName);
                });
            }

            public void onFailure(@NotNull Throwable t) {
                if (t == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (t instanceof VagrantSupport.MultipleMachinesException) {
                    if (VagrantCredentialsEditor.this.initVagrantMachineSelection(vagrantFolder, machineName)) {
                        VagrantCredentialsEditor.this.vagrantSelected(vagrantFolder, machineName);
                        loadConfigAction.done();
                        return;
                    }
                } else if (VagrantCredentialsEditor.this.myVagrantSupport.isNotReadyForSsh(t) && VagrantCredentialsEditor.this.myVagrantSupport.checkVagrantRunning(vagrantFolder, machineName, true)) {
                    VagrantCredentialsEditor.this.updateStatus(vagrantFolder, machineName, loadConfigAction, recursion + 1);
                    return;
                }
                UIUtil.invokeLaterIfNeeded(() -> {
                    VagrantCredentialsEditor.this.myVagrantHostUrl.setText("");
                    loadConfigAction.failed(RemoteSdkBundle.message("dialog.message.can.t.get.vagrant.settings", t.getMessage()));
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/jetbrains/plugins/remotesdk/ui/VagrantCredentialsEditor$3", "onFailure"));
            }
        }, (Executor)AppExecutorUtil.getAppExecutorService());
    }

    private void useVagrantSettings(@Nullable RemoteCredentials credentials, @NotNull @NlsSafe String instanceFolder, @Nullable String machineName) {
        if (instanceFolder == null) {
            VagrantCredentialsEditor.$$$reportNull$$$0(10);
        }
        if (this.myParentForm == null || this.myParentForm.isSdkInConsistentState((CredentialsType)VagrantCredentialsType.getInstance())) {
            this.setVagrantCredentials(credentials, new VagrantBasedCredentialsHolder(instanceFolder, machineName));
            this.myVagrantInstanceTextField.setText(instanceFolder);
            if (StringUtil.isNotEmpty((String)machineName) && !this.isVagrantMultipleMachines()) {
                this.initVagrantMachineSelection(instanceFolder, machineName);
            }
        }
    }

    private void setVagrantCredentials(@Nullable RemoteCredentials credentials, @NotNull VagrantBasedCredentialsHolder vagrantCredentials) {
        if (vagrantCredentials == null) {
            VagrantCredentialsEditor.$$$reportNull$$$0(11);
        }
        this.myVagrantCredentials = vagrantCredentials;
        Runnable validator = this.myParentForm != null ? this.myParentForm.getValidator() : null;
        CreateRemoteSdkUIUtil.useReferencedCredentials(this.myProject, this.myStatusPanel, validator, credentials, (JLabel)this.myVagrantHostLabel, this.myVagrantHostUrl, () -> {
            if (!this.myVagrantSupport.checkVagrantRunning(vagrantCredentials.getVagrantFolder(), vagrantCredentials.getMachineName(), true) && validator != null) {
                validator.run();
            }
        });
    }

    @Nullable
    public ValidationInfo validate(@NotNull Ref<FileTransferConfig> configRef, boolean allowSlowActions) {
        if (configRef == null) {
            VagrantCredentialsEditor.$$$reportNull$$$0(12);
        }
        if (StringUtil.isEmpty((String)this.myVagrantInstanceTextField.getText())) {
            return new ValidationInfo(RemoteSdkBundle.message("dialog.message.vagrant.instance.folder.not.specified", new Object[0]), (JComponent)this.myVagrantInstanceTextField);
        }
        if (this.myRemoteCredentials != null) {
            configRef.set((Object)WebDeploymentCredentialsEditor.credentialsAsFileTransferConfig(this.myRemoteCredentials));
            return null;
        }
        if (this.myVagrantCredentials == null) {
            return new ValidationInfo(RemoteSdkBundle.message("dialog.message.cant.obtain.ssh.credentials.for.vagrant.at", this.myVagrantInstanceTextField.getText()));
        }
        try {
            if (!allowSlowActions) {
                return new ValidationInfo(RemoteSdkBundle.message("dialog.message.no.credentials.for.vagrant.remote.interpreter.was.loaded", new Object[0]));
            }
            this.myRemoteCredentials = this.myVagrantSupport.getCredentials(this.myVagrantCredentials.getVagrantFolder(), this.myVagrantCredentials.getMachineName());
        }
        catch (Exception e) {
            return new ValidationInfo(e.getMessage() != null ? e.getMessage() : RemoteSdkBundle.message("dialog.message.error.create.vagrant.remote.interpreter", e.getClass().toString()));
        }
        return null;
    }

    @Nullable
    public VagrantBasedCredentialsHolder getVagrantCredentials() {
        return this.myVagrantCredentials;
    }

    public void initVagrantSettings(VagrantBasedCredentialsHolder cred) {
        this.useVagrantSettings(null, cred.getVagrantFolder(), cred.getMachineName());
        this.vagrantSelected(cred.getVagrantFolder(), cred.getMachineName());
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myVagrantInstanceTextField.getChildComponent();
    }

    @Nullable
    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(@Nullable JComponent anchor) {
        this.myAnchor = anchor;
        this.myVagrantInstanceLabel.setAnchor(anchor);
    }

    @NotNull
    public List<JBLabel> getLabelsColumn() {
        ImmutableList immutableList = ContainerUtil.immutableList((Object[])new JBLabel[]{this.myVagrantInstanceLabel, this.myMachineNameLabel, this.myVagrantHostLabel});
        if (immutableList == null) {
            VagrantCredentialsEditor.$$$reportNull$$$0(13);
        }
        return immutableList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vagrantSupport";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentForm";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vagrantFolder";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceFolder";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vagrantCredentials";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configRef";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/remotesdk/ui/VagrantCredentialsEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/remotesdk/ui/VagrantCredentialsEditor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelsColumn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "vagrantSelected";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "initVagrantMachineSelection";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setMultipleMachinesMode";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateStatus";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "useVagrantSettings";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setVagrantCredentials";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBox comboBox;
        JBLabel jBLabel;
        JLabel jLabel;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myVagrantInstanceTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myVagrantInstanceLabel = jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/RemoteSdkBundle", VagrantCredentialsEditor.class).getString("vagrant.instance.folder.label"));
        jPanel.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVagrantHostLabel = jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/RemoteSdkBundle", VagrantCredentialsEditor.class).getString("vagrant.host.url.label"));
        jPanel.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myVagrantHostUrl = jLabel = new JLabel();
        jLabel.setText("");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 1, new Dimension(7, -1), null, new Dimension(7, -1)));
        this.myMachineNameLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/RemoteSdkBundle", VagrantCredentialsEditor.class).getString("vagrant.machine.name.label"));
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMachineNameCombo = comboBox = new ComboBox();
        jPanel.add((Component)comboBox, new GridConstraints(1, 1, 1, 1, 0, 1, 2, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

