/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.debugger.embedded.svd;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.text.TextWithMnemonic;
import com.intellij.ui.TreeTableSpeedSearch;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.jetbrains.cidr.cpp.embedded.EmbeddedBundle;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.svd.Format;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.svd.SvdField;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.svd.SvdFile;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.svd.SvdNode;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.svd.SvdRegister;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.svd.SvdRoot;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.svd.SvdTreeTableModel;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.svd.SvdValue;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.svd.SvdWindowState;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import java.awt.Component;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public final class SvdTreeTable
extends TreeTable {
    private static final int HEX_VALUE_LENGTH = 10;
    private static final int COLUMN_EXTRA_PX = 12;
    private static final int NAME_LENGTH = 25;
    private final SvdRoot myRoot;
    private final SvdWindowState.ProjectState myWindowProfileState;

    private SvdTreeTable(@NotNull SvdTreeTableModel model, final @NotNull SvdWindowState.ProjectState windowProfileState, @NotNull SvdRoot root) {
        if (model == null) {
            SvdTreeTable.$$$reportNull$$$0(0);
        }
        if (windowProfileState == null) {
            SvdTreeTable.$$$reportNull$$$0(1);
        }
        if (root == null) {
            SvdTreeTable.$$$reportNull$$$0(2);
        }
        super((TreeTableModel)model);
        this.myWindowProfileState = windowProfileState;
        this.setAutoResizeMode(3);
        int xWidth = this.getFontMetrics(this.getFont()).charWidth('X');
        TableColumnModel columnModel = this.getColumnModel();
        TableColumn nameColumn = columnModel.getColumn(0);
        nameColumn.setWidth(xWidth * 25 + 12);
        TableColumn valueColumn = columnModel.getColumn(1);
        valueColumn.setWidth(xWidth * 10 + 12);
        TableColumn descriptionColumn = columnModel.getColumn(2);
        descriptionColumn.setMinWidth(0);
        descriptionColumn.setPreferredWidth(0);
        descriptionColumn.setWidth(0);
        TreeTableTree tree = this.getTree();
        tree.setCellRenderer((TreeCellRenderer)new NameTreeCellRenderer(tree.getCellRenderer()));
        this.getTableHeader().setResizingColumn(descriptionColumn);
        TreeTableSpeedSearch speedSearch = new TreeTableSpeedSearch((TreeTable)this, treePath -> {
            Object component = treePath.getLastPathComponent();
            if (component instanceof SvdNode) {
                SvdNode svdNode = (SvdNode)component;
                return svdNode.getName() + " " + svdNode.getDescription();
            }
            return "";
        });
        speedSearch.setCanExpand(true);
        this.setupPopupMenu();
        this.myRoot = root;
        this.setRootVisible(false);
        DefaultTableCellRenderer descriptionRenderer = new DefaultTableCellRenderer();
        descriptionRenderer.setForeground(UIUtil.getContextHelpForeground());
        descriptionColumn.setCellRenderer(descriptionRenderer);
        tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                windowProfileState.notifyTreeNodeChanged(SvdTreeTable.this, event.getPath());
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                windowProfileState.notifyTreeNodeChanged(SvdTreeTable.this, event.getPath());
            }
        });
    }

    private void setupPopupMenu() {
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup group = new DefaultActionGroup();
        final CopyValueAction copyValueAction = new CopyValueAction();
        this.getActionMap().put("copy", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                copyValueAction.doCopy();
            }
        });
        group.add((AnAction)copyValueAction);
        group.add((AnAction)new CopyPeripheralAddressAction());
        group.addSeparator();
        for (Format format : Format.values()) {
            group.add((AnAction)new SetFormatAction(format));
        }
        group.addSeparator();
        group.add((AnAction)new HideNodeAction());
        ActionPopupMenu menu = actionManager.createActionPopupMenu("DebuggerToolbar", (ActionGroup)group);
        this.setComponentPopupMenu(menu.getComponent());
    }

    @NotNull
    public SvdRoot getRoot() {
        SvdRoot svdRoot = this.myRoot;
        if (svdRoot == null) {
            SvdTreeTable.$$$reportNull$$$0(3);
        }
        return svdRoot;
    }

    public void setAutoUpdate(boolean autoUpdate) {
        this.setForeground(autoUpdate ? UIUtil.getTableForeground() : UIUtil.getLabelDisabledForeground());
        this.repaint();
    }

    public void restoreState() {
        this.reopenFiles();
        this.restoreColumns();
        this.restoreNodeStates();
    }

    private void reopenFiles() {
        for (String fileName : this.myWindowProfileState.loadedFiles) {
            File file = new File(fileName);
            if (!file.exists() || !file.canRead()) continue;
            try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));){
                this.myRoot.addFile(inputStream, file.getName(), file.getPath());
            }
            catch (IOException e) {
                Logger.getInstance(SvdTreeTable.class).warn((Throwable)e);
            }
        }
    }

    private void restoreColumns() {
        List<String> columnOrder = this.myWindowProfileState.columnOrder;
        List<Integer> columnWidths = this.myWindowProfileState.columnWidths;
        int columnCount = Math.min(Math.min(this.getColumnCount(), columnOrder.size()), columnWidths.size());
        TableColumnModel columnModel = this.getColumnModel();
        for (int i = 0; i < columnCount; ++i) {
            String columnName = this.myWindowProfileState.columnOrder.get(i);
            try {
                int index = columnModel.getColumnIndex(columnName);
                if (index != i) {
                    columnModel.moveColumn(index, i);
                }
                columnModel.getColumn(i).setWidth(this.myWindowProfileState.columnWidths.get(i));
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private void restoreNodeStates() {
        Map<String, String> nodes = this.myWindowProfileState.nodes;
        ArrayDeque<SvdFile> nodeWalker = new ArrayDeque<SvdFile>(this.myRoot.getChildren());
        while (!nodeWalker.isEmpty()) {
            SvdNode svdNode = (SvdNode)nodeWalker.removeLast();
            nodeWalker.addAll(svdNode.getChildren());
            String nodeState = nodes.get(svdNode.getId());
            if (nodeState == null || nodeState.length() != 2) continue;
            this.myRoot.getActiveNodes().add(svdNode);
            svdNode.setFormatFromSign(nodeState.charAt(0));
        }
        this.myRoot.getTreeTableModel().resetActiveCache();
        for (TreePath treePath : TreeUtil.treePathTraverser((JTree)this.getTree())) {
            SvdNode node = (SvdNode)treePath.getLastPathComponent();
            String nodeState = nodes.get(node.getId());
            if (nodeState == null || nodeState.charAt(1) != 'E') continue;
            this.getTree().expandPath(treePath);
        }
    }

    private boolean isValueSelected() {
        return this.getTree().getLastSelectedPathComponent() instanceof SvdValue;
    }

    @NotNull
    public static SvdTreeTable create(@NotNull SvdWindowState.ProjectState windowProfileState) {
        if (windowProfileState == null) {
            SvdTreeTable.$$$reportNull$$$0(4);
        }
        SvdRoot root = new SvdRoot();
        return new SvdTreeTable(root.getTreeTableModel(), windowProfileState, root);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "windowProfileState";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/debugger/embedded/svd/SvdTreeTable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/embedded/svd/SvdTreeTable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class CopyPeripheralAddressAction
    extends DumbAwareAction {
        private CopyPeripheralAddressAction() {
            super(EmbeddedBundle.messagePointer("svd.table.copy.peripheral.address.action", new Object[0]));
        }

        public void update(@NotNull AnActionEvent e) {
            Object selectedNode;
            if (e == null) {
                CopyPeripheralAddressAction.$$$reportNull$$$0(0);
            }
            if ((selectedNode = SvdTreeTable.this.getTree().getLastSelectedPathComponent()) instanceof SvdRegister) {
                e.getPresentation().setEnabled(true);
            } else {
                e.getPresentation().setEnabled(false);
            }
            super.update(e);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Object selectedNode;
            if (e == null) {
                CopyPeripheralAddressAction.$$$reportNull$$$0(1);
            }
            if ((selectedNode = SvdTreeTable.this.getTree().getLastSelectedPathComponent()) instanceof SvdRegister) {
                Address address = ((SvdRegister)selectedNode).getAddress();
                String text = SvdRoot.addressToString(address);
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(text));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/embedded/svd/SvdTreeTable$CopyPeripheralAddressAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class SetFormatAction
    extends ToggleAction {
        private final Format myFormat;
        private boolean mySelected;

        private SetFormatAction(Format format) {
            super(format.getReadableName());
            this.myFormat = format;
        }

        public boolean isDumbAware() {
            return true;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                SetFormatAction.$$$reportNull$$$0(0);
            }
            return this.mySelected;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                SetFormatAction.$$$reportNull$$$0(1);
            }
            if (state) {
                Object selectedNode = SvdTreeTable.this.getTree().getLastSelectedPathComponent();
                if (selectedNode instanceof SvdValue) {
                    ((SvdValue)selectedNode).setFormat(this.myFormat);
                }
                this.mySelected = true;
            }
        }

        public void update(@NotNull AnActionEvent e) {
            Object selectedNode;
            if (e == null) {
                SetFormatAction.$$$reportNull$$$0(2);
            }
            if ((selectedNode = SvdTreeTable.this.getTree().getLastSelectedPathComponent()) instanceof SvdValue) {
                e.getPresentation().setEnabled(true);
                this.mySelected = ((SvdValue)selectedNode).getFormat() == this.myFormat;
            } else {
                e.getPresentation().setEnabled(false);
                this.mySelected = false;
            }
            super.update(e);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/embedded/svd/SvdTreeTable$SetFormatAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class HideNodeAction
    extends DumbAwareAction {
        private HideNodeAction() {
            super(EmbeddedBundle.messagePointer("svd.table.hide.node.action", new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Object selectedNode;
            if (e == null) {
                HideNodeAction.$$$reportNull$$$0(0);
            }
            if ((selectedNode = SvdTreeTable.this.getTree().getLastSelectedPathComponent()) != null && !(selectedNode instanceof SvdField)) {
                ArrayDeque treeWalker = new ArrayDeque();
                treeWalker.addLast((SvdNode)selectedNode);
                while (!treeWalker.isEmpty()) {
                    SvdNode node = (SvdNode)treeWalker.removeLast();
                    if (node instanceof SvdField) continue;
                    if (!(node instanceof SvdRegister)) {
                        treeWalker.addAll(node.getChildren());
                    }
                    if (node instanceof SvdFile) {
                        SvdTreeTable.this.myRoot.getChildren().remove(node);
                    }
                    if (node instanceof SvdRoot) continue;
                    SvdTreeTable.this.myRoot.getActiveNodes().remove(node);
                }
                List expandedPaths = TreeUtil.collectExpandedPaths((JTree)SvdTreeTable.this.getTree());
                SvdTreeTable.this.myRoot.getTreeTableModel().notifyTreeUpdated();
                SvdTreeTable.this.myWindowProfileState.notifyTreeChange(SvdTreeTable.this);
                TreeUtil.restoreExpandedPaths((JTree)SvdTreeTable.this.getTree(), (List)expandedPaths);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            SvdNode selectedNode;
            if (e == null) {
                HideNodeAction.$$$reportNull$$$0(1);
            }
            if ((selectedNode = (SvdNode)SvdTreeTable.this.getTree().getLastSelectedPathComponent()) == null) {
                e.getPresentation().setVisible(false);
            } else {
                e.getPresentation().setVisible(true);
                e.getPresentation().setTextWithMnemonic(() -> TextWithMnemonic.fromPlainText((String)EmbeddedBundle.message("svd.hide.node", selectedNode.getName())));
                e.getPresentation().setEnabled(!(selectedNode instanceof SvdField));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/embedded/svd/SvdTreeTable$HideNodeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class CopyValueAction
    extends DumbAwareAction {
        private CopyValueAction() {
            super(EmbeddedBundle.message("svd.table.copy.value.action.title", new Object[0]), EmbeddedBundle.message("svd.table.copy.value.action.description", new Object[0]), AllIcons.Actions.Copy);
            this.copyShortcutFrom(ActionManager.getInstance().getAction("$Copy"));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CopyValueAction.$$$reportNull$$$0(0);
            }
            this.doCopy();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CopyValueAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(SvdTreeTable.this.isValueSelected());
        }

        public void doCopy() {
            Object selectedNode = SvdTreeTable.this.getTree().getLastSelectedPathComponent();
            if (selectedNode instanceof SvdValue) {
                String text = ((SvdValue)selectedNode).getDisplayValue();
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(text));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/embedded/svd/SvdTreeTable$CopyValueAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class NameTreeCellRenderer
    implements TreeCellRenderer {
        private final TreeCellRenderer myUnderlayRenderer;

        private NameTreeCellRenderer(TreeCellRenderer underlayRenderer) {
            this.myUnderlayRenderer = underlayRenderer;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component component = this.myUnderlayRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (!selected && value instanceof SvdValue && ((SvdValue)value).isChanged()) {
                component.setForeground(XDebuggerUIConstants.CHANGED_VALUE_ATTRIBUTES.getFgColor());
            }
            return component;
        }
    }
}

