/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clangFormat.language;

import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.cidr.lang.daemon.clang.format.ClangFormatFileUtils;
import com.jetbrains.clangFormat.language.ClangFormatSchemaProvider;
import com.jetbrains.clangFormat.messages.ClangFormatBundle;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import com.jetbrains.jsonSchema.impl.JsonSchemaVersion;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLFileType;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\u0004H\u0016J\b\u0010\n\u001a\u00020\u0004H\u0016J\u0010\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fH\u0016J\b\u0010\u0015\u001a\u00020\u0013H\u0016R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/clangFormat/language/ClangFormatSchemaProvider;", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaFileProvider;", "()V", "ourPresentableName", "", "getOurPresentableName", "()Ljava/lang/String;", "ourPresentableName$delegate", "Lkotlin/Lazy;", "getName", "getPresentableName", "getSchemaFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.jvm.PlatformType", "getSchemaType", "Lcom/jetbrains/jsonSchema/extension/SchemaType;", "getSchemaVersion", "Lcom/jetbrains/jsonSchema/impl/JsonSchemaVersion;", "isAvailable", "", "file", "isUserVisible", "intellij.cidr.clangFormat"})
public final class ClangFormatSchemaProvider
implements JsonSchemaFileProvider {
    private static final Lazy ourPresentableName$delegate;
    @NotNull
    public static final ClangFormatSchemaProvider INSTANCE;

    private final String getOurPresentableName() {
        Lazy lazy = ourPresentableName$delegate;
        ClangFormatSchemaProvider clangFormatSchemaProvider = this;
        Object var3_3 = null;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAvailable(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (ClangFormatFileUtils.isClangFormatConfig(file)) return true;
        if (!(file instanceof LightVirtualFile)) return false;
        if (!Intrinsics.areEqual((Object)((LightVirtualFile)file).getFileType(), (Object)YAMLFileType.YML)) return false;
        String string = ((LightVirtualFile)file).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
        if (!StringsKt.startsWith$default((String)string, (String)ClangFormatBundle.message("cf.title.actual.clang.format", ""), (boolean)false, (int)2, null)) return false;
        return true;
    }

    @NotNull
    public String getName() {
        return this.getOurPresentableName();
    }

    public VirtualFile getSchemaFile() {
        StringBuilder stringBuilder = new StringBuilder().append("/schemas/");
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        return JsonSchemaProviderFactory.getResourceFile(ClangFormatSchemaProvider.class, (String)stringBuilder.append(editorColorsManager.isDarkEditor() ? "clangformatDark.json" : "clangformat.json").toString());
    }

    public boolean isUserVisible() {
        return false;
    }

    @NotNull
    public SchemaType getSchemaType() {
        return SchemaType.embeddedSchema;
    }

    @NotNull
    public JsonSchemaVersion getSchemaVersion() {
        return JsonSchemaVersion.SCHEMA_7;
    }

    @NotNull
    public String getPresentableName() {
        return this.getOurPresentableName();
    }

    private ClangFormatSchemaProvider() {
    }

    static {
        ClangFormatSchemaProvider clangFormatSchemaProvider;
        INSTANCE = clangFormatSchemaProvider = new ClangFormatSchemaProvider();
        ourPresentableName$delegate = LazyKt.lazy((Function0)ourPresentableName.2.INSTANCE);
    }
}

