/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.coverage.gnu.trove;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jetbrains.coverage.gnu.trove.HashFunctions;
import org.jetbrains.coverage.gnu.trove.SerializationProcedure;
import org.jetbrains.coverage.gnu.trove.TFloatFloatIterator;
import org.jetbrains.coverage.gnu.trove.TFloatFloatProcedure;
import org.jetbrains.coverage.gnu.trove.TFloatFunction;
import org.jetbrains.coverage.gnu.trove.TFloatHash;
import org.jetbrains.coverage.gnu.trove.TFloatHashingStrategy;
import org.jetbrains.coverage.gnu.trove.TFloatProcedure;

public class TFloatFloatHashMap
extends TFloatHash
implements Serializable {
    protected transient float[] _values;

    public TFloatFloatHashMap() {
    }

    public TFloatFloatHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public TFloatFloatHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TFloatFloatHashMap(TFloatHashingStrategy strategy) {
        super(strategy);
    }

    public TFloatFloatHashMap(int initialCapacity, TFloatHashingStrategy strategy) {
        super(initialCapacity, strategy);
    }

    public TFloatFloatHashMap(int initialCapacity, float loadFactor, TFloatHashingStrategy strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public Object clone() {
        TFloatFloatHashMap m = (TFloatFloatHashMap)super.clone();
        m._values = (float[])this._values.clone();
        return m;
    }

    public TFloatFloatIterator iterator() {
        return new TFloatFloatIterator(this);
    }

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = new float[capacity];
        return capacity;
    }

    public float put(float key, float value) {
        float previous = 0.0f;
        int index = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = this._values[index];
            isNewMapping = false;
        }
        byte previousState = this._states[index];
        this._set[index] = key;
        this._states[index] = 1;
        this._values[index] = value;
        if (isNewMapping) {
            this.postInsertHook(previousState == 0);
        }
        return previous;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        float[] oldKeys = this._set;
        float[] oldVals = this._values;
        byte[] oldStates = this._states;
        this._set = new float[newCapacity];
        this._values = new float[newCapacity];
        this._states = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates[i] != 1) continue;
            float o = oldKeys[i];
            int index = this.insertionIndex(o);
            this._set[index] = o;
            this._values[index] = oldVals[i];
            this._states[index] = 1;
        }
    }

    public float get(float key) {
        int index = this.index(key);
        return index < 0 ? 0.0f : this._values[index];
    }

    public void clear() {
        super.clear();
        float[] keys = this._set;
        float[] vals = this._values;
        byte[] states = this._states;
        int i = keys.length;
        while (i-- > 0) {
            keys[i] = 0.0f;
            vals[i] = 0.0f;
            states[i] = 0;
        }
    }

    public float remove(float key) {
        float prev = 0.0f;
        int index = this.index(key);
        if (index >= 0) {
            prev = this._values[index];
            this.removeAt(index);
        }
        return prev;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TFloatFloatHashMap)) {
            return false;
        }
        TFloatFloatHashMap that = (TFloatFloatHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEachEntry(p);
        return p.getHashCode();
    }

    protected void removeAt(int index) {
        super.removeAt(index);
        this._values[index] = 0.0f;
    }

    public float[] getValues() {
        float[] vals = new float[this.size()];
        float[] v = this._values;
        byte[] states = this._states;
        int i = v.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            vals[j++] = v[i];
        }
        return vals;
    }

    public float[] keys() {
        float[] keys = new float[this.size()];
        float[] k = this._set;
        byte[] states = this._states;
        int i = k.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            keys[j++] = k[i];
        }
        return keys;
    }

    public boolean containsValue(float val) {
        byte[] states = this._states;
        float[] vals = this._values;
        int i = vals.length;
        while (i-- > 0) {
            if (states[i] != 1 || val != vals[i]) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(float key) {
        return this.contains(key);
    }

    public boolean forEachKey(TFloatProcedure procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TFloatProcedure procedure) {
        byte[] states = this._states;
        float[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TFloatFloatProcedure procedure) {
        byte[] states = this._states;
        float[] keys = this._set;
        float[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(keys[i], values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean retainEntries(TFloatFloatProcedure procedure) {
        boolean modified = false;
        byte[] states = this._states;
        float[] keys = this._set;
        float[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(keys[i], values[i])) continue;
            this.removeAt(i);
            modified = true;
        }
        return modified;
    }

    public void transformValues(TFloatFunction function) {
        byte[] states = this._states;
        float[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            values[i] = function.execute(values[i]);
        }
    }

    public boolean increment(float key) {
        return this.adjustValue(key, 1.0f);
    }

    public boolean adjustValue(float key, float amount) {
        int index = this.index(key);
        if (index < 0) {
            return false;
        }
        int n = index;
        this._values[n] = this._values[n] + amount;
        return true;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEachEntry(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this.setUp(size);
        while (size-- > 0) {
            float key = stream.readFloat();
            float val = stream.readFloat();
            this.put(key, val);
        }
    }

    private static final class EqProcedure
    implements TFloatFloatProcedure {
        private final TFloatFloatHashMap _otherMap;

        EqProcedure(TFloatFloatHashMap otherMap) {
            this._otherMap = otherMap;
        }

        public final boolean execute(float key, float value) {
            int index = this._otherMap.index(key);
            return index >= 0 && this.eq(value, this._otherMap.get(key));
        }

        private final boolean eq(float v1, float v2) {
            return v1 == v2;
        }
    }

    private final class HashProcedure
    implements TFloatFloatProcedure {
        private int h = 0;

        private HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(float key, float value) {
            this.h += TFloatFloatHashMap.this._hashingStrategy.computeHashCode(key) ^ HashFunctions.hash(value);
            return true;
        }
    }
}

