/*****
 NAME
 	pgraphics.h - protocol for Graphics class group
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#if !defined(PGRAPHICS_H_INCLUDED)
#define PGRAPHICS_H_INCLUDED

#include <coconut/pobject.h>
#include <coconut/perror.h>
#include <coconut/tgraphics.h>

@protocol PPoint <PObject>

 - set: (position_t) holiz and: (position_t) vert ;

 - (position_t) holiz ;
 - (position_t) vert ;

@end

@protocol PRect <PObject>

 - set: (position_t) left and: (position_t) top
     and:(dimension_t) width and:(dimension_t) height ;
 - setCorner: (position_t) left and: (position_t) top ;
 - setSize: (dimension_t) width and: (dimension_t) height ;

 - setLeft: (position_t) left ;
 - setTop: (position_t) top ;
 - setRight: (position_t) right ;
 - setBottom: (position_t) bottom ;

 - (position_t) left ;
 - (position_t) top ;
 - (position_t) right ;
 - (position_t) bottom ;

 - (dimension_t) width ;
 - (dimension_t) height ;

 - copy: (id <PRect>) src ;
 - move: (position_t) dh and: (position_t) dv ;
 - grow: (position_t) dh and: (position_t) dv ;

 - (id <PError>) union: (id <PRect>) rect ;

@end

#endif /* !defined(PGRAPHICS_H_INCLUDED) */

