/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.awt.Color;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.AlignmentUtils;

public class BisulfiteBaseInfo {
    public static Color CYTOSINE_MISMATCH_COLOR = new Color(139, 94, 60);
    public static Color NONCYTOSINE_MISMATCH_COLOR = new Color(139, 94, 60);
    public static Color DEAMINATION_COLOR = new Color(139, 94, 60);
    public static Color METHYLATED_COLOR = Color.red;
    public static Color UNMETHYLATED_COLOR = Color.blue;
    private DisplayStatus[] displayStatus = null;
    private byte[] displayChars = null;
    private Color[] displayColors = null;
    private AlignmentTrack.BisulfiteContext myContext = null;
    private boolean flipRead;

    public BisulfiteBaseInfo(byte[] inReference, Alignment baseAlignment, AlignmentBlock block, AlignmentTrack.BisulfiteContext bisulfiteContext) {
        this.myContext = bisulfiteContext;
        byte[] inRead = block.getBases();
        if (inRead != null) {
            int alignmentLen = inRead.length;
            this.flipRead = baseAlignment.isPaired() ? baseAlignment.isPaired() && baseAlignment.isNegativeStrand() ^ baseAlignment.isSecondOfPair() : baseAlignment.isNegativeStrand();
            byte[] read = this.flipRead ? AlignmentUtils.reverseComplementCopy(inRead) : inRead;
            byte[] reference = this.flipRead && inReference != null ? AlignmentUtils.reverseComplementCopy(inReference) : inReference;
            this.displayChars = new byte[alignmentLen];
            this.displayStatus = new DisplayStatus[alignmentLen];
            this.displayColors = new Color[alignmentLen];
            int idxEnd = alignmentLen - 1;
            for (int idxFw = 0; idxFw < alignmentLen; ++idxFw) {
                int idx;
                int n = idx = this.flipRead ? idxEnd - idxFw : idxFw;
                if (idx < 0 || idx >= reference.length) continue;
                byte refbase = reference[idx];
                byte readbase = read[idx];
                if (readbase == 61) {
                    readbase = refbase;
                }
                if (refbase > 90) {
                    refbase = (byte)(refbase - 32);
                }
                if (readbase > 90) {
                    readbase = (byte)(readbase - 32);
                }
                Color out = null;
                boolean matchesContext = false;
                if (78 == readbase) {
                    if (!AlignmentUtils.compareBases(readbase, refbase)) {
                        out = NONCYTOSINE_MISMATCH_COLOR;
                    }
                } else {
                    switch (refbase) {
                        case 65: 
                        case 71: 
                        case 84: {
                            if (AlignmentUtils.compareBases((byte)67, readbase)) {
                                out = METHYLATED_COLOR;
                                break;
                            }
                            if (AlignmentUtils.compareBases(readbase, refbase)) break;
                            out = NONCYTOSINE_MISMATCH_COLOR;
                            break;
                        }
                        case 67: {
                            if (!AlignmentUtils.compareBases((byte)67, readbase) && !AlignmentUtils.compareBases((byte)84, readbase)) {
                                out = CYTOSINE_MISMATCH_COLOR;
                                break;
                            }
                            AlignmentTrack.BisulfiteContext matchingContext = this.contextIsMatching(reference, read, idx, bisulfiteContext);
                            boolean bl = matchesContext = matchingContext != null;
                            if (!matchesContext) break;
                            out = this.getContextColor(readbase, matchingContext);
                        }
                    }
                }
                this.displayColors[idxFw] = out;
                if (out == null) {
                    this.displayStatus[idxFw] = DisplayStatus.NOTHING;
                    continue;
                }
                if (matchesContext) {
                    this.displayStatus[idxFw] = DisplayStatus.COLOR;
                    continue;
                }
                this.displayStatus[idxFw] = DisplayStatus.CHARACTER;
                this.displayChars[idxFw] = 88;
            }
        }
    }

    protected Color getContextColor(byte readbase, AlignmentTrack.BisulfiteContext bisulfiteContext) {
        Color out = null;
        if (AlignmentUtils.compareBases((byte)84, readbase)) {
            out = UNMETHYLATED_COLOR;
        } else if (AlignmentUtils.compareBases((byte)67, readbase)) {
            out = METHYLATED_COLOR;
        }
        return out;
    }

    protected AlignmentTrack.BisulfiteContext contextIsMatching(byte[] reference, byte[] read, int idx, AlignmentTrack.BisulfiteContext bisulfiteContext) {
        int offsetidx;
        byte contextb;
        if (AlignmentTrack.BisulfiteContext.NONE == bisulfiteContext) {
            return bisulfiteContext;
        }
        byte[] preContext = AlignmentTrack.getBisulfiteContextPreContext(bisulfiteContext);
        byte[] postContext = AlignmentTrack.getBisulfiteContextPostContext(bisulfiteContext);
        boolean matchesContext = true;
        int minLen = Math.min(reference.length, read.length);
        if (idx + postContext.length >= minLen) {
            matchesContext = false;
        } else {
            for (int posti = 0; matchesContext && posti < postContext.length; matchesContext &= this.positionMatchesContext(contextb, reference[offsetidx], read[offsetidx]), ++posti) {
                contextb = postContext[posti];
                offsetidx = idx + 1 + posti;
            }
        }
        if (idx - preContext.length < 0) {
            matchesContext = false;
        } else {
            for (int prei = 0; matchesContext && prei < preContext.length; matchesContext &= this.positionMatchesContext(contextb, reference[offsetidx], read[offsetidx]), ++prei) {
                contextb = preContext[prei];
                offsetidx = idx - (preContext.length - prei);
            }
        }
        return matchesContext ? bisulfiteContext : null;
    }

    protected boolean positionMatchesContext(byte contextb, byte referenceBase, byte readBase) {
        boolean matchesContext = AlignmentUtils.compareBases(contextb, referenceBase);
        if (!matchesContext) {
            return false;
        }
        boolean matchesReadContext = AlignmentUtils.compareBases(contextb, readBase);
        if (AlignmentUtils.compareBases((byte)84, readBase)) {
            matchesReadContext |= AlignmentUtils.compareBases(contextb, (byte)67);
        }
        return matchesReadContext;
    }

    public Color getDisplayColor(int idx) {
        return this.displayColors[idx];
    }

    public DisplayStatus getDisplayStatus(int idx) {
        return this.displayStatus[idx];
    }

    public int numDisplayStatus() {
        int len = this.displayStatus.length;
        boolean done = false;
        int i = 0;
        for (i = 0; !done && i < len; ++i) {
            done = this.displayStatus[i] == null;
        }
        return i;
    }

    public double getXaxisShift(int idx) {
        double offset = 0.0;
        if (this.getDisplayStatus(idx).equals((Object)DisplayStatus.COLOR)) {
            double baseOffset = this.getBisulfiteSymmetricCytosineShift(this.myContext);
            offset += (double)(this.flipRead ? -1 : 1) * baseOffset;
        }
        return offset;
    }

    protected double getBisulfiteSymmetricCytosineShift(AlignmentTrack.BisulfiteContext item) {
        double out = 0.0;
        return out;
    }

    public static enum DisplayStatus {
        NOTHING,
        COLOR,
        CHARACTER;

    }
}

