/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner;

import com.intellij.ui.paint.LinePainter2D;
import com.intellij.uiDesigner.DesignSpacer;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;

public final class VSpacer
extends DesignSpacer {
    public VSpacer() {
        this.setSize(VSpacer.getHandleWidth(), 50);
    }

    private static int getHandleWidth() {
        return 11;
    }

    private static int getHandleHeight() {
        return 5;
    }

    protected void paintComponent(Graphics g) {
        int handleHeight = VSpacer.getHandleHeight();
        int handleWidth = VSpacer.getHandleWidth();
        int x = (this.getWidth() - handleWidth) / 2;
        VSpacer.drawHandle(g, x, 0);
        g.setColor(ourColor1);
        LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)(x + handleWidth / 2), (double)handleHeight, (double)(x + handleWidth / 2), (double)(handleHeight + 1));
        int y = this.getHeight() - handleHeight - 1;
        VSpacer.drawHandle(g, x, y);
        LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)(x + handleWidth / 2), (double)(y - 2), (double)(x + handleWidth / 2), (double)y);
        g.setColor(ourColor1);
        VSpacer.drawSpring(g, x + handleWidth / 2, handleHeight + 1, this.getHeight() - 2 * handleHeight - 4);
    }

    private static void drawHandle(Graphics g, int x, int y) {
        g.setColor(ourColor1);
        g.drawRect(x, y, 2, 4);
        LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)(x + 3), (double)(y + 2), (double)(x + 3 + 1 - 1), (double)(y + 2));
        g.drawRect(x += 4, y, 2, 4);
        LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)(x + 3), (double)(y + 2), (double)(x + 3 + 1 - 1), (double)(y + 2));
        g.drawRect(x += 4, y, 2, 4);
    }

    private static void drawSpring(Graphics g, int x, int y, int height) {
        for (int _y = y; _y < y + height - 1; _y += 4) {
            VSpacer.drawSpringPeriod(g, x, _y);
        }
    }

    private static void drawSpringPeriod(Graphics g, int x, int y) {
        g.setColor(ourColor2);
        LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)(x + 1), (double)y, (double)(x + 2), (double)y);
        LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)x, (double)(y + 1), (double)x, (double)(y + 1));
        LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)(x - 1), (double)(y + 2), (double)(x - 2), (double)(y + 2));
        g.setColor(ourColor3);
        LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)x, (double)(y + 3), (double)x, (double)(y + 3));
    }

    public Dimension getMinimumSize() {
        return new Dimension(VSpacer.getHandleWidth(), VSpacer.getHandleHeight() * 2 + 4);
    }
}

