/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.designSurface;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.ui.popup.PopupOwner;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.actions.MoveComponentAction;
import com.intellij.uiDesigner.actions.MoveSelectionToDownAction;
import com.intellij.uiDesigner.actions.MoveSelectionToLeftAction;
import com.intellij.uiDesigner.actions.MoveSelectionToRightAction;
import com.intellij.uiDesigner.actions.MoveSelectionToUpAction;
import com.intellij.uiDesigner.actions.SelectAllComponentsAction;
import com.intellij.uiDesigner.actions.StartInplaceEditingAction;
import com.intellij.uiDesigner.componentTree.ComponentTree;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.propertyInspector.DesignerToolWindowManager;
import com.intellij.uiDesigner.radComponents.RadComponent;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GlassLayer
extends JComponent
implements DataProvider,
PopupOwner {
    private static final Logger LOG = Logger.getInstance(GlassLayer.class);
    private final GuiEditor myEditor;
    private Point myLastMousePosition;

    public GlassLayer(GuiEditor editor) {
        this.myEditor = editor;
        this.enableEvents(56L);
        this.registerKeyboardAction(new MoveSelectionToRightAction(this.myEditor, false, false), "EditorRight");
        this.registerKeyboardAction(new MoveSelectionToLeftAction(this.myEditor, false, false), "EditorLeft");
        this.registerKeyboardAction(new MoveSelectionToUpAction(this.myEditor, false, false), "EditorUp");
        this.registerKeyboardAction(new MoveSelectionToDownAction(this.myEditor, false, false), "EditorDown");
        this.registerKeyboardAction(new MoveSelectionToRightAction(this.myEditor, true, false), "EditorRightWithSelection");
        this.registerKeyboardAction(new MoveSelectionToLeftAction(this.myEditor, true, false), "EditorLeftWithSelection");
        this.registerKeyboardAction(new MoveSelectionToUpAction(this.myEditor, true, false), "EditorUpWithSelection");
        this.registerKeyboardAction(new MoveSelectionToDownAction(this.myEditor, true, false), "EditorDownWithSelection");
        this.registerKeyboardAction(new MoveSelectionToRightAction(this.myEditor, false, true), "EditorLineEnd");
        this.registerKeyboardAction(new MoveSelectionToLeftAction(this.myEditor, false, true), "EditorLineStart");
        this.registerKeyboardAction(new MoveSelectionToUpAction(this.myEditor, false, true), "EditorPageUp");
        this.registerKeyboardAction(new MoveSelectionToDownAction(this.myEditor, false, true), "EditorPageDown");
        this.registerKeyboardAction(new MoveSelectionToRightAction(this.myEditor, true, true), "EditorLineEndWithSelection");
        this.registerKeyboardAction(new MoveSelectionToLeftAction(this.myEditor, true, true), "EditorLineStartWithSelection");
        this.registerKeyboardAction(new MoveSelectionToUpAction(this.myEditor, true, true), "EditorPageUpWithSelection");
        this.registerKeyboardAction(new MoveSelectionToDownAction(this.myEditor, true, true), "EditorPageDownWithSelection");
        this.registerKeyboardAction(new MoveComponentAction(-1, 0, 0, 0), "EditorScrollUp");
        this.registerKeyboardAction(new MoveComponentAction(1, 0, 0, 0), "EditorScrollDown");
        this.registerKeyboardAction(new MoveComponentAction(0, -1, 0, 0), "EditorPreviousWord");
        this.registerKeyboardAction(new MoveComponentAction(0, 1, 0, 0), "EditorNextWord");
        this.registerKeyboardAction(new MoveComponentAction(0, 0, -1, 0), "MoveStatementUp");
        this.registerKeyboardAction(new MoveComponentAction(0, 0, 1, 0), "MoveStatementDown");
        this.registerKeyboardAction(new MoveComponentAction(0, 0, 0, -1), "EditorPreviousWordWithSelection");
        this.registerKeyboardAction(new MoveComponentAction(0, 0, 0, 1), "EditorNextWordWithSelection");
        this.registerKeyboardAction(new SelectAllComponentsAction(), "$SelectAll");
        StartInplaceEditingAction startInplaceEditingAction = new StartInplaceEditingAction(editor);
        startInplaceEditingAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(113, 0)), this);
    }

    private void registerKeyboardAction(AnAction action, @NonNls String actionId) {
        action.registerCustomShortcutSet(ActionManager.getInstance().getAction(actionId).getShortcutSet(), (JComponent)this);
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        this.myEditor.myProcessor.processKeyEvent(e);
        if (!e.isConsumed()) {
            super.processKeyEvent(e);
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (e.getID() == 501) {
            this.requestFocusInWindow();
        }
        try {
            this.myEditor.myProcessor.processMouseEvent(e);
        }
        catch (ProcessCanceledException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
        }
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        this.myLastMousePosition = e.getPoint();
        try {
            this.myEditor.myProcessor.processMouseEvent(e);
        }
        catch (ProcessCanceledException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
        }
    }

    @NotNull
    public Point getLastMousePosition() {
        if (this.myLastMousePosition == null) {
            return new Point(10, 10);
        }
        Point point = this.myLastMousePosition;
        if (point == null) {
            GlassLayer.$$$reportNull$$$0(0);
        }
        return point;
    }

    public Object getData(@NotNull String dataId) {
        ComponentTree componentTree;
        if (dataId == null) {
            GlassLayer.$$$reportNull$$$0(1);
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId) && (componentTree = DesignerToolWindowManager.getInstance(this.myEditor).getComponentTree()) != null) {
            return componentTree.getData(dataId);
        }
        return null;
    }

    @Nullable
    public Point getBestPopupPosition() {
        ArrayList<RadComponent> selection = FormEditingUtil.getSelectedComponents(this.myEditor);
        if (selection.size() > 0) {
            RadComponent component = selection.get(0);
            Rectangle bounds = component.getBounds();
            int bottom = bounds.height > 4 ? bounds.y + bounds.height - 4 : bounds.y;
            int left = bounds.width > 4 ? bounds.x + 4 : bounds.x;
            Point pnt = new Point(left, bottom);
            return SwingUtilities.convertPoint(component.getParent().getDelegee(), pnt, this);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/designSurface/GlassLayer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastMousePosition";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/designSurface/GlassLayer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

