/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore;

import com.android.tools.datastore.LogService;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class DataStoreDatabase {
    @NotNull
    private final LogService myLogService;
    private final Connection myConnection;

    @NotNull
    private LogService.Logger getLogger() {
        LogService.Logger logger = this.myLogService.getLogger(DataStoreDatabase.class);
        if (logger == null) {
            DataStoreDatabase.$$$reportNull$$$0(0);
        }
        return logger;
    }

    public DataStoreDatabase(@NotNull String dbPath, @NotNull Characteristic characteristic, @NotNull LogService logService) {
        if (dbPath == null) {
            DataStoreDatabase.$$$reportNull$$$0(1);
        }
        if (characteristic == null) {
            DataStoreDatabase.$$$reportNull$$$0(2);
        }
        if (logService == null) {
            DataStoreDatabase.$$$reportNull$$$0(3);
        }
        this(dbPath, characteristic, logService, t -> {});
    }

    public DataStoreDatabase(@NotNull String dbPath, @NotNull Characteristic characteristic, @NotNull LogService logService, @NotNull Consumer<Throwable> noPiiExceptionHandler) {
        if (dbPath == null) {
            DataStoreDatabase.$$$reportNull$$$0(4);
        }
        if (characteristic == null) {
            DataStoreDatabase.$$$reportNull$$$0(5);
        }
        if (logService == null) {
            DataStoreDatabase.$$$reportNull$$$0(6);
        }
        if (noPiiExceptionHandler == null) {
            DataStoreDatabase.$$$reportNull$$$0(7);
        }
        this.myLogService = logService;
        Connection connection = null;
        try {
            Class.forName("org.sqlite.JDBC");
            switch (characteristic) {
                case PERFORMANT: {
                    connection = DriverManager.getConnection("jdbc:sqlite::memory:");
                    break;
                }
                case DURABLE: {
                    File parent;
                    File dbFile = new File(dbPath);
                    if (dbFile.exists()) {
                        dbFile.delete();
                    }
                    if ((parent = dbFile.getParentFile()) != null && !parent.mkdirs() && !parent.exists()) {
                        this.getLogger().error("Unable to create parent directory");
                    }
                    connection = DriverManager.getConnection(String.format("jdbc:sqlite:%s", dbFile.getPath()));
                    break;
                }
                default: {
                    throw new RuntimeException("Characteristic not handled!");
                }
            }
            connection.setAutoCommit(false);
        }
        catch (ClassNotFoundException e) {
            this.getLogger().error(e);
        }
        catch (SQLException e) {
            noPiiExceptionHandler.accept(e);
        }
        this.myConnection = connection;
    }

    public void disconnect() {
        try {
            this.myConnection.commit();
        }
        catch (SQLException e) {
            this.getLogger().error(e);
        }
        finally {
            try {
                if (!this.myConnection.isClosed()) {
                    this.myConnection.close();
                }
            }
            catch (SQLException e) {
                this.getLogger().error(e);
            }
        }
    }

    public Connection getConnection() {
        return this.myConnection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/datastore/DataStoreDatabase";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbPath";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "characteristic";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logService";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "noPiiExceptionHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/datastore/DataStoreDatabase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }

    public static enum Characteristic {
        DURABLE,
        PERFORMANT;

    }
}

