/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.database;

import com.android.tools.datastore.database.DataStoreTable;
import com.android.tools.idea.protobuf.InvalidProtocolBufferException;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profiler.proto.Trace;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class CpuTable
extends DataStoreTable<CpuStatements> {
    private static final int DATA_COLUMN = 1;
    private final Map<Long, Set<Integer>> mySessionThreadIdsCache = Collections.synchronizedMap(new HashMap());

    @Override
    public void initialize(@NotNull Connection connection) {
        if (connection == null) {
            CpuTable.$$$reportNull$$$0(0);
        }
        super.initialize(connection);
        try {
            this.createTable("Cpu_Data", "Session INTEGER NOT NULL", "Timestamp INTEGER NOT NULL", "Data BLOB");
            this.createTable("Thread_Activities", "Session INTEGER NOT NULL", "ThreadId INTEGER NOT NULL", "Timestamp INTEGER NOT NULL", "State TEXT", "Name TEXT", "PRIMARY KEY (Session, ThreadId, Timestamp)");
            this.createTable("Cpu_Trace_Info", "Session INTEGER NOT NULL", "StartTime INTEGER", "EndTime INTEGER", "TraceInfo BLOB");
            this.createUniqueIndex("Cpu_Data", "Session", "Timestamp");
            this.createUniqueIndex("Cpu_Trace_Info", "Session", "StartTime");
            this.createIndex("Thread_Activities", 0, "Session", "ThreadId", "Timestamp");
        }
        catch (SQLException ex) {
            CpuTable.onError(ex);
        }
    }

    @Override
    public void prepareStatements() {
        try {
            this.createStatement(CpuStatements.INSERT_CPU_DATA, "INSERT OR REPLACE INTO Cpu_Data (Session, Timestamp, Data) values (?, ?, ?)");
            this.createStatement(CpuStatements.QUERY_CPU_DATA, "SELECT Data from Cpu_Data WHERE Session = ? AND Timestamp > ? AND Timestamp <= ? ");
            this.createStatement(CpuStatements.QUERY_TRACE_INFO, "SELECT TraceInfo from Cpu_Trace_Info WHERE Session = ? AND (StartTime < ? AND (EndTime >= ? OR EndTime = -1));");
            this.createStatement(CpuStatements.INSERT_TRACE_INFO, "INSERT OR REPLACE INTO Cpu_Trace_Info (Session, StartTime, EndTime, TraceInfo) values (?, ?, ?, ?)");
            this.createStatement(CpuStatements.INSERT_THREAD_ACTIVITY, "INSERT OR REPLACE INTO Thread_Activities (Session, ThreadId, Timestamp, State, Name) VALUES (?, ?, ?, ?, ?)");
            this.createStatement(CpuStatements.QUERY_ALL_DISTINCT_THREADS, "SELECT DISTINCT ThreadId FROM Thread_Activities WHERE Session = ?");
            this.createStatement(CpuStatements.QUERY_THREAD_ACTIVITIES, "SELECT t2.Name, t2.State, ? as ReqStart FROM (SELECT MAX(Timestamp) AS Timestamp       FROM Thread_Activities       WHERE Session = ? AND ThreadId = ? AND Timestamp <= ? ) t1 JOIN Thread_Activities t2 ON (t2.Session = ? AND t2.ThreadId = ? AND t2.timestamp = t1.timestamp AND t2.State <> 'DEAD')UNION ALL SELECT Name, State, Timestamp FROM Thread_Activities WHERE Session = ? AND ThreadId = ? AND Timestamp > ? AND Timestamp <= ?");
        }
        catch (SQLException ex) {
            CpuTable.onError(ex);
        }
    }

    public void insert(Common.Session session, Cpu.CpuUsageData data) {
        this.execute(CpuStatements.INSERT_CPU_DATA, session.getSessionId(), data.getEndTimestamp(), data.toByteArray());
    }

    public List<Cpu.CpuUsageData> getCpuDataByRequest(CpuProfiler.CpuDataRequest request) {
        ArrayList<Cpu.CpuUsageData> cpuData = new ArrayList<Cpu.CpuUsageData>();
        try {
            ResultSet results = this.executeQuery(CpuStatements.QUERY_CPU_DATA, request.getSession().getSessionId(), request.getStartTimestamp(), request.getEndTimestamp());
            while (results.next()) {
                Cpu.CpuUsageData.Builder data = Cpu.CpuUsageData.newBuilder();
                data.mergeFrom(results.getBytes(1));
                cpuData.add(data.build());
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            CpuTable.onError(ex);
        }
        return cpuData;
    }

    public void insertActivities(Common.Session session, int tid, String name, List<CpuProfiler.GetThreadsResponse.ThreadActivity> activities) {
        this.getThreadIdCacheForSession(session.getSessionId()).add(tid);
        for (CpuProfiler.GetThreadsResponse.ThreadActivity activity : activities) {
            this.execute(CpuStatements.INSERT_THREAD_ACTIVITY, session.getSessionId(), tid, activity.getTimestamp(), activity.getNewState().toString(), name);
        }
    }

    public void insertSnapshot(Common.Session session, long timestamp, List<CpuProfiler.GetThreadsResponse.ThreadSnapshot.Snapshot> snapshots) {
        Set<Integer> idSet = this.getThreadIdCacheForSession(session.getSessionId());
        for (CpuProfiler.GetThreadsResponse.ThreadSnapshot.Snapshot snapshot : snapshots) {
            idSet.add(snapshot.getTid());
            this.execute(CpuStatements.INSERT_THREAD_ACTIVITY, session.getSessionId(), snapshot.getTid(), timestamp, snapshot.getState().toString(), snapshot.getName());
        }
    }

    public List<CpuProfiler.GetThreadsResponse.Thread> getThreadsDataByRequest(CpuProfiler.GetThreadsRequest request) {
        TreeMap<Integer, CpuProfiler.GetThreadsResponse.Thread.Builder> threads = new TreeMap<Integer, CpuProfiler.GetThreadsResponse.Thread.Builder>();
        try {
            long sessionId = request.getSession().getSessionId();
            ArrayList<Integer> threadIds = new ArrayList<Integer>();
            if (!this.mySessionThreadIdsCache.containsKey(sessionId)) {
                Set<Integer> tidSet = this.getThreadIdCacheForSession(sessionId);
                ResultSet threadResults = this.executeQuery(CpuStatements.QUERY_ALL_DISTINCT_THREADS, sessionId);
                while (threadResults.next()) {
                    threadIds.add(threadResults.getInt(1));
                }
                tidSet.addAll(threadIds);
            } else {
                this.mySessionThreadIdsCache.get(sessionId).forEach(tid -> threadIds.add((Integer)tid));
            }
            long startTimestamp = request.getStartTimestamp();
            long endTimestamp = request.getEndTimestamp();
            Iterator iterator = threadIds.iterator();
            while (iterator.hasNext()) {
                int tid2 = (Integer)iterator.next();
                ResultSet activities = this.executeQuery(CpuStatements.QUERY_THREAD_ACTIVITIES, startTimestamp, sessionId, tid2, startTimestamp, sessionId, tid2, sessionId, tid2, startTimestamp, endTimestamp);
                CpuProfiler.GetThreadsResponse.Thread.Builder builder = null;
                while (activities.next()) {
                    if (builder == null) {
                        builder = CpuTable.createThreadBuilder(tid2, activities.getString(1));
                        threads.put(tid2, builder);
                    }
                    Cpu.CpuThreadData.State state = Cpu.CpuThreadData.State.valueOf((String)activities.getString(2));
                    CpuProfiler.GetThreadsResponse.ThreadActivity.Builder activity = CpuProfiler.GetThreadsResponse.ThreadActivity.newBuilder().setNewState(state).setTimestamp(activities.getLong(3));
                    builder.addActivities(activity.build());
                }
            }
        }
        catch (SQLException ex) {
            CpuTable.onError(ex);
        }
        ArrayList<CpuProfiler.GetThreadsResponse.Thread> cpuData = new ArrayList<CpuProfiler.GetThreadsResponse.Thread>();
        for (CpuProfiler.GetThreadsResponse.Thread.Builder thread2 : threads.values()) {
            cpuData.add(thread2.build());
        }
        return cpuData;
    }

    public List<Trace.TraceInfo> getTraceInfo(CpuProfiler.GetTraceInfoRequest request) {
        ArrayList<Trace.TraceInfo> traceInfo = new ArrayList<Trace.TraceInfo>();
        try {
            ResultSet results = this.executeQuery(CpuStatements.QUERY_TRACE_INFO, request.getSession().getSessionId(), request.getToTimestamp(), request.getFromTimestamp());
            while (results.next()) {
                byte[] data = results.getBytes(1);
                if (data == null) continue;
                traceInfo.add(Trace.TraceInfo.parseFrom((byte[])data));
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            CpuTable.onError(ex);
        }
        return traceInfo;
    }

    public void insertTraceInfo(Common.Session session, Trace.TraceInfo trace) {
        this.execute(CpuStatements.INSERT_TRACE_INFO, session.getSessionId(), trace.getFromTimestamp(), trace.getToTimestamp(), trace.toByteArray());
    }

    private static CpuProfiler.GetThreadsResponse.Thread.Builder createThreadBuilder(int tid, String name) {
        CpuProfiler.GetThreadsResponse.Thread.Builder thread2 = CpuProfiler.GetThreadsResponse.Thread.newBuilder();
        thread2.setTid(tid);
        thread2.setName(name);
        return thread2;
    }

    @NotNull
    private Set<Integer> getThreadIdCacheForSession(long sessionId) {
        Set set = this.mySessionThreadIdsCache.computeIfAbsent(sessionId, id -> Collections.synchronizedSet(new HashSet()));
        if (set == null) {
            CpuTable.$$$reportNull$$$0(1);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/datastore/database/CpuTable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/datastore/database/CpuTable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadIdCacheForSession";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initialize";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static enum CpuStatements {
        INSERT_THREAD_ACTIVITY,
        QUERY_ALL_DISTINCT_THREADS,
        QUERY_THREAD_ACTIVITIES,
        INSERT_CPU_DATA,
        QUERY_CPU_DATA,
        QUERY_TRACE_INFO,
        INSERT_TRACE_INFO;

    }
}

