/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.database;

import com.android.tools.datastore.LogService;
import com.android.tools.datastore.database.DataStoreTable;
import com.android.tools.idea.protobuf.InvalidProtocolBufferException;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profiler.proto.MemoryProfiler;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class MemoryLiveAllocationTable
extends DataStoreTable<MemoryStatements> {
    @NotNull
    private final LogService myLogService;

    @NotNull
    private LogService.Logger getLogger() {
        LogService.Logger logger = this.myLogService.getLogger(MemoryLiveAllocationTable.class);
        if (logger == null) {
            MemoryLiveAllocationTable.$$$reportNull$$$0(0);
        }
        return logger;
    }

    public MemoryLiveAllocationTable(@NotNull LogService logService) {
        if (logService == null) {
            MemoryLiveAllocationTable.$$$reportNull$$$0(1);
        }
        this.myLogService = logService;
    }

    @Override
    public void initialize(@NotNull Connection connection) {
        if (connection == null) {
            MemoryLiveAllocationTable.$$$reportNull$$$0(2);
        }
        super.initialize(connection);
        try {
            this.createTable("Memory_AllocationContexts", "Session INTEGER NOT NULL", "Timestamp INTEGER", "Data BLOB", "PRIMARY KEY(Session, Timestamp)");
            this.createTable("Memory_AllocationEvents", "Session INTEGER NOT NULL", "Timestamp INTEGER", "Data BLOB", "PRIMARY KEY(Session, Timestamp)");
            this.createTable("Memory_JniGlobalReferences", "Session INTEGER NOT NULL", "Timestamp INTEGER", "Data BLOB", "PRIMARY KEY(Session, Timestamp)");
            this.createTable("Memory_AllocationSamplingRateEvent", "Session INTEGER NOT NULL", "Timestamp INTEGER", "Data BLOB", "PRIMARY KEY(Session, Timestamp)");
        }
        catch (SQLException ex) {
            MemoryLiveAllocationTable.onError(ex);
        }
    }

    @Override
    public void prepareStatements() {
        try {
            for (MemoryStatements statement : MemoryStatements.values()) {
                this.createStatement(statement, statement.getStatement());
            }
        }
        catch (SQLException ex) {
            MemoryLiveAllocationTable.onError(ex);
        }
    }

    public List<Memory.BatchAllocationEvents> getAllocationEvents(Common.Session session, long startTime, long endTime) {
        ArrayList<Memory.BatchAllocationEvents> results = new ArrayList<Memory.BatchAllocationEvents>();
        try {
            ResultSet resultSet = this.executeQuery(MemoryStatements.QUERY_ALLOC_EVENTS, session.getSessionId(), startTime, endTime);
            while (resultSet.next()) {
                results.add(((Memory.BatchAllocationEvents.Builder)Memory.BatchAllocationEvents.newBuilder().mergeFrom(resultSet.getBytes(1))).build());
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            MemoryLiveAllocationTable.onError(ex);
        }
        return results;
    }

    @NotNull
    public List<Memory.BatchAllocationContexts> getAllocationContexts(Common.Session session, long startTime, long endTime) {
        ArrayList<Memory.BatchAllocationContexts> results = new ArrayList<Memory.BatchAllocationContexts>();
        try {
            ResultSet resultSet = this.executeQuery(MemoryStatements.QUERY_ALLOC_CONTEXTS, session.getSessionId(), startTime, endTime);
            while (resultSet.next()) {
                results.add(((Memory.BatchAllocationContexts.Builder)Memory.BatchAllocationContexts.newBuilder().mergeFrom(resultSet.getBytes(1))).build());
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            MemoryLiveAllocationTable.onError(ex);
        }
        ArrayList<Memory.BatchAllocationContexts> arrayList = results;
        if (arrayList == null) {
            MemoryLiveAllocationTable.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static Memory.JNIGlobalReferenceEvent readJniEventFromResultSet(ResultSet resultset, Memory.JNIGlobalReferenceEvent.Type type) throws SQLException {
        int objectTag = resultset.getInt("Tag");
        long refValue = resultset.getLong("RefValue");
        long timestamp = resultset.getLong("Timestamp");
        int threadId = resultset.getInt("ThreadId");
        byte[] backtrace = resultset.getBytes("Backtrace");
        Memory.JNIGlobalReferenceEvent.Builder event = Memory.JNIGlobalReferenceEvent.newBuilder();
        event.setEventType(type);
        event.setObjectTag(objectTag);
        event.setRefValue(refValue);
        event.setTimestamp(timestamp);
        event.setThreadId(threadId);
        if (backtrace != null && backtrace.length != 0) {
            try {
                event.setBacktrace(Memory.NativeBacktrace.parseFrom((byte[])backtrace));
            }
            catch (InvalidProtocolBufferException ex) {
                MemoryLiveAllocationTable.onError(ex);
            }
        }
        return event.build();
    }

    public List<Memory.BatchJNIGlobalRefEvent> getJniReferenceEvents(Common.Session session, long startTime, long endTime) {
        ArrayList<Memory.BatchJNIGlobalRefEvent> results = new ArrayList<Memory.BatchJNIGlobalRefEvent>();
        try {
            ResultSet resultSet = this.executeQuery(MemoryStatements.QUERY_JNI_EVENTS, session.getSessionId(), startTime, endTime);
            while (resultSet.next()) {
                results.add(((Memory.BatchJNIGlobalRefEvent.Builder)Memory.BatchJNIGlobalRefEvent.newBuilder().mergeFrom(resultSet.getBytes(1))).build());
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            MemoryLiveAllocationTable.onError(ex);
        }
        return results;
    }

    public void insertJniReferenceData(@NotNull Common.Session session, @NotNull Memory.BatchJNIGlobalRefEvent sample) {
        if (session == null) {
            MemoryLiveAllocationTable.$$$reportNull$$$0(4);
        }
        if (sample == null) {
            MemoryLiveAllocationTable.$$$reportNull$$$0(5);
        }
        this.execute(MemoryStatements.INSERT_JNI_REF, session.getSessionId(), sample.getTimestamp(), sample.toByteArray());
    }

    public void insertAllocationContexts(Common.Session session, Memory.BatchAllocationContexts sample) {
        Memory.BatchAllocationContexts.Builder convertedSampleBuilder = sample.toBuilder();
        List classes = convertedSampleBuilder.getClassesList();
        convertedSampleBuilder.clearClasses();
        List convertedClasses = classes.stream().map(klass -> klass.toBuilder().setClassName(MemoryLiveAllocationTable.jniToJavaName(klass.getClassName())).build()).collect(Collectors.toList());
        convertedSampleBuilder.addAllClasses(convertedClasses);
        this.execute(MemoryStatements.INSERT_ALLOC_CONTEXTS, session.getSessionId(), sample.getTimestamp(), convertedSampleBuilder.build().toByteArray());
    }

    public void insertAllocationEvents(Common.Session session, Memory.BatchAllocationEvents sample) {
        this.execute(MemoryStatements.INSERT_ALLOC_EVENTS, session.getSessionId(), sample.getTimestamp(), sample.toByteArray());
    }

    public void insertOrReplaceAllocationSamplingRateEvent(@NotNull Common.Session session, @NotNull MemoryProfiler.AllocationSamplingRateEvent event) {
        if (session == null) {
            MemoryLiveAllocationTable.$$$reportNull$$$0(6);
        }
        if (event == null) {
            MemoryLiveAllocationTable.$$$reportNull$$$0(7);
        }
        this.execute(MemoryStatements.INSERT_OR_REPLACE_ALLOCATION_SAMPLING_RATE_EVENT, session.getSessionId(), event.getTimestamp(), event.toByteArray());
    }

    @NotNull
    public List<MemoryProfiler.AllocationSamplingRateEvent> getAllocationSamplingRateEvents(long sessionId, long startTime, long endTime) {
        ArrayList<MemoryProfiler.AllocationSamplingRateEvent> results = new ArrayList<MemoryProfiler.AllocationSamplingRateEvent>();
        try {
            ResultSet resultSet = this.executeQuery(MemoryStatements.QUERY_ALLOCATION_SAMPLING_RATE_EVENTS_BY_TIME, sessionId, startTime, endTime);
            while (resultSet.next()) {
                results.add(((MemoryProfiler.AllocationSamplingRateEvent.Builder)MemoryProfiler.AllocationSamplingRateEvent.newBuilder().mergeFrom(resultSet.getBytes(1))).build());
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            MemoryLiveAllocationTable.onError(ex);
        }
        ArrayList<MemoryProfiler.AllocationSamplingRateEvent> arrayList = results;
        if (arrayList == null) {
            MemoryLiveAllocationTable.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static String jniToJavaName(String jniName) {
        Object javaName;
        if (jniName.isEmpty()) {
            return jniName;
        }
        int arrayDimension = 0;
        int classNameIndex = 0;
        while (jniName.charAt(classNameIndex) == '[') {
            ++arrayDimension;
            ++classNameIndex;
        }
        if (jniName.charAt(classNameIndex) == 'L') {
            javaName = jniName.substring(classNameIndex + 1, jniName.length() - 1).replace('/', '.');
        } else {
            javaName = jniName.substring(classNameIndex);
            switch (javaName) {
                case "Z": {
                    javaName = "boolean";
                    break;
                }
                case "B": {
                    javaName = "byte";
                    break;
                }
                case "C": {
                    javaName = "char";
                    break;
                }
                case "S": {
                    javaName = "short";
                    break;
                }
                case "I": {
                    javaName = "int";
                    break;
                }
                case "J": {
                    javaName = "long";
                    break;
                }
                case "F": {
                    javaName = "float";
                    break;
                }
                case "D": {
                    javaName = "double";
                    break;
                }
            }
        }
        while (arrayDimension > 0) {
            javaName = (String)javaName + "[]";
            --arrayDimension;
        }
        return javaName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/datastore/database/MemoryLiveAllocationTable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logService";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sample";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/datastore/database/MemoryLiveAllocationTable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllocationContexts";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllocationSamplingRateEvents";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "initialize";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "insertJniReferenceData";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "insertOrReplaceAllocationSamplingRateEvent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }

    public static enum MemoryStatements {
        INSERT_ALLOC_CONTEXTS("INSERT OR IGNORE INTO Memory_AllocationContexts (Session, Timestamp, Data) VALUES (?, ?, ?)"),
        INSERT_ALLOC_EVENTS("INSERT OR IGNORE INTO Memory_AllocationEvents (Session, Timestamp, Data) VALUES (?, ?, ?)"),
        QUERY_ALLOC_CONTEXTS("SELECT Data FROM Memory_AllocationContexts WHERE Session = ? AND Timestamp > ? AND Timestamp <= ? ORDER BY Timestamp ASC"),
        QUERY_ALLOC_EVENTS("SELECT Data FROM Memory_AllocationEvents WHERE Session = ? AND Timestamp > ? AND Timestamp <= ? ORDER BY Timestamp ASC"),
        INSERT_JNI_REF("INSERT OR IGNORE INTO Memory_JniGlobalReferences (Session, Timestamp, Data) VALUES (?, ?, ?)"),
        QUERY_JNI_EVENTS("SELECT Data FROM Memory_JniGlobalReferences WHERE Session = ? AND Timestamp > ? AND Timestamp <= ? ORDER BY Timestamp ASC"),
        INSERT_OR_REPLACE_ALLOCATION_SAMPLING_RATE_EVENT("INSERT OR REPLACE INTO Memory_AllocationSamplingRateEvent (Session, Timestamp, Data) VALUES (?, ?, ?)"),
        QUERY_ALLOCATION_SAMPLING_RATE_EVENTS_BY_TIME("SELECT Data FROM Memory_AllocationSamplingRateEvent WHERE Session = ? AND Timestamp > ? AND Timestamp <= ? ORDER BY Timestamp ASC");

        @NotNull
        private final String mySqlStatement;

        private MemoryStatements(String sqlStatement) {
            if (sqlStatement == null) {
                MemoryStatements.$$$reportNull$$$0(0);
            }
            this.mySqlStatement = sqlStatement;
        }

        @NotNull
        public String getStatement() {
            String string = this.mySqlStatement;
            if (string == null) {
                MemoryStatements.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sqlStatement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/datastore/database/MemoryLiveAllocationTable$MemoryStatements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/datastore/database/MemoryLiveAllocationTable$MemoryStatements";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

