/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.database;

import com.android.tools.datastore.database.DataStoreTable;
import com.android.tools.idea.protobuf.GeneratedMessageV3;
import com.android.tools.idea.protobuf.InvalidProtocolBufferException;
import com.android.tools.idea.protobuf.Message;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profiler.proto.MemoryProfiler;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryStatsTable
extends DataStoreTable<MemoryStatements> {
    @Override
    public void initialize(@NotNull Connection connection) {
        if (connection == null) {
            MemoryStatsTable.$$$reportNull$$$0(0);
        }
        super.initialize(connection);
        try {
            this.createTable("Memory_Samples", "Session INTEGER NOT NULL", "Timestamp INTEGER", "Type INTEGER", "Data BLOB", "PRIMARY KEY(Session, Timestamp, Type)");
            this.createTable("Memory_AllocationInfo", "Session INTEGER NOT NULL", "StartTime INTEGER", "EndTime INTEGER", "InfoData BLOB", "LegacyEventsData BLOB", "PRIMARY KEY(Session, StartTime)");
            this.createTable("Memory_HeapDump", "Session INTEGER NOT NULL", "StartTime INTEGER", "EndTime INTEGER", "InfoData BLOB", "PRIMARY KEY(Session, StartTime)");
        }
        catch (SQLException ex) {
            MemoryStatsTable.onError(ex);
        }
    }

    @Override
    public void prepareStatements() {
        try {
            for (MemoryStatements statement : MemoryStatements.values()) {
                this.createStatement(statement, statement.getStatement());
            }
        }
        catch (SQLException ex) {
            MemoryStatsTable.onError(ex);
        }
    }

    @NotNull
    public MemoryProfiler.MemoryData getData(@NotNull MemoryProfiler.MemoryRequest request) {
        if (request == null) {
            MemoryStatsTable.$$$reportNull$$$0(1);
        }
        long sessionId = request.getSession().getSessionId();
        long startTime = request.getStartTime();
        long endTime = request.getEndTime();
        List<MemoryProfiler.MemoryData.MemorySample> memorySamples = this.getResultsInfo(MemoryStatements.QUERY_MEMORY, sessionId, startTime, endTime, MemoryProfiler.MemoryData.MemorySample.getDefaultInstance());
        List<MemoryProfiler.MemoryData.AllocStatsSample> allocStatsSamples = this.getResultsInfo(MemoryStatements.QUERY_ALLOC_STATS, sessionId, startTime, endTime, MemoryProfiler.MemoryData.AllocStatsSample.getDefaultInstance());
        List<MemoryProfiler.MemoryData.GcStatsSample> gcStatsSamples = this.getResultsInfo(MemoryStatements.QUERY_GC_STATS, sessionId, startTime, endTime, MemoryProfiler.MemoryData.GcStatsSample.getDefaultInstance());
        List<Memory.HeapDumpInfo> heapDumpSamples = this.getResultsInfo(MemoryStatements.QUERY_HEAP_INFO_BY_TIME, sessionId, startTime, endTime, Memory.HeapDumpInfo.getDefaultInstance());
        List<Memory.AllocationsInfo> allocationSamples = this.getResultsInfo(MemoryStatements.QUERY_ALLOCATION_INFO_BY_TIME, sessionId, startTime, endTime, Memory.AllocationsInfo.getDefaultInstance());
        MemoryProfiler.MemoryData memoryData = MemoryProfiler.MemoryData.newBuilder().addAllMemSamples(memorySamples).addAllAllocStatsSamples(allocStatsSamples).addAllGcStatsSamples(gcStatsSamples).addAllHeapDumpInfos(heapDumpSamples).addAllAllocationsInfo(allocationSamples).build();
        if (memoryData == null) {
            MemoryStatsTable.$$$reportNull$$$0(2);
        }
        return memoryData;
    }

    public void insertMemory(@NotNull Common.Session session, @NotNull List<MemoryProfiler.MemoryData.MemorySample> samples) {
        if (session == null) {
            MemoryStatsTable.$$$reportNull$$$0(3);
        }
        if (samples == null) {
            MemoryStatsTable.$$$reportNull$$$0(4);
        }
        for (MemoryProfiler.MemoryData.MemorySample sample : samples) {
            this.execute(MemoryStatements.INSERT_SAMPLE, session.getSessionId(), sample.getTimestamp(), MemorySamplesType.MEMORY.ordinal(), sample.toByteArray());
        }
    }

    public void insertAllocStats(@NotNull Common.Session session, @NotNull List<MemoryProfiler.MemoryData.AllocStatsSample> samples) {
        if (session == null) {
            MemoryStatsTable.$$$reportNull$$$0(5);
        }
        if (samples == null) {
            MemoryStatsTable.$$$reportNull$$$0(6);
        }
        for (MemoryProfiler.MemoryData.AllocStatsSample sample : samples) {
            this.execute(MemoryStatements.INSERT_SAMPLE, session.getSessionId(), sample.getTimestamp(), MemorySamplesType.ALLOC_STATS.ordinal(), sample.toByteArray());
        }
    }

    public void insertGcStats(@NotNull Common.Session session, @NotNull List<MemoryProfiler.MemoryData.GcStatsSample> samples) {
        if (session == null) {
            MemoryStatsTable.$$$reportNull$$$0(7);
        }
        if (samples == null) {
            MemoryStatsTable.$$$reportNull$$$0(8);
        }
        for (MemoryProfiler.MemoryData.GcStatsSample sample : samples) {
            this.execute(MemoryStatements.INSERT_SAMPLE, session.getSessionId(), sample.getStartTime(), MemorySamplesType.GC_STATS.ordinal(), sample.toByteArray());
        }
    }

    public void insertOrReplaceHeapInfo(@NotNull Common.Session session, @NotNull Memory.HeapDumpInfo info) {
        if (session == null) {
            MemoryStatsTable.$$$reportNull$$$0(9);
        }
        if (info == null) {
            MemoryStatsTable.$$$reportNull$$$0(10);
        }
        this.execute(MemoryStatements.INSERT_OR_REPLACE_HEAP_INFO, session.getSessionId(), info.getStartTime(), info.getEndTime(), info.toByteArray());
    }

    public List<Memory.HeapDumpInfo> getHeapDumpInfoByRequest(@NotNull Common.Session session, @NotNull MemoryProfiler.ListDumpInfosRequest request) {
        if (session == null) {
            MemoryStatsTable.$$$reportNull$$$0(11);
        }
        if (request == null) {
            MemoryStatsTable.$$$reportNull$$$0(12);
        }
        return this.getResultsInfo(MemoryStatements.QUERY_HEAP_INFO_BY_TIME, session.getSessionId(), request.getStartTime(), request.getEndTime(), Memory.HeapDumpInfo.getDefaultInstance());
    }

    public void insertOrReplaceAllocationsInfo(@NotNull Common.Session session, @NotNull Memory.AllocationsInfo info) {
        if (session == null) {
            MemoryStatsTable.$$$reportNull$$$0(13);
        }
        if (info == null) {
            MemoryStatsTable.$$$reportNull$$$0(14);
        }
        this.execute(MemoryStatements.INSERT_OR_REPLACE_ALLOCATIONS_INFO, session.getSessionId(), info.getStartTime(), info.getEndTime(), info.toByteArray());
    }

    @Nullable
    public Memory.AllocationsInfo getAllocationsInfo(@NotNull Common.Session session, long trackingStartTime) {
        if (session == null) {
            MemoryStatsTable.$$$reportNull$$$0(15);
        }
        try {
            byte[] bytes;
            ResultSet results = this.executeQuery(MemoryStatements.QUERY_ALLOCATION_INFO_BY_ID, session.getSessionId(), trackingStartTime);
            if (results.next() && (bytes = results.getBytes(1)) != null) {
                return Memory.AllocationsInfo.parseFrom((byte[])bytes);
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            MemoryStatsTable.onError(ex);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private <T extends GeneratedMessageV3> List<T> getResultsInfo(@NotNull MemoryStatements query, long sessionId, long startTime, long l, @NotNull T t) {
        if (query == null) {
            MemoryStatsTable.$$$reportNull$$$0(16);
        }
        if (t == null) {
            MemoryStatsTable.$$$reportNull$$$0(17);
        }
        ArrayList<GeneratedMessageV3> datas = new ArrayList<GeneratedMessageV3>();
        try {
            void endTime;
            ResultSet resultSet = this.executeQuery(query, sessionId, startTime, (long)endTime);
            while (resultSet.next()) {
                void defaultInstance;
                Message data = defaultInstance.toBuilder().mergeFrom(resultSet.getBytes(1)).build();
                datas.add((GeneratedMessageV3)data);
            }
        }
        catch (InvalidProtocolBufferException | ClassCastException | SQLException ex) {
            MemoryStatsTable.onError(ex);
        }
        return datas;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/datastore/database/MemoryStatsTable";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "samples";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/datastore/database/MemoryStatsTable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initialize";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "insertMemory";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "insertAllocStats";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "insertGcStats";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "insertOrReplaceHeapInfo";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getHeapDumpInfoByRequest";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "insertOrReplaceAllocationsInfo";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getAllocationsInfo";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getResultsInfo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static enum MemoryStatements {
        INSERT_SAMPLE("INSERT OR IGNORE INTO Memory_Samples (Session, Timestamp, Type, Data) VALUES (?, ?, ?, ?)"),
        QUERY_MEMORY(String.format(Locale.US, "SELECT Data FROM Memory_Samples WHERE Session = ? AND Type = %d AND TimeStamp > ? AND TimeStamp <= ?", MemorySamplesType.MEMORY.ordinal())),
        QUERY_ALLOC_STATS(String.format(Locale.US, "SELECT Data FROM Memory_Samples WHERE Session = ? AND Type = %d AND TimeStamp > ? AND TimeStamp <= ?", MemorySamplesType.ALLOC_STATS.ordinal())),
        QUERY_GC_STATS(String.format(Locale.US, "SELECT Data FROM Memory_Samples WHERE Session = ? AND Type = %d AND TimeStamp > ? AND TimeStamp <= ?", MemorySamplesType.GC_STATS.ordinal())),
        INSERT_OR_REPLACE_HEAP_INFO("INSERT OR REPLACE INTO Memory_HeapDump (Session, StartTime, EndTime, InfoData) VALUES (?, ?, ?, ?)"),
        QUERY_HEAP_INFO_BY_TIME("SELECT InfoData FROM Memory_HeapDump where Session = ? AND EndTime > ? AND StartTime <= ?"),
        INSERT_OR_REPLACE_ALLOCATIONS_INFO("INSERT OR REPLACE INTO Memory_AllocationInfo (Session, StartTime, EndTime, InfoData) VALUES (?, ?, ?, ?)"),
        UPDATE_LEGACY_ALLOCATIONS_INFO_EVENTS("UPDATE Memory_AllocationInfo SET LegacyEventsData = ? WHERE Session = ? AND StartTime = ?"),
        QUERY_ALLOCATION_INFO_BY_TIME("SELECT InfoData FROM Memory_AllocationInfo WHERE Session = ? AND EndTime > ? AND StartTime <= ?"),
        QUERY_ALLOCATION_INFO_BY_ID("SELECT InfoData from Memory_AllocationInfo WHERE Session = ? AND StartTime = ?");

        @NotNull
        private final String mySqlStatement;

        private MemoryStatements(String sqlStatement) {
            if (sqlStatement == null) {
                MemoryStatements.$$$reportNull$$$0(0);
            }
            this.mySqlStatement = sqlStatement;
        }

        @NotNull
        public String getStatement() {
            String string = this.mySqlStatement;
            if (string == null) {
                MemoryStatements.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sqlStatement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/datastore/database/MemoryStatsTable$MemoryStatements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/datastore/database/MemoryStatsTable$MemoryStatements";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static enum MemorySamplesType {
        MEMORY,
        ALLOC_STATS,
        GC_STATS;

    }
}

