/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.database;

import com.android.tools.datastore.database.DataStoreTable;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Profiler;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;

public class ProfilerTable
extends DataStoreTable<ProfilerStatements> {
    @Override
    public void initialize(@NotNull Connection connection) {
        if (connection == null) {
            ProfilerTable.$$$reportNull$$$0(0);
        }
        super.initialize(connection);
        try {
            this.createTable("Profiler_Sessions", "SessionId INTEGER", "DeviceId INTEGER", "ProcessId INTEGER", "StartTime INTEGER", "EndTime INTEGER", "StartTimeEpochMs INTEGER", "Name TEXT", "ProcessAbi TEXT", "JvmtiEnabled INTEGER", "TypeId INTEGER");
            this.createUniqueIndex("Profiler_Sessions", "SessionId");
        }
        catch (SQLException ex) {
            ProfilerTable.onError(ex);
        }
    }

    @Override
    public void prepareStatements() {
        try {
            this.createStatement(ProfilerStatements.INSERT_SESSION, "INSERT OR REPLACE INTO Profiler_Sessions (SessionId, DeviceId, ProcessId, StartTime, EndTime, StartTimeEpochMs, Name, ProcessAbi, JvmtiEnabled, TypeId) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            this.createStatement(ProfilerStatements.UPDATE_SESSION, "UPDATE Profiler_Sessions Set EndTime = ? WHERE SessionId = ?");
            this.createStatement(ProfilerStatements.SELECT_SESSIONS, "SELECT * from Profiler_Sessions ORDER BY SessionId ASC");
            this.createStatement(ProfilerStatements.SELECT_SESSION_BY_ID, "SELECT * from Profiler_Sessions WHERE SessionId = ?");
            this.createStatement(ProfilerStatements.DELETE_SESSION_BY_ID, "DELETE from Profiler_Sessions WHERE SessionId = ?");
        }
        catch (SQLException ex) {
            ProfilerTable.onError(ex);
        }
    }

    @NotNull
    public Common.Session getSessionById(long sessionId) {
        if (this.isClosed()) {
            Common.Session session = Common.Session.getDefaultInstance();
            if (session == null) {
                ProfilerTable.$$$reportNull$$$0(1);
            }
            return session;
        }
        Common.Session.Builder builder = Common.Session.newBuilder();
        try {
            ResultSet results = this.executeQuery(ProfilerStatements.SELECT_SESSION_BY_ID, sessionId);
            if (results.next()) {
                builder.setSessionId(results.getLong(1)).setStreamId(results.getLong(2)).setPid(results.getInt(3)).setStartTimestamp(results.getLong(4)).setEndTimestamp(results.getLong(5));
            }
        }
        catch (SQLException ex) {
            ProfilerTable.onError(ex);
        }
        Common.Session session = builder.build();
        if (session == null) {
            ProfilerTable.$$$reportNull$$$0(2);
        }
        return session;
    }

    @NotNull
    public Profiler.GetSessionMetaDataResponse getSessionMetaData(long sessionId) {
        if (this.isClosed()) {
            Profiler.GetSessionMetaDataResponse getSessionMetaDataResponse = Profiler.GetSessionMetaDataResponse.getDefaultInstance();
            if (getSessionMetaDataResponse == null) {
                ProfilerTable.$$$reportNull$$$0(3);
            }
            return getSessionMetaDataResponse;
        }
        Profiler.GetSessionMetaDataResponse.Builder responseBuilder = Profiler.GetSessionMetaDataResponse.newBuilder();
        try {
            ResultSet results = this.executeQuery(ProfilerStatements.SELECT_SESSION_BY_ID, sessionId);
            while (results.next()) {
                responseBuilder.setData(Common.SessionMetaData.newBuilder().setSessionId(results.getLong(1)).setStartTimestampEpochMs(results.getLong(6)).setSessionName(results.getString(7)).setProcessAbi(results.getString(8)).setJvmtiEnabled(results.getBoolean(9)).setType(Common.SessionMetaData.SessionType.forNumber((int)results.getInt(10))).build());
            }
        }
        catch (SQLException ex) {
            ProfilerTable.onError(ex);
        }
        Profiler.GetSessionMetaDataResponse getSessionMetaDataResponse = responseBuilder.build();
        if (getSessionMetaDataResponse == null) {
            ProfilerTable.$$$reportNull$$$0(4);
        }
        return getSessionMetaDataResponse;
    }

    @NotNull
    public Profiler.GetSessionsResponse getSessions() {
        if (this.isClosed()) {
            Profiler.GetSessionsResponse getSessionsResponse = Profiler.GetSessionsResponse.getDefaultInstance();
            if (getSessionsResponse == null) {
                ProfilerTable.$$$reportNull$$$0(5);
            }
            return getSessionsResponse;
        }
        Profiler.GetSessionsResponse.Builder responseBuilder = Profiler.GetSessionsResponse.newBuilder();
        try {
            ResultSet results = this.executeQuery(ProfilerStatements.SELECT_SESSIONS, new Object[0]);
            while (results.next()) {
                responseBuilder.addSessions(Common.Session.newBuilder().setSessionId(results.getLong(1)).setStreamId(results.getLong(2)).setPid(results.getInt(3)).setStartTimestamp(results.getLong(4)).setEndTimestamp(results.getLong(5)).build());
            }
        }
        catch (SQLException ex) {
            ProfilerTable.onError(ex);
        }
        Profiler.GetSessionsResponse getSessionsResponse = responseBuilder.build();
        if (getSessionsResponse == null) {
            ProfilerTable.$$$reportNull$$$0(6);
        }
        return getSessionsResponse;
    }

    public void deleteSession(long sessionId) {
        this.execute(ProfilerStatements.DELETE_SESSION_BY_ID, sessionId);
    }

    /*
     * WARNING - void declaration
     */
    public void insertOrUpdateSession(@NotNull Common.Session session, @NotNull String name, long startTimeUtc, String processAbi, boolean jvmtiEnabled, Common.SessionMetaData.SessionType sessionType) {
        void sessionType2;
        if (session == null) {
            ProfilerTable.$$$reportNull$$$0(7);
        }
        if (name == null) {
            ProfilerTable.$$$reportNull$$$0(8);
        }
        this.execute(ProfilerStatements.INSERT_SESSION, session.getSessionId(), session.getStreamId(), session.getPid(), session.getStartTimestamp(), session.getEndTimestamp(), startTimeUtc, name, processAbi, jvmtiEnabled, sessionType2.getNumber());
    }

    public void updateSessionEndTime(long sessionId, long endTimestampNs) {
        this.execute(ProfilerStatements.UPDATE_SESSION, endTimestampNs, sessionId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/datastore/database/ProfilerTable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/datastore/database/ProfilerTable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessionById";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessionMetaData";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initialize";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "insertOrUpdateSession";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }

    public static enum ProfilerStatements {
        INSERT_SESSION,
        UPDATE_SESSION,
        SELECT_SESSIONS,
        SELECT_SESSION_BY_ID,
        DELETE_SESSION_BY_ID;

    }
}

