/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.poller;

import com.android.tools.datastore.DataStoreService;
import com.android.tools.datastore.database.DataStoreTable;
import com.android.tools.datastore.database.UnifiedEventsTable;
import com.android.tools.idea.io.grpc.StatusRuntimeException;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class UnifiedEventsDataPoller
implements Runnable,
DataStoreTable.DataStoreTableErrorCallback {
    private final long myStreamId;
    @NotNull
    private final UnifiedEventsTable myTable;
    @NotNull
    private final TransportServiceGrpc.TransportServiceBlockingStub myEventPollingService;
    @NotNull
    private final DataStoreService myDataStoreService;
    @NotNull
    private final CountDownLatch myRunningLatch;
    @NotNull
    private final AtomicBoolean myIsRunning;

    /*
     * WARNING - void declaration
     */
    public UnifiedEventsDataPoller(long streamId, @NotNull UnifiedEventsTable unifiedEventsTable, @NotNull TransportServiceGrpc.TransportServiceBlockingStub pollingService, @NotNull DataStoreService dataStoreService) {
        void dataStoreService2;
        if (unifiedEventsTable == null) {
            UnifiedEventsDataPoller.$$$reportNull$$$0(0);
        }
        if (pollingService == null) {
            UnifiedEventsDataPoller.$$$reportNull$$$0(1);
        }
        if (dataStoreService == null) {
            UnifiedEventsDataPoller.$$$reportNull$$$0(2);
        }
        this.myIsRunning = new AtomicBoolean(false);
        this.myEventPollingService = pollingService;
        this.myDataStoreService = dataStoreService2;
        this.myStreamId = streamId;
        this.myTable = unifiedEventsTable;
        this.myRunningLatch = new CountDownLatch(1);
    }

    @Override
    public void onDataStoreError(Throwable t) {
        this.myDataStoreService.disconnect(this.myStreamId);
    }

    public void stop() {
        try {
            if (this.myIsRunning.get()) {
                this.myRunningLatch.await();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        this.myIsRunning.set(true);
        try {
            Iterator events = this.myEventPollingService.getEvents(Transport.GetEventsRequest.getDefaultInstance());
            while (events.hasNext()) {
                Common.Event event = (Common.Event)events.next();
                if (event == null) continue;
                this.myTable.insertUnifiedEvent(this.myStreamId, event);
            }
        }
        catch (StatusRuntimeException statusRuntimeException) {
            // empty catch block
        }
        this.myRunningLatch.countDown();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "unifiedEventsTable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "pollingService";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "dataStoreService";
                break;
            }
        }
        objectArray[1] = "com/android/tools/datastore/poller/UnifiedEventsDataPoller";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

