/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.service;

import com.android.tools.datastore.DataStoreService;
import com.android.tools.datastore.LogService;
import com.android.tools.datastore.ServicePassThrough;
import com.android.tools.datastore.database.CpuTable;
import com.android.tools.datastore.poller.CpuDataPoller;
import com.android.tools.datastore.poller.PollRunner;
import com.android.tools.datastore.service.ResponseData;
import com.android.tools.idea.io.grpc.stub.StreamObserver;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profiler.proto.CpuServiceGrpc;
import com.android.tools.profiler.proto.Trace;
import java.sql.Connection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class CpuService
extends CpuServiceGrpc.CpuServiceImplBase
implements ServicePassThrough {
    private final Map<Long, PollRunner> myRunners;
    private final Consumer<Runnable> myFetchExecutor;
    @NotNull
    private final CpuTable myCpuTable;
    @NotNull
    private final DataStoreService myService;
    @NotNull
    private final LogService myLogService;
    private ResponseData<CpuProfiler.CpuDataResponse> myLastCpuResponse;
    private ResponseData<CpuProfiler.GetThreadsResponse> myLastThreadsResponse;
    private ResponseData<CpuProfiler.GetTraceInfoResponse> myLastTraceInfoResponse;

    public CpuService(@NotNull DataStoreService dataStoreService, Consumer<Runnable> fetchExecutor, LogService logService) {
        if (dataStoreService == null) {
            CpuService.$$$reportNull$$$0(0);
        }
        this.myRunners = new HashMap<Long, PollRunner>();
        this.myLastCpuResponse = ResponseData.createEmpty();
        this.myLastThreadsResponse = ResponseData.createEmpty();
        this.myLastTraceInfoResponse = ResponseData.createEmpty();
        this.myFetchExecutor = fetchExecutor;
        this.myService = dataStoreService;
        this.myLogService = logService;
        this.myCpuTable = new CpuTable();
    }

    public void getData(CpuProfiler.CpuDataRequest request, StreamObserver<CpuProfiler.CpuDataResponse> observer) {
        if (!this.myLastCpuResponse.matches(request.getSession(), request.getStartTimestamp(), request.getEndTimestamp())) {
            CpuProfiler.CpuDataResponse.Builder response = CpuProfiler.CpuDataResponse.newBuilder();
            List<Cpu.CpuUsageData> cpuData = this.myCpuTable.getCpuDataByRequest(request);
            for (Cpu.CpuUsageData data : cpuData) {
                response.addData(data);
            }
            this.myLastCpuResponse = new ResponseData<CpuProfiler.CpuDataResponse>(request.getSession(), request.getStartTimestamp(), request.getEndTimestamp(), response.build());
        }
        observer.onNext((Object)this.myLastCpuResponse.getResponse());
        observer.onCompleted();
    }

    public void getThreads(CpuProfiler.GetThreadsRequest request, StreamObserver<CpuProfiler.GetThreadsResponse> observer) {
        if (!this.myLastThreadsResponse.matches(request.getSession(), request.getStartTimestamp(), request.getEndTimestamp())) {
            CpuProfiler.GetThreadsResponse.Builder response = CpuProfiler.GetThreadsResponse.newBuilder();
            response.addAllThreads(this.myCpuTable.getThreadsDataByRequest(request));
            this.myLastThreadsResponse = new ResponseData<CpuProfiler.GetThreadsResponse>(request.getSession(), request.getStartTimestamp(), request.getEndTimestamp(), response.build());
        }
        observer.onNext((Object)this.myLastThreadsResponse.getResponse());
        observer.onCompleted();
    }

    public void getTraceInfo(CpuProfiler.GetTraceInfoRequest request, StreamObserver<CpuProfiler.GetTraceInfoResponse> responseObserver) {
        if (!this.myLastTraceInfoResponse.matches(request.getSession(), request.getFromTimestamp(), request.getToTimestamp())) {
            CpuProfiler.GetTraceInfoResponse.Builder response = CpuProfiler.GetTraceInfoResponse.newBuilder();
            List<Trace.TraceInfo> responses = this.myCpuTable.getTraceInfo(request);
            response.addAllTraceInfo(responses);
            this.myLastTraceInfoResponse = new ResponseData<CpuProfiler.GetTraceInfoResponse>(request.getSession(), request.getFromTimestamp(), request.getToTimestamp(), response.build());
        }
        responseObserver.onNext((Object)this.myLastTraceInfoResponse.getResponse());
        responseObserver.onCompleted();
    }

    public void startMonitoringApp(CpuProfiler.CpuStartRequest request, StreamObserver<CpuProfiler.CpuStartResponse> observer) {
        CpuServiceGrpc.CpuServiceBlockingStub client = this.myService.getCpuClient(request.getSession().getStreamId());
        if (client != null) {
            observer.onNext((Object)client.startMonitoringApp(request));
            observer.onCompleted();
            long sessionId = request.getSession().getSessionId();
            this.myRunners.put(sessionId, new CpuDataPoller(request.getSession(), this.myCpuTable, client, this.myLogService));
            this.myFetchExecutor.accept(this.myRunners.get(sessionId));
        } else {
            observer.onNext((Object)CpuProfiler.CpuStartResponse.getDefaultInstance());
            observer.onCompleted();
        }
    }

    public void stopMonitoringApp(CpuProfiler.CpuStopRequest request, StreamObserver<CpuProfiler.CpuStopResponse> observer) {
        CpuServiceGrpc.CpuServiceBlockingStub service;
        long sessionId = request.getSession().getSessionId();
        PollRunner runner = this.myRunners.remove(sessionId);
        if (runner != null) {
            runner.stop();
        }
        if ((service = this.myService.getCpuClient(request.getSession().getStreamId())) == null) {
            observer.onNext((Object)CpuProfiler.CpuStopResponse.getDefaultInstance());
        } else {
            observer.onNext((Object)service.stopMonitoringApp(request));
        }
        observer.onCompleted();
    }

    public void startProfilingApp(CpuProfiler.CpuProfilingAppStartRequest request, StreamObserver<CpuProfiler.CpuProfilingAppStartResponse> observer) {
        CpuServiceGrpc.CpuServiceBlockingStub client = this.myService.getCpuClient(request.getSession().getStreamId());
        if (client != null) {
            observer.onNext((Object)client.startProfilingApp(request));
        } else {
            observer.onNext((Object)CpuProfiler.CpuProfilingAppStartResponse.getDefaultInstance());
        }
        observer.onCompleted();
    }

    public void stopProfilingApp(CpuProfiler.CpuProfilingAppStopRequest request, StreamObserver<CpuProfiler.CpuProfilingAppStopResponse> observer) {
        CpuServiceGrpc.CpuServiceBlockingStub client = this.myService.getCpuClient(request.getSession().getStreamId());
        CpuProfiler.CpuProfilingAppStopResponse response = CpuProfiler.CpuProfilingAppStopResponse.getDefaultInstance();
        if (client != null) {
            response = client.stopProfilingApp(request);
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void startStartupProfiling(CpuProfiler.StartupProfilingRequest request, StreamObserver<CpuProfiler.StartupProfilingResponse> observer) {
        CpuServiceGrpc.CpuServiceBlockingStub client = this.myService.getCpuClient(request.getDeviceId());
        if (client != null) {
            observer.onNext((Object)client.startStartupProfiling(request));
        } else {
            observer.onNext((Object)CpuProfiler.StartupProfilingResponse.getDefaultInstance());
        }
        observer.onCompleted();
    }

    public void getCpuCoreConfig(CpuProfiler.CpuCoreConfigRequest request, StreamObserver<CpuProfiler.CpuCoreConfigResponse> observer) {
        CpuServiceGrpc.CpuServiceBlockingStub client = this.myService.getCpuClient(request.getDeviceId());
        if (client != null) {
            observer.onNext((Object)client.getCpuCoreConfig(request));
        }
        observer.onCompleted();
    }

    @Override
    @NotNull
    public List<DataStoreService.BackingNamespace> getBackingNamespaces() {
        List<DataStoreService.BackingNamespace> list = Collections.singletonList(DataStoreService.BackingNamespace.DEFAULT_SHARED_NAMESPACE);
        if (list == null) {
            CpuService.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    public void setBackingStore(@NotNull DataStoreService.BackingNamespace namespace, @NotNull Connection connection) {
        if (namespace == null) {
            CpuService.$$$reportNull$$$0(2);
        }
        if (connection == null) {
            CpuService.$$$reportNull$$$0(3);
        }
        assert (namespace == DataStoreService.BackingNamespace.DEFAULT_SHARED_NAMESPACE);
        this.myCpuTable.initialize(connection);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStoreService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/datastore/service/CpuService";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/datastore/service/CpuService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackingNamespaces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setBackingStore";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

