/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.service;

import com.android.tools.datastore.DataStoreService;
import com.android.tools.datastore.LogService;
import com.android.tools.datastore.ServicePassThrough;
import com.android.tools.datastore.database.EnergyTable;
import com.android.tools.datastore.energy.BatteryModel;
import com.android.tools.datastore.poller.EnergyDataPoller;
import com.android.tools.datastore.poller.PollRunner;
import com.android.tools.datastore.service.ResponseData;
import com.android.tools.idea.io.grpc.stub.StreamObserver;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.CpuServiceGrpc;
import com.android.tools.profiler.proto.EnergyProfiler;
import com.android.tools.profiler.proto.EnergyServiceGrpc;
import com.android.tools.profiler.proto.NetworkServiceGrpc;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import com.google.common.annotations.VisibleForTesting;
import java.sql.Connection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class EnergyService
extends EnergyServiceGrpc.EnergyServiceImplBase
implements ServicePassThrough {
    private final BatteryModel myBatteryModel;
    private final EnergyTable myEnergyTable;
    @NotNull
    private final DataStoreService myService;
    private final Map<Long, PollRunner> myRunners;
    private final Consumer<Runnable> myFetchExecutor;
    @NotNull
    private final LogService myLogService;
    private ResponseData<EnergyProfiler.EnergySamplesResponse> myLastSamplesResponse;
    private ResponseData<EnergyProfiler.EnergyEventsResponse> myLastEventsResponse;

    public EnergyService(@NotNull DataStoreService service, @NotNull Consumer<Runnable> fetchExecutor, @NotNull LogService logService) {
        if (service == null) {
            EnergyService.$$$reportNull$$$0(0);
        }
        if (fetchExecutor == null) {
            EnergyService.$$$reportNull$$$0(1);
        }
        if (logService == null) {
            EnergyService.$$$reportNull$$$0(2);
        }
        this(new BatteryModel(), service, fetchExecutor, logService);
    }

    @VisibleForTesting
    public EnergyService(@NotNull BatteryModel batteryModel, @NotNull DataStoreService service, Consumer<Runnable> fetchExecutor, @NotNull LogService logService) {
        if (batteryModel == null) {
            EnergyService.$$$reportNull$$$0(3);
        }
        if (service == null) {
            EnergyService.$$$reportNull$$$0(4);
        }
        if (logService == null) {
            EnergyService.$$$reportNull$$$0(5);
        }
        this.myRunners = new HashMap<Long, PollRunner>();
        this.myLastSamplesResponse = ResponseData.createEmpty();
        this.myLastEventsResponse = ResponseData.createEmpty();
        this.myBatteryModel = batteryModel;
        this.myService = service;
        this.myFetchExecutor = fetchExecutor;
        this.myLogService = logService;
        this.myEnergyTable = new EnergyTable();
    }

    public void startMonitoringApp(EnergyProfiler.EnergyStartRequest request, StreamObserver<EnergyProfiler.EnergyStartResponse> responseObserver) {
        long streamId = request.getSession().getStreamId();
        EnergyServiceGrpc.EnergyServiceBlockingStub energyClient = this.myService.getEnergyClient(streamId);
        CpuServiceGrpc.CpuServiceBlockingStub cpuClient = this.myService.getCpuClient(streamId);
        NetworkServiceGrpc.NetworkServiceBlockingStub networkClient = this.myService.getNetworkClient(streamId);
        TransportServiceGrpc.TransportServiceBlockingStub transportClient = this.myService.getTransportClient(streamId);
        if (energyClient != null && transportClient != null) {
            responseObserver.onNext((Object)energyClient.startMonitoringApp(request));
            responseObserver.onCompleted();
            long sessionId = request.getSession().getSessionId();
            this.myRunners.put(sessionId, new EnergyDataPoller(request.getSession(), this.myBatteryModel, this.myEnergyTable, transportClient, cpuClient, networkClient, energyClient, this.myLogService));
            this.myFetchExecutor.accept(this.myRunners.get(sessionId));
        } else {
            responseObserver.onNext((Object)EnergyProfiler.EnergyStartResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }
    }

    public void stopMonitoringApp(EnergyProfiler.EnergyStopRequest request, StreamObserver<EnergyProfiler.EnergyStopResponse> responseObserver) {
        EnergyServiceGrpc.EnergyServiceBlockingStub client;
        long sessionId = request.getSession().getSessionId();
        PollRunner runner = this.myRunners.remove(sessionId);
        if (runner != null) {
            runner.stop();
        }
        if ((client = this.myService.getEnergyClient(request.getSession().getStreamId())) == null) {
            responseObserver.onNext((Object)EnergyProfiler.EnergyStopResponse.getDefaultInstance());
        } else {
            responseObserver.onNext((Object)client.stopMonitoringApp(request));
        }
        responseObserver.onCompleted();
    }

    public void getSamples(EnergyProfiler.EnergyRequest request, StreamObserver<EnergyProfiler.EnergySamplesResponse> responseObserver) {
        if (!this.myLastSamplesResponse.matches(request.getSession(), request.getStartTimestamp(), request.getEndTimestamp())) {
            EnergyProfiler.EnergySamplesResponse.Builder response = EnergyProfiler.EnergySamplesResponse.newBuilder();
            List<EnergyProfiler.EnergySample> samples = this.myEnergyTable.getSamples(request);
            response.addAllSamples(samples);
            this.myLastSamplesResponse = new ResponseData<EnergyProfiler.EnergySamplesResponse>(request.getSession(), request.getStartTimestamp(), request.getEndTimestamp(), response.build());
        }
        responseObserver.onNext((Object)this.myLastSamplesResponse.getResponse());
        responseObserver.onCompleted();
    }

    public void getEvents(EnergyProfiler.EnergyRequest request, StreamObserver<EnergyProfiler.EnergyEventsResponse> responseObserver) {
        if (!this.myLastEventsResponse.matches(request.getSession(), request.getStartTimestamp(), request.getEndTimestamp())) {
            EnergyProfiler.EnergyEventsResponse.Builder response = EnergyProfiler.EnergyEventsResponse.newBuilder();
            List<Common.Event> events = this.myEnergyTable.getEvents(request);
            response.addAllEvents(events);
            this.myLastEventsResponse = new ResponseData<EnergyProfiler.EnergyEventsResponse>(request.getSession(), request.getStartTimestamp(), request.getEndTimestamp(), response.build());
        }
        responseObserver.onNext((Object)this.myLastEventsResponse.getResponse());
        responseObserver.onCompleted();
    }

    public void getEventGroup(EnergyProfiler.EnergyEventGroupRequest request, StreamObserver<EnergyProfiler.EnergyEventsResponse> responseObserver) {
        EnergyProfiler.EnergyEventsResponse.Builder response = EnergyProfiler.EnergyEventsResponse.newBuilder();
        List<Common.Event> events = this.myEnergyTable.getEventGroup(request);
        response.addAllEvents(events);
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    @Override
    @NotNull
    public List<DataStoreService.BackingNamespace> getBackingNamespaces() {
        List<DataStoreService.BackingNamespace> list = Collections.singletonList(DataStoreService.BackingNamespace.DEFAULT_SHARED_NAMESPACE);
        if (list == null) {
            EnergyService.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    public void setBackingStore(@NotNull DataStoreService.BackingNamespace namespace, @NotNull Connection connection) {
        if (namespace == null) {
            EnergyService.$$$reportNull$$$0(7);
        }
        if (connection == null) {
            EnergyService.$$$reportNull$$$0(8);
        }
        assert (namespace == DataStoreService.BackingNamespace.DEFAULT_SHARED_NAMESPACE);
        this.myEnergyTable.initialize(connection);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fetchExecutor";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logService";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "batteryModel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/datastore/service/EnergyService";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/datastore/service/EnergyService";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackingNamespaces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setBackingStore";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

