/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.service;

import com.android.tools.datastore.DataStoreService;
import com.android.tools.datastore.ServicePassThrough;
import com.android.tools.datastore.database.EventsTable;
import com.android.tools.datastore.poller.EventDataPoller;
import com.android.tools.datastore.poller.PollRunner;
import com.android.tools.idea.io.grpc.stub.StreamObserver;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.EventProfiler;
import com.android.tools.profiler.proto.EventServiceGrpc;
import java.sql.Connection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class EventService
extends EventServiceGrpc.EventServiceImplBase
implements ServicePassThrough {
    private static final int INCLUDED_STATE_CHANGES_BEFORE_START_COUNT = 3;
    private final EventsTable myEventsTable;
    private final Map<Long, PollRunner> myRunners;
    private final Consumer<Runnable> myFetchExecutor;
    private final DataStoreService myService;

    public EventService(@NotNull DataStoreService dataStoreService, Consumer<Runnable> fetchExecutor) {
        if (dataStoreService == null) {
            EventService.$$$reportNull$$$0(0);
        }
        this.myRunners = new HashMap<Long, PollRunner>();
        this.myFetchExecutor = fetchExecutor;
        this.myService = dataStoreService;
        this.myEventsTable = new EventsTable();
    }

    public void getActivityData(EventProfiler.EventDataRequest request, StreamObserver<EventProfiler.ActivityDataResponse> responseObserver) {
        EventProfiler.ActivityDataResponse.Builder response = EventProfiler.ActivityDataResponse.newBuilder();
        Common.Session session = request.getSession();
        List<EventProfiler.ActivityData> activities = this.myEventsTable.getActivityDataBySession(session);
        for (EventProfiler.ActivityData data : activities) {
            EventProfiler.ActivityStateData state;
            int firstIndexGreaterThanStart;
            EventProfiler.ActivityData.Builder builder = EventProfiler.ActivityData.newBuilder();
            builder.setName(data.getName());
            builder.setHash(data.getHash());
            builder.setActivityContextHash(data.getActivityContextHash());
            for (firstIndexGreaterThanStart = 0; firstIndexGreaterThanStart < data.getStateChangesCount() && data.getStateChanges(firstIndexGreaterThanStart).getTimestamp() < request.getStartTimestamp(); ++firstIndexGreaterThanStart) {
            }
            for (int i = firstIndexGreaterThanStart = Math.max(0, firstIndexGreaterThanStart - 3); i < data.getStateChangesCount() && (state = data.getStateChanges(i)).getTimestamp() <= request.getEndTimestamp(); ++i) {
                builder.addStateChanges(state);
            }
            response.addData(builder);
        }
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void getSystemData(EventProfiler.EventDataRequest request, StreamObserver<EventProfiler.SystemDataResponse> responseObserver) {
        EventProfiler.SystemDataResponse.Builder response = EventProfiler.SystemDataResponse.newBuilder();
        List<EventProfiler.SystemData> systemData = this.myEventsTable.getSystemDataByRequest(request);
        for (EventProfiler.SystemData data : systemData) {
            response.addData(data);
        }
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void startMonitoringApp(EventProfiler.EventStartRequest request, StreamObserver<EventProfiler.EventStartResponse> observer) {
        EventServiceGrpc.EventServiceBlockingStub client = this.myService.getEventClient(request.getSession().getStreamId());
        if (client != null) {
            observer.onNext((Object)client.startMonitoringApp(request));
            observer.onCompleted();
            Common.Session session = request.getSession();
            this.myRunners.put(session.getSessionId(), new EventDataPoller(session, this.myEventsTable, client));
            this.myFetchExecutor.accept(this.myRunners.get(session.getSessionId()));
        } else {
            observer.onNext((Object)EventProfiler.EventStartResponse.getDefaultInstance());
            observer.onCompleted();
        }
    }

    public void stopMonitoringApp(EventProfiler.EventStopRequest request, StreamObserver<EventProfiler.EventStopResponse> observer) {
        EventServiceGrpc.EventServiceBlockingStub client;
        long sessionId = request.getSession().getSessionId();
        PollRunner runner = this.myRunners.remove(sessionId);
        if (runner != null) {
            runner.stop();
        }
        if ((client = this.myService.getEventClient(request.getSession().getStreamId())) == null) {
            observer.onNext((Object)EventProfiler.EventStopResponse.getDefaultInstance());
        } else {
            observer.onNext((Object)client.stopMonitoringApp(request));
        }
        observer.onCompleted();
    }

    @Override
    @NotNull
    public List<DataStoreService.BackingNamespace> getBackingNamespaces() {
        List<DataStoreService.BackingNamespace> list = Collections.singletonList(DataStoreService.BackingNamespace.DEFAULT_SHARED_NAMESPACE);
        if (list == null) {
            EventService.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    public void setBackingStore(@NotNull DataStoreService.BackingNamespace namespace, @NotNull Connection connection) {
        if (namespace == null) {
            EventService.$$$reportNull$$$0(2);
        }
        if (connection == null) {
            EventService.$$$reportNull$$$0(3);
        }
        assert (namespace == DataStoreService.BackingNamespace.DEFAULT_SHARED_NAMESPACE);
        this.myEventsTable.initialize(connection);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStoreService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/datastore/service/EventService";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/datastore/service/EventService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackingNamespaces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setBackingStore";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

