/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.flat.FlatComboBox;
import com.android.tools.adtui.flat.FlatSeparator;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.StreamingTimeline;
import com.android.tools.adtui.model.ViewBinder;
import com.android.tools.adtui.stdui.CommonButton;
import com.android.tools.adtui.stdui.CommonToggleButton;
import com.android.tools.adtui.stdui.ContextMenuItem;
import com.android.tools.adtui.stdui.DefaultContextMenuItem;
import com.android.tools.adtui.stdui.TooltipLayeredPane;
import com.android.tools.inspectors.common.ui.ContextMenuInstaller;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.JComboBoxView;
import com.android.tools.profilers.NullMonitorStage;
import com.android.tools.profilers.NullMonitorStageView;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerContextMenu;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StageView;
import com.android.tools.profilers.StudioMonitorStage;
import com.android.tools.profilers.StudioMonitorStageView;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.cpu.CpuCaptureStage;
import com.android.tools.profilers.cpu.CpuCaptureStageView;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuProfilerStageView;
import com.android.tools.profilers.customevent.CustomEventProfilerStage;
import com.android.tools.profilers.customevent.CustomEventProfilerStageView;
import com.android.tools.profilers.energy.EnergyProfilerStage;
import com.android.tools.profilers.energy.EnergyProfilerStageView;
import com.android.tools.profilers.memory.AllocationStage;
import com.android.tools.profilers.memory.AllocationStageView;
import com.android.tools.profilers.memory.MainMemoryProfilerStage;
import com.android.tools.profilers.memory.MainMemoryProfilerStageView;
import com.android.tools.profilers.memory.MemoryCaptureStage;
import com.android.tools.profilers.memory.MemoryCaptureStageView;
import com.android.tools.profilers.sessions.SessionAspect;
import com.android.tools.profilers.sessions.SessionsView;
import com.android.tools.profilers.stacktrace.LoadingPanel;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class SessionProfilersView
extends StudioProfilersView {
    private static final int SHORTCUT_MODIFIER_MASK_NUMBER = SystemInfo.isMac ? 256 : 128;
    private final ViewBinder<SessionProfilersView, Stage, StageView> myBinder;
    @NotNull
    private final TooltipLayeredPane myLayeredPane;
    @NotNull
    private final ThreeComponentsSplitter mySplitter;
    @NotNull
    private final LoadingPanel myStageLoadingPanel;
    private final JPanel myStageComponent;
    private final JPanel myStageCenterComponent;
    private final CardLayout myStageCenterCardLayout;
    private SessionsView mySessionsView;
    private JPanel myToolbar;
    private JPanel myStageToolbar;
    private JPanel myCommonToolbar;
    private JPanel myGoLiveToolbar;
    private JPanel myRightToolbar;
    private JToggleButton myGoLive;
    private CommonButton myZoomOut;
    private CommonButton myZoomIn;
    private CommonButton myResetZoom;
    private CommonButton myZoomToSelection;
    private CommonButton myBack;
    private DefaultContextMenuItem myZoomToSelectionAction;

    public SessionProfilersView(@NotNull StudioProfilers profiler, @NotNull IdeProfilerComponents ideProfilerComponents, @NotNull Disposable parentDisposable) {
        if (profiler == null) {
            SessionProfilersView.$$$reportNull$$$0(0);
        }
        if (ideProfilerComponents == null) {
            SessionProfilersView.$$$reportNull$$$0(1);
        }
        if (parentDisposable == null) {
            SessionProfilersView.$$$reportNull$$$0(2);
        }
        super(profiler, ideProfilerComponents);
        this.myStageComponent = new JPanel(new BorderLayout());
        this.myStageCenterCardLayout = new CardLayout();
        this.myStageCenterComponent = new JPanel(this.myStageCenterCardLayout);
        this.myStageLoadingPanel = this.myIdeProfilerComponents.createLoadingPanel(0);
        this.myStageLoadingPanel.setLoadingText("");
        this.myStageLoadingPanel.getComponent().setBackground(ProfilerColors.DEFAULT_BACKGROUND);
        this.mySplitter = new ThreeComponentsSplitter((Disposable)this);
        this.mySplitter.setFocusTraversalPolicy((FocusTraversalPolicy)new LayoutFocusTraversalPolicy());
        this.mySplitter.setDividerWidth(0);
        this.mySplitter.setDividerMouseZoneSize(-1);
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.mySplitter.setLastComponent((JComponent)this.myStageComponent);
        this.myLayeredPane = new TooltipLayeredPane((JComponent)this.mySplitter);
        this.initializeSessionUi();
        this.initializeStageUi();
        this.myBinder = new ViewBinder();
        this.myBinder.bind(StudioMonitorStage.class, StudioMonitorStageView::new);
        this.myBinder.bind(CpuProfilerStage.class, CpuProfilerStageView::new);
        this.myBinder.bind(CpuCaptureStage.class, CpuCaptureStageView::new);
        this.myBinder.bind(MainMemoryProfilerStage.class, MainMemoryProfilerStageView::new);
        this.myBinder.bind(MemoryCaptureStage.class, MemoryCaptureStageView::new);
        this.myBinder.bind(AllocationStage.class, AllocationStageView::new);
        this.myBinder.bind(NullMonitorStage.class, NullMonitorStageView::new);
        this.myBinder.bind(EnergyProfilerStage.class, EnergyProfilerStageView::new);
        this.myBinder.bind(CustomEventProfilerStage.class, CustomEventProfilerStageView::new);
        this.myProfiler.addDependency(this).onChange((Enum)ProfilerAspect.STAGE, this::updateStageView).onChange((Enum)ProfilerAspect.AGENT, this::toggleStageLayout).onChange((Enum)ProfilerAspect.PREFERRED_PROCESS, this::toggleStageLayout);
        this.updateStageView();
        this.toggleStageLayout();
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    public void dispose() {
    }

    @VisibleForTesting
    <S extends Stage, T extends StageView> void bind(@NotNull Class<S> clazz, @NotNull BiFunction<SessionProfilersView, S, T> constructor) {
        if (clazz == null) {
            SessionProfilersView.$$$reportNull$$$0(3);
        }
        if (constructor == null) {
            SessionProfilersView.$$$reportNull$$$0(4);
        }
        this.myBinder.bind(clazz, constructor);
    }

    @VisibleForTesting
    @NotNull
    CommonButton getZoomInButton() {
        CommonButton commonButton = this.myZoomIn;
        if (commonButton == null) {
            SessionProfilersView.$$$reportNull$$$0(5);
        }
        return commonButton;
    }

    @VisibleForTesting
    @NotNull
    CommonButton getZoomOutButton() {
        CommonButton commonButton = this.myZoomOut;
        if (commonButton == null) {
            SessionProfilersView.$$$reportNull$$$0(6);
        }
        return commonButton;
    }

    @VisibleForTesting
    @NotNull
    CommonButton getResetZoomButton() {
        CommonButton commonButton = this.myResetZoom;
        if (commonButton == null) {
            SessionProfilersView.$$$reportNull$$$0(7);
        }
        return commonButton;
    }

    @VisibleForTesting
    @NotNull
    public CommonButton getZoomToSelectionButton() {
        CommonButton commonButton = this.myZoomToSelection;
        if (commonButton == null) {
            SessionProfilersView.$$$reportNull$$$0(8);
        }
        return commonButton;
    }

    @VisibleForTesting
    @NotNull
    JToggleButton getGoLiveButton() {
        JToggleButton jToggleButton = this.myGoLive;
        if (jToggleButton == null) {
            SessionProfilersView.$$$reportNull$$$0(9);
        }
        return jToggleButton;
    }

    @VisibleForTesting
    @NotNull
    public CommonButton getBackButton() {
        CommonButton commonButton = this.myBack;
        if (commonButton == null) {
            SessionProfilersView.$$$reportNull$$$0(10);
        }
        return commonButton;
    }

    @VisibleForTesting
    @NotNull
    SessionsView getSessionsView() {
        SessionsView sessionsView = this.mySessionsView;
        if (sessionsView == null) {
            SessionProfilersView.$$$reportNull$$$0(11);
        }
        return sessionsView;
    }

    @VisibleForTesting
    @NotNull
    JPanel getRightToolbar() {
        JPanel jPanel = this.myRightToolbar;
        if (jPanel == null) {
            SessionProfilersView.$$$reportNull$$$0(12);
        }
        return jPanel;
    }

    private void initializeSessionUi() {
        this.mySessionsView = new SessionsView(this.myProfiler, this.myIdeProfilerComponents);
        final JComponent sessionsComponent = this.mySessionsView.getComponent();
        this.mySplitter.setFirstComponent(sessionsComponent);
        this.mySessionsView.addExpandListener(e -> {
            this.toggleSessionsPanel(false);
            this.myProfiler.getIdeServices().getFeatureTracker().trackSessionsPanelStateChanged(true);
        });
        this.mySessionsView.addCollapseListener(e -> {
            this.toggleSessionsPanel(true);
            this.myProfiler.getIdeServices().getFeatureTracker().trackSessionsPanelStateChanged(false);
        });
        boolean initiallyCollapsed = this.myProfiler.getIdeServices().getPersistentProfilerPreferences().getBoolean("SESSION_IS_COLLAPSED", false);
        this.toggleSessionsPanel(initiallyCollapsed);
        new UiNotifyConnector.Once((Component)this.mySplitter, new Activatable(){

            public void showNotify() {
                IdeGlassPane glassPane = IdeGlassPaneUtil.find((Component)SessionProfilersView.this.mySplitter);
                glassPane.addMousePreprocessor((MouseListener)new MouseAdapter(){
                    private int mySessionsUiWidth;

                    @Override
                    public void mousePressed(MouseEvent e) {
                        this.mySessionsUiWidth = sessionsComponent.getWidth();
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        int width = sessionsComponent.getWidth();
                        if (this.mySessionsUiWidth != width) {
                            SessionProfilersView.this.myProfiler.getIdeServices().getPersistentProfilerPreferences().setInt("SESSION_EXPANDED_WIDTH", width);
                            SessionProfilersView.this.myProfiler.getIdeServices().getFeatureTracker().trackSessionsPanelResized();
                        }
                    }
                }, (Disposable)SessionProfilersView.this.mySplitter);
            }
        });
    }

    private void initializeStageUi() {
        this.myToolbar = new JPanel(new BorderLayout());
        JPanel leftToolbar = new JPanel(ProfilerLayout.createToolbarLayout());
        this.myToolbar.setBorder(AdtUiUtils.DEFAULT_BOTTOM_BORDER);
        this.myToolbar.setPreferredSize(new Dimension(0, ProfilerLayout.TOOLBAR_HEIGHT));
        this.myCommonToolbar = new JPanel(ProfilerLayout.createToolbarLayout());
        this.myBack = new CommonButton(AllIcons.Actions.Back);
        this.myBack.addActionListener(action -> this.confirmExit("Go back?", () -> {
            this.myProfiler.setStage(this.myProfiler.getStage().getParentStage());
            this.getStudioProfilers().getSessionsManager().resetSelectedArtifactProto();
            this.myProfiler.getIdeServices().getFeatureTracker().trackGoBack();
        }));
        this.myCommonToolbar.add((Component)this.myBack);
        this.myCommonToolbar.add((Component)new FlatSeparator());
        FlatComboBox stageCombo = new FlatComboBox();
        Supplier getSupportedStages = () -> this.getStudioProfilers().getDirectStages().stream().filter(st -> this.getStudioProfilers().getSelectedSessionSupportLevel().isStageSupported((Class<? extends Stage<?>>)st)).collect(Collectors.toList());
        JComboBoxView<Class, ProfilerAspect> stages = new JComboBoxView<Class, ProfilerAspect>((JComboBox<Class>)stageCombo, this.myProfiler, ProfilerAspect.STAGE, getSupportedStages, this.myProfiler::getStageClass, stage -> this.confirmExit("Exit?", () -> {
            this.myProfiler.getIdeServices().getFeatureTracker().trackSelectMonitor();
            this.myProfiler.setNewStage((Class<? extends Stage>)stage);
        }), () -> this.myProfiler.getStage().getHomeStageClass());
        stageCombo.setRenderer(new StageComboBoxRenderer());
        stages.bind();
        this.myCommonToolbar.add((Component)stageCombo);
        this.myCommonToolbar.add((Component)new FlatSeparator());
        leftToolbar.add(this.myCommonToolbar);
        this.myToolbar.add((Component)leftToolbar, "West");
        this.myRightToolbar = new JPanel(ProfilerLayout.createToolbarLayout());
        this.myToolbar.add((Component)this.myRightToolbar, "East");
        this.myRightToolbar.setBorder((Border)new JBEmptyBorder(0, 0, 0, 2));
        this.myZoomOut = new CommonButton(AllIcons.General.ZoomOut);
        this.myZoomOut.setDisabledIcon(IconLoader.getDisabledIcon((Icon)AllIcons.General.ZoomOut));
        this.myZoomOut.addActionListener(event -> {
            ((Stage)((Object)((Object)this.myStageView.getStage()))).getTimeline().zoomOut();
            this.myProfiler.getIdeServices().getFeatureTracker().trackZoomOut();
        });
        DefaultContextMenuItem zoomOutAction = new DefaultContextMenuItem.Builder("Zoom out").setContainerComponent((JComponent)this.mySplitter).setActionRunnable(() -> this.myZoomOut.doClick(0)).setKeyStrokes(new KeyStroke[]{KeyStroke.getKeyStroke(45, SHORTCUT_MODIFIER_MASK_NUMBER), KeyStroke.getKeyStroke(109, SHORTCUT_MODIFIER_MASK_NUMBER)}).build();
        this.myZoomOut.setToolTipText(zoomOutAction.getDefaultToolTipText());
        this.myRightToolbar.add((Component)this.myZoomOut);
        this.myZoomIn = new CommonButton(AllIcons.General.ZoomIn);
        this.myZoomIn.setDisabledIcon(IconLoader.getDisabledIcon((Icon)AllIcons.General.ZoomIn));
        this.myZoomIn.addActionListener(event -> {
            ((Stage)((Object)((Object)this.myStageView.getStage()))).getTimeline().zoomIn();
            this.myProfiler.getIdeServices().getFeatureTracker().trackZoomIn();
        });
        DefaultContextMenuItem zoomInAction = new DefaultContextMenuItem.Builder("Zoom in").setContainerComponent((JComponent)this.mySplitter).setActionRunnable(() -> this.myZoomIn.doClick(0)).setKeyStrokes(new KeyStroke[]{KeyStroke.getKeyStroke(521, SHORTCUT_MODIFIER_MASK_NUMBER), KeyStroke.getKeyStroke(61, SHORTCUT_MODIFIER_MASK_NUMBER), KeyStroke.getKeyStroke(107, SHORTCUT_MODIFIER_MASK_NUMBER)}).build();
        this.myZoomIn.setToolTipText(zoomInAction.getDefaultToolTipText());
        this.myRightToolbar.add((Component)this.myZoomIn);
        this.myResetZoom = new CommonButton(StudioIcons.Common.RESET_ZOOM);
        this.myResetZoom.setDisabledIcon(IconLoader.getDisabledIcon((Icon)StudioIcons.Common.RESET_ZOOM));
        this.myResetZoom.addActionListener(event -> {
            ((Stage)((Object)((Object)this.myStageView.getStage()))).getTimeline().resetZoom();
            this.myProfiler.getIdeServices().getFeatureTracker().trackResetZoom();
        });
        DefaultContextMenuItem resetZoomAction = new DefaultContextMenuItem.Builder("Reset zoom").setContainerComponent((JComponent)this.mySplitter).setActionRunnable(() -> this.myResetZoom.doClick(0)).setKeyStrokes(new KeyStroke[]{KeyStroke.getKeyStroke(96, 0), KeyStroke.getKeyStroke(48, 0)}).build();
        this.myResetZoom.setToolTipText(resetZoomAction.getDefaultToolTipText());
        this.myRightToolbar.add((Component)this.myResetZoom);
        this.myZoomToSelection = new CommonButton(StudioIcons.Common.ZOOM_SELECT);
        this.myZoomToSelection.setDisabledIcon(IconLoader.getDisabledIcon((Icon)StudioIcons.Common.ZOOM_SELECT));
        this.myZoomToSelection.addActionListener(event -> {
            ((Stage)((Object)((Object)this.myStageView.getStage()))).getTimeline().frameViewToRange(((Stage)((Object)((Object)this.myStageView.getStage()))).getTimeline().getSelectionRange());
            this.myProfiler.getIdeServices().getFeatureTracker().trackZoomToSelection();
        });
        this.myZoomToSelectionAction = new DefaultContextMenuItem.Builder("Zoom to Selection").setContainerComponent((JComponent)this.mySplitter).setActionRunnable(() -> this.myZoomToSelection.doClick(0)).setEnableBooleanSupplier(() -> this.myStageView != null && !((Stage)((Object)((Object)this.myStageView.getStage()))).getTimeline().getSelectionRange().isEmpty()).setKeyStrokes(new KeyStroke[]{KeyStroke.getKeyStroke(77, 0)}).build();
        this.myZoomToSelection.setToolTipText(this.myZoomToSelectionAction.getDefaultToolTipText());
        this.myRightToolbar.add((Component)this.myZoomToSelection);
        this.myGoLiveToolbar = new JPanel(ProfilerLayout.createToolbarLayout());
        this.myGoLiveToolbar.add((Component)new FlatSeparator());
        this.myGoLive = new CommonToggleButton("", StudioIcons.Profiler.Toolbar.GOTO_LIVE);
        this.myGoLive.setDisabledIcon(IconLoader.getDisabledIcon((Icon)StudioIcons.Profiler.Toolbar.GOTO_LIVE));
        this.myGoLive.setFont(ProfilerFonts.H4_FONT);
        this.myGoLive.setHorizontalTextPosition(2);
        this.myGoLive.setHorizontalAlignment(2);
        this.myGoLive.setBorder((Border)new JBEmptyBorder(3, 7, 3, 7));
        DefaultContextMenuItem attachAction = new DefaultContextMenuItem.Builder("Attach to live").setContainerComponent((JComponent)this.mySplitter).setActionRunnable(() -> this.myGoLive.doClick(0)).setEnableBooleanSupplier(() -> this.myGoLive.isEnabled() && !this.myGoLive.isSelected() && this.myStageView.supportsStreaming()).setKeyStrokes(new KeyStroke[]{KeyStroke.getKeyStroke(39, SHORTCUT_MODIFIER_MASK_NUMBER)}).build();
        DefaultContextMenuItem detachAction = new DefaultContextMenuItem.Builder("Detach live").setContainerComponent((JComponent)this.mySplitter).setActionRunnable(() -> this.myGoLive.doClick(0)).setEnableBooleanSupplier(() -> this.myGoLive.isEnabled() && this.myGoLive.isSelected() && this.myStageView.supportsStreaming()).setKeyStrokes(new KeyStroke[]{KeyStroke.getKeyStroke(32, 0)}).build();
        this.myGoLive.setToolTipText(detachAction.getDefaultToolTipText());
        this.myGoLive.addActionListener(event -> {
            Object currentStageTimeline = ((Stage)((Object)((Object)this.myStageView.getStage()))).getTimeline();
            if (currentStageTimeline instanceof StreamingTimeline) {
                ((StreamingTimeline)currentStageTimeline).toggleStreaming();
                this.myProfiler.getIdeServices().getFeatureTracker().trackToggleStreaming();
            }
        });
        this.myGoLive.addChangeListener(e -> {
            boolean isSelected = this.myGoLive.isSelected();
            this.myGoLive.setIcon(isSelected ? StudioIcons.Profiler.Toolbar.PAUSE_LIVE : StudioIcons.Profiler.Toolbar.GOTO_LIVE);
            this.myGoLive.setToolTipText(isSelected ? detachAction.getDefaultToolTipText() : attachAction.getDefaultToolTipText());
        });
        this.myProfiler.getTimeline().addDependency((AspectObserver)this).onChange((Enum)StreamingTimeline.Aspect.STREAMING, this::updateStreaming);
        this.myGoLiveToolbar.add(this.myGoLive);
        this.myRightToolbar.add(this.myGoLiveToolbar);
        ProfilerContextMenu.createIfAbsent(this.myStageComponent).add(new ContextMenuItem[]{attachAction, detachAction, ContextMenuItem.SEPARATOR, zoomInAction, zoomOutAction});
        this.myProfiler.getSessionsManager().addDependency(this).onChange((Enum)SessionAspect.SELECTED_SESSION, this::toggleTimelineButtons);
        this.toggleTimelineButtons();
        this.myStageToolbar = new JPanel(new BorderLayout());
        this.myToolbar.add((Component)this.myStageToolbar, "Center");
        this.myStageComponent.add((Component)this.myToolbar, "North");
        this.myStageComponent.add((Component)this.myStageCenterComponent, "Center");
        this.updateStreaming();
    }

    private void confirmExit(String title, Runnable exit) {
        String msg = this.myProfiler.getStage().getConfirmExitMessage();
        if (msg != null) {
            this.getStudioProfilers().getIdeServices().openYesNoDialog(msg, title, exit, () -> {});
        } else {
            exit.run();
        }
    }

    private void toggleTimelineButtons() {
        boolean isAlive = this.myProfiler.getSessionsManager().isSessionAlive();
        if (isAlive) {
            boolean waitForAgent;
            Common.AgentData agentData = this.myProfiler.getAgentData();
            boolean bl = waitForAgent = agentData.getStatus() == Common.AgentData.Status.UNSPECIFIED;
            if (waitForAgent) {
                this.myZoomOut.setEnabled(false);
                this.myZoomIn.setEnabled(false);
                this.myResetZoom.setEnabled(false);
                this.myZoomToSelection.setEnabled(false);
                this.myGoLive.setEnabled(false);
                this.myGoLive.setSelected(false);
            } else {
                this.myZoomOut.setEnabled(true);
                this.myZoomIn.setEnabled(true);
                this.myResetZoom.setEnabled(true);
                this.myZoomToSelection.setEnabled(this.myZoomToSelectionAction.isEnabled());
                this.myGoLive.setEnabled(true);
                this.myGoLive.setSelected(true);
            }
        } else {
            boolean isValidSession = !Common.Session.getDefaultInstance().equals((Object)this.myProfiler.getSessionsManager().getSelectedSession());
            this.myZoomOut.setEnabled(isValidSession);
            this.myZoomIn.setEnabled(isValidSession);
            this.myResetZoom.setEnabled(isValidSession);
            this.myZoomToSelection.setEnabled(isValidSession && this.myZoomToSelectionAction.isEnabled());
            this.myGoLive.setEnabled(false);
            this.myGoLive.setSelected(false);
        }
    }

    private void toggleSessionsPanel(boolean isCollapsed) {
        if (isCollapsed) {
            this.mySplitter.setDividerMouseZoneSize(-1);
            this.mySessionsView.getComponent().setMinimumSize(SessionsView.getComponentMinimizeSize(false));
            this.mySplitter.setFirstSize(0);
        } else {
            this.mySplitter.setDividerMouseZoneSize(JBUIScale.scale((int)10));
            this.mySessionsView.getComponent().setMinimumSize(SessionsView.getComponentMinimizeSize(true));
            this.mySplitter.setFirstSize(this.myProfiler.getIdeServices().getPersistentProfilerPreferences().getInt("SESSION_EXPANDED_WIDTH", 0));
        }
        this.mySplitter.revalidate();
        this.mySplitter.repaint();
    }

    private void updateStreaming() {
        this.myGoLive.setSelected(this.myProfiler.getTimeline().isStreaming());
    }

    private void updateStageView() {
        Stage stage = this.myProfiler.getStage();
        if (this.myStageView != null && this.myStageView.getStage() == stage) {
            return;
        }
        if (this.myStageView != null) {
            ((Stage)((Object)this.myStageView.getStage())).getTimeline().getSelectionRange().removeDependencies((AspectObserver)this);
        }
        this.myStageView = (StageView)((Object)this.myBinder.build((Object)this, (Object)stage));
        ((Stage)((Object)this.myStageView.getStage())).getTimeline().getSelectionRange().addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, () -> this.myZoomToSelection.setEnabled(this.myZoomToSelectionAction.isEnabled()));
        SwingUtilities.invokeLater(() -> {
            Component focussed = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (focussed == null || !SwingUtilities.isDescendingFrom(focussed, (Component)this.mySplitter)) {
                this.mySplitter.requestFocusInWindow();
            }
        });
        this.myStageCenterComponent.removeAll();
        this.myStageCenterComponent.add((Component)this.myStageView.getComponent(), "StageViewCard");
        this.myStageCenterComponent.add((Component)this.myStageLoadingPanel.getComponent(), "LoadingViewCard");
        this.myStageCenterComponent.revalidate();
        this.myStageToolbar.removeAll();
        this.myStageToolbar.add((Component)this.myStageView.getToolbar(), "Center");
        this.myStageToolbar.revalidate();
        this.myToolbar.setVisible(this.myStageView.isToolbarVisible());
        this.myGoLiveToolbar.setVisible(this.myStageView.supportsStreaming());
        boolean topLevel = this.myStageView == null || this.myStageView.needsProcessSelection();
        this.myCommonToolbar.setVisible(!topLevel && this.myStageView.supportsStageNavigation());
        this.myRightToolbar.setVisible(stage.isInteractingWithTimeline());
    }

    private void toggleStageLayout() {
        boolean loading = this.myProfiler.getAutoProfilingEnabled() && this.myProfiler.getPreferredProcessName() != null && !this.myProfiler.getSessionsManager().isSessionAlive();
        Common.AgentData agentData = this.myProfiler.getAgentData();
        loading |= agentData.getStatus() == Common.AgentData.Status.UNSPECIFIED && this.myProfiler.getSessionsManager().isSessionAlive();
        if (loading &= this.myProfiler.getDevice() != null && this.myProfiler.getDevice().getUnsupportedReason().isEmpty()) {
            this.myStageLoadingPanel.startLoading();
            this.myStageCenterCardLayout.show(this.myStageCenterComponent, "LoadingViewCard");
        } else {
            this.myStageLoadingPanel.stopLoading();
            this.myStageCenterCardLayout.show(this.myStageCenterComponent, "StageViewCard");
        }
        this.toggleTimelineButtons();
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        TooltipLayeredPane tooltipLayeredPane = this.myLayeredPane;
        if (tooltipLayeredPane == null) {
            SessionProfilersView.$$$reportNull$$$0(13);
        }
        return tooltipLayeredPane;
    }

    @Override
    public void installCommonMenuItems(@NotNull JComponent component) {
        if (component == null) {
            SessionProfilersView.$$$reportNull$$$0(14);
        }
        ContextMenuInstaller contextMenuInstaller = this.getIdeProfilerComponents().createContextMenuInstaller();
        ProfilerContextMenu.createIfAbsent(this.myStageComponent).getContextMenuItems().forEach(item -> contextMenuInstaller.installGenericContextMenu(component, item));
    }

    @Override
    @VisibleForTesting
    public final JPanel getStageComponent() {
        return this.myStageComponent;
    }

    @VisibleForTesting
    final JComponent getStageLoadingComponent() {
        return this.myStageLoadingPanel.getComponent();
    }

    @VisibleForTesting
    final JComponent getStageViewComponent() {
        return this.myStageView.getComponent();
    }

    @VisibleForTesting
    public JPanel getCommonToolbar() {
        return this.myCommonToolbar;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8, 9, 10, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profiler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideProfilerComponents";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/SessionProfilersView";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/SessionProfilersView";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getZoomInButton";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getZoomOutButton";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getResetZoomButton";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getZoomToSelectionButton";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getGoLiveButton";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackButton";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessionsView";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRightToolbar";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "bind";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "installCommonMenuItems";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8, 9, 10, 11, 12, 13 -> new IllegalStateException(string);
        };
    }

    @VisibleForTesting
    public static class StageComboBoxRenderer
    extends ColoredListCellRenderer<Class> {
        private static ImmutableMap<Class<? extends Stage>, String> CLASS_TO_NAME = ImmutableMap.of(CpuProfilerStage.class, (Object)"CPU", MainMemoryProfilerStage.class, (Object)"MEMORY", EnergyProfilerStage.class, (Object)"ENERGY", CustomEventProfilerStage.class, (Object)"CUSTOM EVENTS");

        protected void customizeCellRenderer(@NotNull JList list, Class value, int index, boolean selected, boolean hasFocus) {
            String name;
            if (list == null) {
                StageComboBoxRenderer.$$$reportNull$$$0(0);
            }
            this.append((name = (String)CLASS_TO_NAME.get((Object)value)) == null ? "[UNKNOWN]" : name, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/profilers/SessionProfilersView$StageComboBoxRenderer", "customizeCellRenderer"));
        }
    }
}

