/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.adtui.model.TooltipModel;
import com.android.tools.profilers.LogUtils;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.StudioMonitorStage;
import com.android.tools.profilers.StudioProfilers;
import com.google.wireless.android.sdk.stats.AndroidProfilerEvent;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Stage<T extends Timeline>
extends AspectObserver {
    protected static final long PROFILING_INSTRUCTIONS_EASE_OUT_NS = TimeUnit.SECONDS.toNanos(3L);
    private final StudioProfilers myProfilers;
    @Nullable
    private TooltipModel myTooltip;

    public Stage(@NotNull StudioProfilers profilers) {
        if (profilers == null) {
            Stage.$$$reportNull$$$0(0);
        }
        this.myProfilers = profilers;
    }

    @NotNull
    public StudioProfilers getStudioProfilers() {
        StudioProfilers studioProfilers = this.myProfilers;
        if (studioProfilers == null) {
            Stage.$$$reportNull$$$0(1);
        }
        return studioProfilers;
    }

    @NotNull
    public abstract T getTimeline();

    public abstract void enter();

    public abstract void exit();

    public abstract AndroidProfilerEvent.Stage getStageType();

    @Nullable
    public TooltipModel getTooltip() {
        return this.myTooltip;
    }

    public void setTooltip(TooltipModel tooltip) {
        if (tooltip != null && this.myTooltip != null && tooltip.getClass().equals(this.myTooltip.getClass())) {
            return;
        }
        if (this.myTooltip != null) {
            this.myTooltip.dispose();
        }
        this.myTooltip = tooltip;
        this.getStudioProfilers().changed(ProfilerAspect.TOOLTIP);
    }

    @NotNull
    public Stage<?> getParentStage() {
        return new StudioMonitorStage(this.getStudioProfilers());
    }

    @NotNull
    public Class<? extends Stage> getHomeStageClass() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        if (clazz == null) {
            Stage.$$$reportNull$$$0(2);
        }
        return clazz;
    }

    @Nullable
    public String getConfirmExitMessage() {
        return null;
    }

    public boolean isInteractingWithTimeline() {
        return true;
    }

    protected void logEnterStage() {
        LogUtils.logIfVerbose(this.myProfilers.getIdeServices(), ((Object)((Object)this)).getClass(), "Enter " + ((Object)((Object)this)).getClass().getSimpleName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/Stage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/Stage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStudioProfilers";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomeStageClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

